/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.maxEntropy;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.MaxEntropy.class, priority=100.0)
public class ComputeMaxEntropyThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.MaxEntropy {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        int ih;
        long[] histogram = hist.toLongArray();
        int threshold = -1;
        double[] norm_histo = new double[histogram.length];
        double[] P1 = new double[histogram.length];
        double[] P2 = new double[histogram.length];
        int total = 0;
        for (ih = 0; ih < histogram.length; ++ih) {
            total = (int)((long)total + histogram[ih]);
        }
        for (ih = 0; ih < histogram.length; ++ih) {
            norm_histo[ih] = (double)histogram[ih] / (double)total;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        for (ih = 1; ih < histogram.length; ++ih) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
        }
        int first_bin = 0;
        for (ih = 0; ih < histogram.length; ++ih) {
            if (Math.abs(P1[ih]) < 2.220446049250313E-16) continue;
            first_bin = ih;
            break;
        }
        int last_bin = histogram.length - 1;
        for (ih = histogram.length - 1; ih >= first_bin; --ih) {
            if (Math.abs(P2[ih]) < 2.220446049250313E-16) continue;
            last_bin = ih;
            break;
        }
        double max_ent = Double.NEGATIVE_INFINITY;
        for (int it = first_bin; it <= last_bin; ++it) {
            double ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                if (histogram[ih] == 0L) continue;
                ent_back -= norm_histo[ih] / P1[it] * Math.log(norm_histo[ih] / P1[it]);
            }
            double ent_obj = 0.0;
            for (ih = it + 1; ih < histogram.length; ++ih) {
                if (histogram[ih] == 0L) continue;
                ent_obj -= norm_histo[ih] / P2[it] * Math.log(norm_histo[ih] / P2[it]);
            }
            double tot_ent = ent_back + ent_obj;
            if (!(max_ent < tot_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        return threshold;
    }
}

