/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.search;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpService;
import net.imagej.ops.search.OpSearchResult;
import org.scijava.app.AppService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;

@Plugin(type=Searcher.class, priority=9999.0)
public class OpSearcher
implements Searcher {
    @Parameter
    private OpService opService;
    @Parameter
    private AppService appService;

    public String title() {
        return "Ops";
    }

    public List<SearchResult> search(String text, boolean fuzzy) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        String baseDir = this.appService.getApp().getBaseDirectory().getAbsolutePath();
        LinkedHashSet matches = new LinkedHashSet();
        List ops = this.opService.infos().stream().collect(Collectors.toList());
        String textLower = text.toLowerCase();
        ops.stream().filter(info -> this.startsWith((OpInfo)info, textLower)).forEach(matches::add);
        ops.stream().filter(info -> this.hasSubstring((OpInfo)info, textLower)).forEach(matches::add);
        return matches.stream().map(info -> new OpSearchResult(this.opService.context(), (OpInfo)info, baseDir)).collect(Collectors.toList());
    }

    private boolean startsWith(OpInfo info, String desiredLower) {
        String name = info.getName();
        return name != null && name.toLowerCase().matches("(^|.*\\.)" + desiredLower + ".*");
    }

    private boolean hasSubstring(OpInfo info, String desiredLower) {
        String sig = info.toString();
        return sig != null && sig.matches(".*" + desiredLower + ".*");
    }
}

