/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.search;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.imagej.ops.OpInfo;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccessible;
import org.scijava.Context;
import org.scijava.cache.CacheService;
import org.scijava.convert.ConvertService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.search.SearchResult;
import org.scijava.search.module.ModuleSearcher;

public class OpSearchResult
implements SearchResult {
    private static final List<Class<?>> KNOWN_IMAGE_TYPES = Arrays.asList(RandomAccessible.class, RealRandomAccessible.class, Iterable.class);
    private final CacheService cacheService;
    private final ConvertService convertService;
    private final OpInfo info;
    private final String shortSig;
    private final Map<String, String> props;

    public OpSearchResult(Context context, OpInfo info, String baseDir) {
        this.cacheService = (CacheService)context.getService(CacheService.class);
        this.convertService = (ConvertService)context.getService(ConvertService.class);
        this.info = info;
        ShortSigKey shortSigKey = new ShortSigKey(info);
        Object shortSigValue = this.cacheService.get((Object)shortSigKey);
        if (shortSigValue == null) {
            this.shortSig = this.buildShortSig();
            this.cacheService.put((Object)shortSigKey, (Object)this.shortSig);
        } else {
            this.shortSig = (String)shortSigValue;
        }
        this.props = new LinkedHashMap<String, String>();
        this.props.put("Signature", info.toString());
        String opType = info.getType().getName();
        this.props.put("Op type", opType.startsWith("net.imagej.ops.Ops$") ? opType.substring(15).replace('$', '.') : opType);
        Object[] aliases = info.getAliases();
        if (aliases != null && aliases.length > 0) {
            this.props.put("Aliases", Arrays.toString(aliases));
        }
        this.props.put("Identifier", info.cInfo().getIdentifier());
        this.props.put("Location", ModuleSearcher.location((ModuleInfo)info.cInfo(), (String)baseDir));
    }

    public OpInfo info() {
        return this.info;
    }

    public String name() {
        return this.shortSig;
    }

    public String identifier() {
        return this.shortSig;
    }

    public String iconPath() {
        return ModuleSearcher.iconPath((ModuleInfo)this.info.cInfo());
    }

    public Map<String, String> properties() {
        return this.props;
    }

    private String buildShortSig() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.info.getName());
        sb.append("(");
        boolean first = true;
        for (ModuleItem<?> input : this.info.inputs()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String name = input.getName();
            String var = name.matches("(in|out)\\d*") ? this.varFromType(name.replaceFirst("(in|out)", ""), input.getType()) : name;
            sb.append(var);
        }
        sb.append(")");
        return sb.toString();
    }

    private String varFromType(String suffix, Class<?> type) {
        if (this.typesMatch(KNOWN_IMAGE_TYPES, type)) {
            return "image" + suffix;
        }
        return this.lowerCamelCase(type.getSimpleName()) + suffix;
    }

    private boolean typesMatch(List<Class<?>> types, Class<?> type) {
        return types.stream().filter(destType -> this.convertService.supports(type, destType)).findFirst().isPresent();
    }

    private String lowerCamelCase(String s) {
        if (s == null || s.isEmpty() || !this.isUpperCase(s.charAt(0))) {
            return s;
        }
        if (s.length() > 1 && this.isUpperCase(s.charAt(1))) {
            int index;
            for (index = 1; index < s.length() && this.isUpperCase(s.charAt(index)); ++index) {
            }
            return s.substring(0, index - 1).toLowerCase() + s.substring(index - 1);
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    private boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private class ShortSigKey {
        private final OpInfo opInfo;

        public ShortSigKey(OpInfo info) {
            this.opInfo = info;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ShortSigKey)) {
                return false;
            }
            ShortSigKey that = (ShortSigKey)o;
            return this.opInfo == that.opInfo;
        }

        public int hashCode() {
            return this.opInfo.hashCode();
        }
    }
}

