/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCF;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.BooleanType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Morphology.Outline.class)
public class Outline<B extends BooleanType<B>>
extends AbstractBinaryHybridCF<RandomAccessibleInterval<B>, Boolean, RandomAccessibleInterval<BitType>>
implements Ops.Morphology.Outline {
    @Parameter
    private LogService logService;

    @Override
    public RandomAccessibleInterval<BitType> createOutput(RandomAccessibleInterval<B> input, Boolean input2) {
        long[] dims = new long[input.numDimensions()];
        input.dimensions(dims);
        FinalDimensions dimensions = new FinalDimensions(dims);
        return this.ops().create().img((Dimensions)dimensions, new BitType());
    }

    @Override
    public void compute(RandomAccessibleInterval<B> input, Boolean excludeEdges, RandomAccessibleInterval<BitType> output) {
        ExtendedRandomAccessibleInterval<B, RandomAccessibleInterval<B>> extendedInput = this.extendInterval(input);
        boolean nThreads = true;
        ExecutorService pool = Executors.newFixedThreadPool(1);
        ArrayList futures = new ArrayList();
        long[] dimensions = new long[input.numDimensions()];
        input.dimensions(dimensions);
        long size = Arrays.stream(dimensions).reduce((a, b) -> a * b).orElse(0L);
        long perThread = size / 1L;
        long remainder = size % perThread;
        IterableInterval iterable = Views.iterable(input);
        for (int i = 0; i < 1; ++i) {
            long l = (long)i * perThread + 1L;
            long share = i == 0 ? perThread + remainder : perThread;
            Cursor cursor = iterable.cursor();
            OutOfBounds inputAccess = extendedInput.randomAccess();
            RandomAccess outputAccess = output.randomAccess();
            Runnable runnable = Outline.createTask(cursor, inputAccess, (RandomAccess<BitType>)outputAccess, l, share);
            futures.add(pool.submit(runnable));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.logService.error((Throwable)e);
            }
        }
        this.shutdownAndAwaitTermination(pool);
    }

    private void shutdownAndAwaitTermination(ExecutorService executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.logService.trace((Object)"Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
            this.logService.trace((Throwable)ie);
        }
    }

    private static <B extends BooleanType<B>> Runnable createTask(Cursor<B> inputCursor, OutOfBounds<B> inputAccess, RandomAccess<BitType> output, long start, long elements) {
        return () -> {
            long[] coordinates = new long[inputAccess.numDimensions()];
            inputCursor.jumpFwd(start);
            for (long j = 0L; j < elements; ++j) {
                inputCursor.localize(coordinates);
                inputAccess.setPosition(coordinates);
                if (Outline.isOutline(inputAccess, coordinates)) {
                    output.setPosition(coordinates);
                    ((BitType)output.get()).set(((BooleanType)inputCursor.get()).get());
                }
                inputCursor.fwd();
            }
        };
    }

    private ExtendedRandomAccessibleInterval<B, RandomAccessibleInterval<B>> extendInterval(RandomAccessibleInterval<B> interval) {
        BooleanType type = (BooleanType)((BooleanType)Util.getTypeFromInterval(interval)).createVariable();
        type.set(((Boolean)this.in2()).booleanValue());
        return Views.extendValue(interval, (Type)type);
    }

    private static <B extends BooleanType<B>> boolean isAnyNeighborBackground(int dimension, OutOfBounds<B> access, long[] position) {
        for (long p = -1L; p <= 1L; ++p) {
            access.setPosition(position[dimension] + p, dimension);
            if (!(dimension == 0 ? !((BooleanType)access.get()).get() : Outline.isAnyNeighborBackground(dimension - 1, access, position))) continue;
            return true;
        }
        return false;
    }

    private static <B extends BooleanType<B>> boolean isOutline(OutOfBounds<B> access, long[] position) {
        int dimension = access.numDimensions() - 1;
        return ((BooleanType)access.get()).get() && Outline.isAnyNeighborBackground(dimension, access, position);
    }
}

