/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCFI;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public final class ConstantToIIOutputII {
    private ConstantToIIOutputII() {
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class Divide<T extends NumericType<T>>
    extends AbstractUnaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private T value;
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in(), ((NumericType)((IterableInterval)this.in()).firstElement()).createVariable());
        }

        @Override
        public void compute(IterableInterval<T> input, IterableInterval<T> output) {
            Cursor inCursor = input.cursor();
            Cursor outCursor = output.cursor();
            while (inCursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)inCursor.next());
                ((NumericType)outCursor.get()).div(this.value);
            }
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input) {
            return this.outputCreator.calculate(input);
        }

        @Override
        public boolean conforms() {
            if (this.out() == null) {
                return true;
            }
            return ((IterableInterval)this.in()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public void mutate(IterableInterval<T> arg) {
            for (NumericType t : arg) {
                t.div(this.value);
            }
        }

        @Override
        public Divide<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class Multiply<T extends NumericType<T>>
    extends AbstractUnaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private T value;
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in(), ((NumericType)((IterableInterval)this.in()).firstElement()).createVariable());
        }

        @Override
        public void compute(IterableInterval<T> input, IterableInterval<T> output) {
            Cursor inCursor = input.cursor();
            Cursor outCursor = output.cursor();
            while (inCursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)inCursor.next());
                ((NumericType)outCursor.get()).mul(this.value);
            }
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input) {
            return this.outputCreator.calculate(input);
        }

        @Override
        public boolean conforms() {
            if (this.out() == null) {
                return true;
            }
            return ((IterableInterval)this.in()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public void mutate(IterableInterval<T> arg) {
            for (NumericType t : arg) {
                t.mul(this.value);
            }
        }

        @Override
        public Multiply<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class Subtract<T extends NumericType<T>>
    extends AbstractUnaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private T value;
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in(), ((NumericType)((IterableInterval)this.in()).firstElement()).createVariable());
        }

        @Override
        public void compute(IterableInterval<T> input, IterableInterval<T> output) {
            Cursor inCursor = input.cursor();
            Cursor outCursor = output.cursor();
            while (inCursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)inCursor.next());
                ((NumericType)outCursor.get()).sub(this.value);
            }
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input) {
            return this.outputCreator.calculate(input);
        }

        @Override
        public boolean conforms() {
            if (this.out() == null) {
                return true;
            }
            return ((IterableInterval)this.in()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public void mutate(IterableInterval<T> arg) {
            for (NumericType t : arg) {
                t.sub(this.value);
            }
        }

        @Override
        public Subtract<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class Add<T extends NumericType<T>>
    extends AbstractUnaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private T value;
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in(), ((NumericType)((IterableInterval)this.in()).firstElement()).createVariable());
        }

        @Override
        public void compute(IterableInterval<T> input, IterableInterval<T> output) {
            Cursor inCursor = input.cursor();
            Cursor outCursor = output.cursor();
            while (inCursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)inCursor.next());
                ((NumericType)outCursor.get()).add(this.value);
            }
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input) {
            return this.outputCreator.calculate(input);
        }

        @Override
        public boolean conforms() {
            if (this.out() == null) {
                return true;
            }
            return ((IterableInterval)this.in()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public void mutate(IterableInterval<T> arg) {
            for (NumericType t : arg) {
                t.add(this.value);
            }
        }

        @Override
        public Add<T> getIndependentInstance() {
            return this;
        }
    }
}

