/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.normalize;

import net.imagej.ops.Ops;
import net.imagej.ops.image.normalize.NormalizeRealTypeComputer;
import net.imagej.ops.special.chain.UFViaUCAllSame;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.converter.read.ConvertedIterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.Normalize.class)
public class NormalizeIIFunction<T extends RealType<T>>
extends UFViaUCAllSame<IterableInterval<T>>
implements Ops.Image.Normalize {
    @Parameter(required=false)
    private T sourceMin;
    @Parameter(required=false)
    private T sourceMax;
    @Parameter(required=false)
    private T targetMin;
    @Parameter(required=false)
    private T targetMax;
    @Parameter(required=false)
    private boolean isLazy = true;
    private UnaryFunctionOp<IterableInterval<T>, Pair<T, T>> minMaxFunc;
    private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> imgCreator;

    @Override
    public UnaryComputerOp<IterableInterval<T>, IterableInterval<T>> createWorker(IterableInterval<T> t) {
        return Computers.unary(this.ops(), Ops.Image.Normalize.class, t, t, this.sourceMin, this.sourceMax, this.targetMin, this.targetMax);
    }

    @Override
    public IterableInterval<T> createOutput(IterableInterval<T> input) {
        return this.imgCreator.calculate(input);
    }

    @Override
    public void initialize() {
        if (this.isLazy) {
            if (this.sourceMin == null || this.sourceMax == null) {
                this.minMaxFunc = Functions.unary(this.ops(), Ops.Stats.MinMax.class, Pair.class, this.in(), new Object[0]);
            }
        } else {
            super.initialize();
        }
        this.imgCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in(), new Object[0]);
    }

    private double[] getBounds(IterableInterval<T> input) {
        double[] result = new double[4];
        if (this.minMaxFunc != null) {
            Pair<T, T> minMax = this.minMaxFunc.calculate(input);
            result[0] = (this.sourceMin == null ? (RealType)minMax.getA() : this.sourceMin).getRealDouble();
            result[1] = (this.sourceMax == null ? (RealType)minMax.getB() : this.sourceMax).getRealDouble();
        } else {
            result[0] = this.sourceMin.getRealDouble();
            result[1] = this.sourceMax.getRealDouble();
        }
        RealType first = (RealType)input.firstElement();
        result[2] = this.targetMin == null ? first.getMinValue() : this.targetMin.getRealDouble();
        result[3] = this.targetMax == null ? first.getMaxValue() : this.targetMax.getRealDouble();
        return result;
    }

    @Override
    public IterableInterval<T> calculate(IterableInterval<T> input) {
        if (this.isLazy) {
            double[] bounds = this.getBounds(input);
            return new ConvertedIterableInterval(input, new NormalizeRealTypeComputer(bounds[0], bounds[1], bounds[2], bounds[3]), ((RealType)input.firstElement()).createVariable());
        }
        return (IterableInterval)super.calculate(input);
    }
}

