/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.cooccurrenceMatrix;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.image.cooccurrenceMatrix.MatrixOrientation;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.CooccurrenceMatrix.class)
public class CooccurrenceMatrix3D<T extends RealType<T>>
extends AbstractUnaryFunctionOp<IterableInterval<T>, double[][]>
implements Ops.Image.CooccurrenceMatrix,
Contingent {
    @Parameter(label="Number of Gray Levels", min="0", max="128", stepSize="1", initializer="32")
    private int nrGreyLevels;
    @Parameter(label="Distance", min="0", max="128", stepSize="1", initializer="1")
    private int distance;
    @Parameter(label="Matrix Orientation")
    private MatrixOrientation orientation;
    private UnaryFunctionOp<IterableInterval<T>, Pair<T, T>> minmax;

    @Override
    public void initialize() {
        super.initialize();
        this.minmax = Functions.unary(this.ops(), Ops.Stats.MinMax.class, Pair.class, this.in(), new Object[0]);
    }

    @Override
    public double[][] calculate(IterableInterval<T> input) {
        double[][] matrix = new double[this.nrGreyLevels][this.nrGreyLevels];
        Cursor cursor = input.localizingCursor();
        Pair<T, T> minMax = this.minmax.calculate(input);
        double localMin = ((RealType)minMax.getA()).getRealDouble();
        double localMax = ((RealType)minMax.getB()).getRealDouble();
        int[][][] pixels = new int[(int)input.dimension(2)][(int)input.dimension(1)][(int)input.dimension(0)];
        int minimumX = (int)input.min(0);
        int minimumY = (int)input.min(1);
        int minimumZ = (int)input.min(2);
        double diff = localMax - localMin;
        while (cursor.hasNext()) {
            cursor.fwd();
            pixels[cursor.getIntPosition((int)2) - minimumZ][cursor.getIntPosition((int)1) - minimumY][cursor.getIntPosition((int)0) - minimumX] = (int)((((RealType)cursor.get()).getRealDouble() - localMin) / diff * (double)(this.nrGreyLevels - 1));
        }
        double orientationAtX = this.orientation.getValueAtDim(0) * this.distance;
        double orientationAtY = this.orientation.getValueAtDim(1) * this.distance;
        double orientationAtZ = this.orientation.getValueAtDim(2) * this.distance;
        int nrPairs = 0;
        for (int z = 0; z < pixels.length; ++z) {
            for (int y = 0; y < pixels[z].length; ++y) {
                for (int x = 0; x < pixels[z][y].length; ++x) {
                    if (pixels[z][y][x] == Integer.MAX_VALUE) continue;
                    int sx = (int)((double)x + orientationAtX);
                    int sy = (int)((double)y + orientationAtY);
                    int sz = (int)((double)z + orientationAtZ);
                    if (sx < 0 || sy < 0 || sz < 0 || sz >= pixels.length || sy >= pixels[sz].length || sx >= pixels[sz][sy].length || pixels[sz][sy][sx] == Integer.MAX_VALUE) continue;
                    double[] dArray = matrix[pixels[z][y][x]];
                    int n = pixels[sz][sy][sx];
                    dArray[n] = dArray[n] + 1.0;
                    ++nrPairs;
                }
            }
        }
        if (nrPairs > 0) {
            double divisor = 1.0 / (double)nrPairs;
            for (int row = 0; row < matrix.length; ++row) {
                int col = 0;
                while (col < matrix[row].length) {
                    double[] dArray = matrix[row];
                    int n = col++;
                    dArray[n] = dArray[n] * divisor;
                }
            }
        }
        return matrix;
    }

    @Override
    public boolean conforms() {
        return ((IterableInterval)this.in()).numDimensions() == 3 && this.orientation.isCompatible(3);
    }
}

