/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.mesh.Mesh;
import net.imagej.mesh.Triangle;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.GeometricOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.BoundarySize.class, label="Geometric (3D): Surface Area", priority=10000.0)
public class DefaultSurfaceArea
extends AbstractUnaryHybridCF<Mesh, DoubleType>
implements GeometricOp<Mesh, DoubleType>,
Ops.Geometric.BoundarySize {
    @Override
    public void compute(Mesh input, DoubleType output) {
        double total = 0.0;
        for (Triangle tri : input.triangles()) {
            Vector3D v0 = new Vector3D(tri.v0x(), tri.v0y(), tri.v0z());
            Vector3D v1 = new Vector3D(tri.v1x(), tri.v1y(), tri.v1z());
            Vector3D v2 = new Vector3D(tri.v2x(), tri.v2y(), tri.v2z());
            Vector3D cross = v0.subtract((Vector)v1).crossProduct((Vector)v2.subtract((Vector)v0));
            double norm = cross.getNorm();
            if (!(norm > 0.0)) continue;
            total += norm * 0.5;
        }
        output.set(total);
    }

    @Override
    public DoubleType createOutput(Mesh input) {
        return new DoubleType();
    }
}

