/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.create.kernelDiffraction;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.special.BesselJ;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Create.KernelDiffraction.class)
public class DefaultCreateKernelGibsonLanni<T extends ComplexType<T> & NativeType<T>>
extends AbstractUnaryFunctionOp<Dimensions, Img<T>>
implements Ops.Create.KernelDiffraction {
    private BinaryFunctionOp<Dimensions, T, Img<T>> createOp;
    @Parameter
    private double NA = 1.4;
    @Parameter
    private double lambda = 6.1E-7;
    @Parameter
    private double ns = 1.33;
    @Parameter
    private double ni = 1.5;
    @Parameter
    private double resLateral = 1.0E-7;
    @Parameter
    private double resAxial = 2.5E-7;
    @Parameter
    private double pZ = 2.0E-6;
    @Parameter
    private ComplexType<T> type;
    private double ng0 = 1.5;
    private double ng = 1.5;
    private double ni0 = 1.5;
    private double ti0 = 1.5E-4;
    private double tg0 = 1.7E-4;
    private double tg = 1.7E-4;
    private int numBasis = 100;
    private int numSamp = 1000;
    private int overSampling = 2;

    @Override
    public void initialize() {
        this.createOp = Functions.binary(this.ops(), Ops.Create.Img.class, Img.class, Dimensions.class, NativeType.class, new Object[0]);
        this.ni0 = this.ni;
    }

    @Override
    public Img<T> calculate(Dimensions size) {
        int finish;
        int start;
        int nx = -1;
        int ny = -1;
        int nz = -1;
        if (size.numDimensions() == 2) {
            nx = (int)size.dimension(0);
            ny = (int)size.dimension(1);
            nz = 1;
        } else if (size.numDimensions() == 3) {
            nx = (int)size.dimension(0);
            ny = (int)size.dimension(1);
            nz = (int)size.dimension(2);
        }
        int distanceFromCenter = (int)Math.abs(Math.ceil(this.pZ / this.resAxial));
        nz += 2 * distanceFromCenter;
        double x0 = (double)(nx - 1) / 2.0;
        double y0 = (double)(ny - 1) / 2.0;
        double xp = x0;
        double yp = y0;
        int maxRadius = (int)Math.round(Math.sqrt(((double)nx - x0) * ((double)nx - x0) + ((double)ny - y0) * ((double)ny - y0))) + 1;
        double[] r = new double[maxRadius * this.overSampling];
        double[][] h = new double[nz][r.length];
        double a = 0.0;
        double b = Math.min(1.0, this.ns / this.NA);
        double k0 = Math.PI * 2 / this.lambda;
        double factor1 = 5.450000000000001E-7 / this.lambda;
        double factor = factor1 * this.NA / 1.4;
        double deltaRho = (b - a) / (double)(this.numSamp - 1);
        double rho = 0.0;
        double am = 0.0;
        double[][] Basis = new double[this.numSamp][this.numBasis];
        BesselJ bj0 = new BesselJ(0.0);
        BesselJ bj1 = new BesselJ(1.0);
        for (int m = 0; m < this.numBasis; ++m) {
            am = 3 * m + 1;
            for (int rhoi = 0; rhoi < this.numSamp; ++rhoi) {
                rho = (double)rhoi * deltaRho;
                Basis[rhoi][m] = bj0.value(am * rho);
            }
        }
        double ti = 0.0;
        double OPD = 0.0;
        double W = 0.0;
        double[][] Coef = new double[nz][this.numBasis * 2];
        double[][] Ffun = new double[this.numSamp][nz * 2];
        for (int z = 0; z < nz; ++z) {
            ti = this.ti0 + this.resAxial * ((double)z - ((double)nz - 1.0) / 2.0);
            for (int rhoi = 0; rhoi < this.numSamp; ++rhoi) {
                rho = (double)rhoi * deltaRho;
                double rhoNA2 = rho * rho * this.NA * this.NA;
                OPD = this.pZ * Math.sqrt(this.ns * this.ns - rhoNA2);
                OPD += this.tg * Math.sqrt(this.ng * this.ng - rhoNA2) - this.tg0 * Math.sqrt(this.ng0 * this.ng0 - rhoNA2);
                W = k0 * (OPD += ti * Math.sqrt(this.ni * this.ni - rhoNA2) - this.ti0 * Math.sqrt(this.ni0 * this.ni0 - rhoNA2));
                Ffun[rhoi][z] = Math.cos(W);
                Ffun[rhoi][z + nz] = Math.sin(W);
            }
        }
        Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(Basis, false);
        Array2DRowRealMatrix rhsFun = new Array2DRowRealMatrix(Ffun, false);
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)coefficients).getSolver();
        RealMatrix solution = solver.solve((RealMatrix)rhsFun);
        Coef = solution.getData();
        double[][] RM = new double[this.numBasis][r.length];
        double beta = 0.0;
        double rm = 0.0;
        for (int n = 0; n < r.length; ++n) {
            r[n] = (double)n * 1.0 / (double)this.overSampling;
            beta = k0 * this.NA * r[n] * this.resLateral;
            for (int m = 0; m < this.numBasis; ++m) {
                am = 3 * m + 1;
                rm = am * bj1.value(am * b) * bj0.value(beta * b) * b;
                RM[m][n] = (rm -= beta * b * bj0.value(am * b) * bj1.value(beta * b)) / (am * am - beta * beta);
            }
        }
        double maxValue = 0.0;
        for (int z = 0; z < nz; ++z) {
            for (int n = 0; n < r.length; ++n) {
                double realh = 0.0;
                double imgh = 0.0;
                for (int m = 0; m < this.numBasis; ++m) {
                    realh += RM[m][n] * Coef[m][z];
                    imgh += RM[m][n] * Coef[m][z + nz];
                }
                h[z][n] = realh * realh + imgh * imgh;
            }
        }
        double[][] Pixel = new double[nz][nx * ny];
        for (int z = 0; z < nz; ++z) {
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    double value;
                    double rPixel = Math.sqrt(((double)x - xp) * ((double)x - xp) + ((double)y - yp) * ((double)y - yp));
                    int index = (int)Math.floor(rPixel * (double)this.overSampling);
                    Pixel[z][x + nx * y] = value = h[z][index] + (h[z][index + 1] - h[z][index]) * (rPixel - r[index]) * (double)this.overSampling;
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                }
            }
        }
        Img<T> psf3d = this.createOp.calculate(size, this.type);
        RandomAccess ra = psf3d.randomAccess();
        if (this.pZ < 0.0) {
            start = 2 * distanceFromCenter;
            finish = nz;
        } else {
            start = 0;
            finish = nz - 2 * distanceFromCenter;
        }
        for (int z = start; z < finish; ++z) {
            for (int x = 0; x < nx; ++x) {
                int y = 0;
                while (y < ny) {
                    double value = Pixel[z][x + nx * y] / maxValue;
                    ra.setPosition(new int[]{x, y++, z - start});
                    ((ComplexType)ra.get()).setReal(value);
                }
            }
        }
        return psf3d;
    }
}

