/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.commands.coloc;

import java.util.Arrays;
import net.imagej.ops.Op;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.coloc.pValue.PValueResult;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.Column;
import org.scijava.table.DefaultColumn;
import org.scijava.table.DefaultGenericTable;
import org.scijava.table.DoubleColumn;
import org.scijava.table.GenericTable;

@Plugin(type=Command.class, menuPath="Analyze>Colocalization>Colocalize...")
public class Colocalize<T extends RealType<T>>
implements Command {
    @Parameter
    private OpService ops;
    @Parameter(callback="imageChanged")
    private Img<T> image1;
    @Parameter(callback="imageChanged")
    private Img<T> image2;
    @Parameter(label="PSF Size", description="<html>Size of blocks for random shufflings.<br>Specify psf size using comma-separated numbers.<br>Otherwise, leave blank for auto-calculated default values.", required=false)
    private String psfSizeString;
    @Parameter(label="ICQ")
    private boolean icq;
    @Parameter(label="K-Tau")
    private boolean kTau;
    @Parameter(label="Pearsons")
    private boolean pearsons;
    @Parameter(label="MTKT")
    private boolean mtkt;
    @Parameter(type=ItemIO.OUTPUT)
    private GenericTable table;

    public void run() {
        long[] psfDims = this.psfSizeString == null || this.psfSizeString.trim().isEmpty() ? null : Arrays.asList(this.psfSizeString.trim().split(",")).stream().mapToLong(s -> Long.parseLong(s.trim())).toArray();
        FinalDimensions psfSize = psfDims == null || psfDims.length == 0 ? null : new FinalDimensions(psfDims);
        DefaultColumn algorithmColumn = new DefaultColumn(String.class, "Algorithm");
        DoubleColumn pValueColumn = new DoubleColumn("P-Value");
        DoubleColumn colocValueColumn = new DoubleColumn("Coloc-Value");
        DefaultColumn colocArrayColumn = new DefaultColumn(double[].class, "All Coloc Values");
        this.table = new DefaultGenericTable();
        this.table.add((Column)algorithmColumn);
        this.table.add((Column)pValueColumn);
        this.table.add((Column)colocValueColumn);
        this.table.add((Column)colocArrayColumn);
        if (this.icq) {
            this.calculateRow(Ops.Coloc.ICQ.class, (Column<String>)algorithmColumn, pValueColumn, colocValueColumn, (Column<double[]>)colocArrayColumn, "ICQ", (Dimensions)psfSize);
        }
        if (this.kTau) {
            this.calculateRow(Ops.Coloc.KendallTau.class, (Column<String>)algorithmColumn, pValueColumn, colocValueColumn, (Column<double[]>)colocArrayColumn, "K-Tau", (Dimensions)psfSize);
        }
        if (this.pearsons) {
            this.calculateRow(Ops.Coloc.Pearsons.class, (Column<String>)algorithmColumn, pValueColumn, colocValueColumn, (Column<double[]>)colocArrayColumn, "Pearsons", (Dimensions)psfSize);
        }
        if (this.mtkt) {
            this.calculateRow(Ops.Coloc.MaxTKendallTau.class, (Column<String>)algorithmColumn, pValueColumn, colocValueColumn, (Column<double[]>)colocArrayColumn, "MTKT", (Dimensions)psfSize);
        }
        this.table.setRowCount(algorithmColumn.size());
    }

    private void calculateRow(Class<? extends Op> opType, Column<String> algorithmColumn, DoubleColumn pValueColumn, DoubleColumn colocValueColumn, Column<double[]> colocArrayColumn, String algorithmName, Dimensions psfSize) {
        BinaryFunctionOp<Img<T>, Img<T>, Double> colocOp = Functions.binary((OpEnvironment)this.ops, opType, Double.class, this.image1, this.image2, new Object[0]);
        PValueResult result = new PValueResult();
        this.ops.run(Ops.Coloc.PValue.class, new Object[]{result, this.image1, this.image2, colocOp, 100, psfSize});
        algorithmColumn.add((Object)algorithmName);
        pValueColumn.add((Object)result.getPValue());
        colocValueColumn.add((Object)result.getColocValue());
        colocArrayColumn.add((Object)result.getColocValuesArray());
    }

    private void imageChanged() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int d = 0; d < this.image1.numDimensions(); ++d) {
            long size = (long)Math.floor(Math.sqrt(this.image1.dimension(d)));
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(size);
        }
        this.psfSizeString = sb.toString();
    }
}

