/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.scijava.util.GenericUtils;

public class OpRef {
    private final String name;
    private final Collection<Type> types;
    private final List<Type> outTypes;
    private final Object[] args;

    public static OpRef create(String name, Object ... args) {
        return new OpRef(name, null, null, args);
    }

    public static OpRef create(Type type, Object ... args) {
        return new OpRef(null, OpRef.types(type), null, args);
    }

    public static OpRef createTypes(Type type1, Type type2, Type outType, Object ... args) {
        return new OpRef(null, OpRef.types(type1, type2), OpRef.types(outType), args);
    }

    public static OpRef createTypes(Collection<? extends Type> types, Object ... args) {
        return new OpRef(null, types, null, args);
    }

    public OpRef(String name, Collection<? extends Type> types, Collection<? extends Type> outTypes, Object ... args) {
        this.name = name;
        this.types = this.list(types);
        this.outTypes = this.list(outTypes);
        this.args = args;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Type> getTypes() {
        return this.types;
    }

    public List<Type> getOutTypes() {
        return this.outTypes;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, this.name);
        if (this.types != null) {
            for (Type t : this.types) {
                this.append(sb, t instanceof Class ? ((Class)t).getName() : t.toString());
            }
        }
        return sb.toString();
    }

    public boolean typesMatch(Class<?> c) {
        if (this.types == null) {
            return true;
        }
        for (Type t : this.types) {
            Class raw = GenericUtils.getClass((Type)t);
            if (raw.isAssignableFrom(c)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLabel());
        sb.append("(");
        boolean first = true;
        for (Object arg : this.args) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (arg.getClass() == Class.class) {
                sb.append(((Class)arg).getSimpleName());
                continue;
            }
            sb.append(arg.getClass().getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpRef other = (OpRef)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.types, other.types)) {
            return false;
        }
        if (!Objects.equals(this.outTypes, other.outTypes)) {
            return false;
        }
        return Arrays.equals(this.args, other.args);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.types, this.outTypes, this.args);
    }

    public static List<Type> types(Type ... types) {
        ArrayList<Type> list = new ArrayList<Type>();
        for (Type t : types) {
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    private void append(StringBuilder sb, String s) {
        if (s == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.append("/");
        }
        sb.append(s);
    }

    private List<Type> list(Collection<? extends Type> c) {
        ArrayList<Type> list = new ArrayList<Type>();
        if (c != null) {
            list.addAll(c);
        }
        return list;
    }
}

