/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.app.AppService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class ConfigFileParameters
extends AbstractContextual {
    public static final String CONFIG_FILE = "ImageJ.cfg";
    private static final Integer MINIMUM_MEMORY = 256;
    private static final String SENTINEL = "ImageJ startup properties";
    private static final String MEMORY_KEY = "maxheap.mb";
    private static final String JVMARGS_KEY = "jvmargs";
    @Parameter
    private AppService appService;
    @Parameter
    private LogService log;
    private final Map<String, String> dataMap;
    private final File configFile;

    public ConfigFileParameters(Context context) {
        this(context, null);
    }

    public ConfigFileParameters(Context context, File configFile) {
        this.setContext(context);
        this.dataMap = new HashMap<String, String>();
        this.configFile = configFile == null ? this.defaultConfigFile() : configFile;
        this.initialize();
    }

    public int getMemoryInMB() {
        String memVal = this.dataMap.get(MEMORY_KEY);
        Integer val = 0;
        try {
            val = Integer.parseInt(memVal);
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)("Launcher configuration file " + this.configFile + " has key " + MEMORY_KEY + " that is not in an integer format"));
        }
        if (val < MINIMUM_MEMORY) {
            val = MINIMUM_MEMORY;
        }
        return val;
    }

    public void setMemoryInMB(int numMegabytes) {
        Integer memory = numMegabytes;
        if (memory < MINIMUM_MEMORY) {
            memory = MINIMUM_MEMORY;
            this.log.warn((Object)("Max Java heap size can be no smaller than " + MINIMUM_MEMORY + " megabytes."));
        }
        this.dataMap.put(MEMORY_KEY, memory.toString());
        this.save();
    }

    public String getJvmArgs() {
        return this.dataMap.get(JVMARGS_KEY);
    }

    public void setJvmArgs(String args) {
        String value = args;
        if (args == null) {
            value = "";
        }
        this.dataMap.put(JVMARGS_KEY, value);
        this.save();
    }

    private File defaultConfigFile() {
        File directory = this.appService.getApp().getBaseDirectory();
        return new File(directory, CONFIG_FILE);
    }

    private void initialize() {
        this.setDefaultValues(this.dataMap);
        if (this.isLegacyConfigFile(this.configFile)) {
            this.loadLegacyConfigValues(this.dataMap, this.configFile);
        } else {
            this.loadModernConfigValues(this.dataMap, this.configFile);
        }
    }

    private void save() {
        this.saveConfigValues(this.dataMap, this.configFile);
    }

    private void setDefaultValues(Map<String, String> map) {
        map.clear();
        map.put(MEMORY_KEY, MINIMUM_MEMORY.toString());
        map.put(JVMARGS_KEY, "");
    }

    private boolean isLegacyConfigFile(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fstream = new FileInputStream(file);
            DataInputStream din = new DataInputStream(fstream);
            InputStreamReader in = new InputStreamReader(din);
            BufferedReader br = new BufferedReader(in);
            String firstLine = br.readLine();
            in.close();
            return !firstLine.contains(SENTINEL);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean loadLegacyConfigValues(Map<String, String> map, File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fstream = new FileInputStream(file);
            DataInputStream din = new DataInputStream(fstream);
            InputStreamReader in = new InputStreamReader(din);
            BufferedReader br = new BufferedReader(in);
            br.readLine();
            br.readLine();
            String argString = br.readLine();
            in.close();
            Integer memSize = this.memorySize(argString);
            String jvmArgs = this.jvmArgs(argString);
            map.put(MEMORY_KEY, memSize.toString());
            map.put(JVMARGS_KEY, jvmArgs);
            return true;
        }
        catch (Exception e) {
            this.log.warn((Object)("Couldd not load legacy launcher config file " + file));
            return false;
        }
    }

    private boolean loadModernConfigValues(Map<String, String> map, File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fstream = new FileInputStream(file);
            DataInputStream din = new DataInputStream(fstream);
            InputStreamReader in = new InputStreamReader(din);
            BufferedReader br = new BufferedReader(in);
            Pattern keyValuePairPattern = Pattern.compile("\\s*(.*)\\s*=\\s*(.*)");
            br.readLine();
            while (br.ready()) {
                Matcher matcher;
                String s = br.readLine();
                if (s.trim().startsWith("#") || !(matcher = keyValuePairPattern.matcher(s)).matches()) continue;
                String key = matcher.group(1).trim();
                String value = matcher.group(2).trim();
                map.put(key, value);
            }
            br.close();
            return true;
        }
        catch (IOException e) {
            this.log.warn((Object)("Could not load launcher config file " + file));
            return false;
        }
    }

    private void saveConfigValues(Map<String, String> map, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
            BufferedWriter out = new BufferedWriter(osw);
            out.write("#ImageJ startup properties (" + this.getVersion() + ")");
            out.newLine();
            for (String key : map.keySet()) {
                String value = map.get(key);
                value = value.replaceAll("\n", "");
                value = value.replaceAll("\r", "");
                out.write(key + " = " + map.get(key));
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            this.log.warn((Object)("Could not save launcher config file values to " + file));
        }
    }

    private int memorySize(String argList) {
        String[] args;
        for (String arg : args = argList.split("\\s+")) {
            if (!arg.startsWith("-Xmx")) continue;
            String numString = arg.substring(4);
            numString = numString.substring(0, numString.length() - 1);
            try {
                return Integer.parseInt(numString);
            }
            catch (NumberFormatException e) {
                return MINIMUM_MEMORY;
            }
        }
        return MINIMUM_MEMORY;
    }

    private String jvmArgs(String argList) {
        String[] args;
        String value = "";
        for (String arg : args = argList.split("\\s+")) {
            if (arg.startsWith("-Xmx") || arg.equals("ij.ImageJ")) continue;
            if (value.length() > 0) {
                value = value + " ";
            }
            value = value + arg;
        }
        return value;
    }

    private String getVersion() {
        return this.appService.getApp("ImageJ").getVersion();
    }
}

