/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ColorSpaceConverter;
import ij.process.ImageProcessor;
import ij.process.MedianCut;
import ij.process.StackConverter;
import ij.process.StackStatistics;
import java.awt.Point;
import java.awt.image.ColorModel;

public class ImageConverter {
    private ImagePlus imp;
    private int type;
    private static boolean doScaling = true;

    public ImageConverter(ImagePlus imp) {
        this.imp = imp;
        this.type = imp.getType();
    }

    public synchronized void convertToGray8() {
        if (this.imp.getStackSize() > 1) {
            new StackConverter(this.imp).convertToGray8();
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        if (this.type == 1 || this.type == 2) {
            if (Prefs.calibrateConversions) {
                if (this.type == 1 && this.imp.getCalibration().calibrated()) {
                    this.convertToGray32();
                }
                ImageConverter.convertAndCalibrate(this.imp, "8-bit");
            } else {
                this.imp.setProcessor(null, ip.convertToByte(doScaling));
                this.imp.setCalibration(this.imp.getCalibration());
            }
            ImageConverter.record();
        } else if (this.type == 4) {
            this.imp.setProcessor(null, ip.convertToByte(doScaling));
        } else if (ip.isPseudoColorLut()) {
            boolean invertedLut = ip.isInvertedLut();
            ip.setColorModel(LookUpTable.createGrayscaleColorModel(invertedLut));
            this.imp.updateAndDraw();
        } else {
            ip = new ColorProcessor(this.imp.getImage());
            this.imp.setProcessor(null, ip.convertToByte(doScaling));
        }
        ImageProcessor ip2 = this.imp.getProcessor();
        if (Prefs.useInvertingLut && ip2 instanceof ByteProcessor && !ip2.isInvertedLut() && !ip2.isColorLut()) {
            ip2.invertLut();
            ip2.invert();
        }
    }

    public void convertToGray16() {
        if (this.type == 1) {
            return;
        }
        if (this.type != 0 && this.type != 2 && this.type != 4) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        if (this.imp.getStackSize() > 1) {
            new StackConverter(this.imp).convertToGray16();
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        if (this.type == 2) {
            ImageConverter.record();
        }
        this.imp.trimProcessor();
        if (Prefs.calibrateConversions && this.type == 2) {
            ImageConverter.convertAndCalibrate(this.imp, "16-bit");
        } else {
            this.imp.setProcessor(null, ip.convertToShort(doScaling));
            this.imp.setCalibration(this.imp.getCalibration());
        }
    }

    public static void convertAndCalibrate(ImagePlus imp, String type) {
        ImageConverter.setDoScaling(true);
        Calibration cal = imp.getCalibration();
        ImageProcessor ip = imp.getProcessor();
        int stackSize = imp.getStackSize();
        double min = ip.getMin();
        double max = ip.getMax();
        ip.resetMinAndMax();
        double min2 = ip.getMin();
        double max2 = ip.getMax();
        boolean eightBitConversion = type.equals("8-bit");
        if (stackSize > 1) {
            cal.disableDensityCalibration();
            StackStatistics stats = new StackStatistics(imp);
            min2 = stats.min;
            max2 = stats.max;
            ImageConverter.convertStack(imp, eightBitConversion, min2, max2);
        } else {
            ImageProcessor ip2 = null;
            ip2 = eightBitConversion ? ip.convertToByte(true) : ip.convertToShort(true);
            imp.setProcessor(null, ip2);
        }
        int maxRange = eightBitConversion ? 255 : 65535;
        double[] x = new double[]{0.0, maxRange};
        double[] y = new double[]{min2, max2};
        CurveFitter cf = new CurveFitter(x, y);
        cf.doFit(0, false);
        int np = cf.getNumParams();
        double[] p = cf.getParams();
        double[] parameters = new double[np];
        for (int i = 0; i < np; ++i) {
            parameters[i] = p[i];
        }
        cal.setFunction(0, parameters, type + " converted");
        min = cal.getRawValue(min);
        max = cal.getRawValue(max);
        if (IJ.debugMode) {
            IJ.log("convertAndCalibrate: " + min + " " + max);
        }
        imp.setDisplayRange(min, max);
        imp.updateAndDraw();
    }

    private static void convertStack(ImagePlus imp, boolean eightBitConversion, double min, double max) {
        int nSlices = imp.getStackSize();
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height);
        int inc = nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        for (int i = 1; i <= nSlices; ++i) {
            String label = stack1.getSliceLabel(1);
            ImageProcessor ip1 = stack1.getProcessor(1);
            ip1.setMinAndMax(min, max);
            ImageProcessor ip2 = eightBitConversion ? ip1.convertToByte(true) : ip1.convertToShort(true);
            stack1.deleteSlice(1);
            stack2.addSlice(label, ip2);
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)nSlices);
            IJ.showStatus("Converting to 16-bits: " + i + "/" + nSlices);
        }
        IJ.showProgress(1.0);
        imp.setStack(null, stack2);
        ImageConverter.record();
    }

    public static void record() {
        if (Recorder.record) {
            if (Prefs.calibrateConversions) {
                boolean state = true;
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("Prefs.calibrateConversions = true;", true);
                } else {
                    Recorder.recordString("setOption(\"CalibrateConversions\", " + state + ");\n");
                }
            } else {
                Boolean state = ImageConverter.getDoScaling();
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("ImageConverter.setDoScaling(" + state + ");", true);
                } else {
                    Recorder.recordString("setOption(\"ScaleConversions\", " + state + ");\n");
                }
            }
        }
    }

    public void convertToGray32() {
        if (this.type == 2) {
            return;
        }
        if (this.type != 0 && this.type != 1 && this.type != 4) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        Calibration cal = this.imp.getCalibration();
        double min = cal.getCValue(this.imp.getDisplayRangeMin());
        double max = cal.getCValue(this.imp.getDisplayRangeMax());
        if (this.imp.getStackSize() > 1) {
            new StackConverter(this.imp).convertToGray32();
            IJ.setMinAndMax(this.imp, min, max);
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        this.imp.trimProcessor();
        this.imp.setProcessor(null, ip.convertToFloat());
        this.imp.setCalibration(cal);
        IJ.setMinAndMax(this.imp, min, max);
    }

    public void convertToRGB() {
        if (this.imp.getBitDepth() == 24) {
            return;
        }
        if (this.imp.getStackSize() > 1) {
            new StackConverter(this.imp).convertToRGB();
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        this.imp.setProcessor(null, ip.convertToRGB());
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToRGBStack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorProcessor cp = this.imp.getType() == 4 ? (ColorProcessor)this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        byte[] R = new byte[width * height];
        byte[] G = new byte[width * height];
        byte[] B = new byte[width * height];
        cp.getRGB(R, G, B);
        this.imp.trimProcessor();
        ColorModel cm = LookUpTable.createGrayscaleColorModel(false);
        ImageStack stack = new ImageStack(width, height, cm);
        stack.addSlice("Red", R);
        stack.addSlice("Green", G);
        stack.addSlice("Blue", B);
        this.imp.setStack(null, stack);
        this.imp.setDimensions(3, 1, 1);
        if (this.imp.isComposite()) {
            ((CompositeImage)this.imp).setMode(3);
        }
    }

    public void convertToHSB() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorProcessor cp = this.imp.getType() == 4 ? (ColorProcessor)this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
        ImageStack stack = cp.getHSBStack();
        this.imp.trimProcessor();
        this.imp.setStack(null, stack);
        this.imp.setDimensions(3, 1, 1);
    }

    public void convertToHSB32() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorProcessor cp = this.imp.getType() == 4 ? (ColorProcessor)this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
        ImageStack stack = cp.getHSB32Stack();
        this.imp.trimProcessor();
        this.imp.setStack(null, stack);
        this.imp.setDimensions(3, 1, 1);
    }

    public void convertToLab() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorSpaceConverter converter = new ColorSpaceConverter();
        ImagePlus imp2 = converter.RGBToLab(this.imp);
        Point loc = null;
        ImageWindow win = this.imp.getWindow();
        if (win != null) {
            loc = win.getLocation();
        }
        ImageWindow.setNextLocation(loc);
        imp2.show();
        this.imp.hide();
        imp2.copyAttributes(this.imp);
        this.imp.changes = false;
        this.imp.close();
    }

    public void convertRGBStackToRGB() {
        int stackSize = this.imp.getStackSize();
        if (stackSize < 2 || stackSize > 3 || this.type != 0) {
            throw new IllegalArgumentException("2 or 3 slice 8-bit stack required");
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        ImageStack stack = this.imp.getStack();
        byte[] R = (byte[])stack.getPixels(1);
        byte[] G = (byte[])stack.getPixels(2);
        byte[] B = stackSize > 2 ? (byte[])stack.getPixels(3) : new byte[width * height];
        this.imp.trimProcessor();
        ColorProcessor cp = new ColorProcessor(width, height);
        cp.setRGB(R, G, B);
        if (this.imp.isInvertedLut()) {
            cp.invert();
        }
        this.imp.setImage(cp.createImage());
        this.imp.killStack();
        if (IJ.isLinux()) {
            this.imp.setTitle(this.imp.getTitle());
        }
    }

    public void convertHSBToRGB() {
        if (this.imp.getStackSize() != 3) {
            throw new IllegalArgumentException("3-slice 8-bit stack required");
        }
        ImageStack stack = this.imp.getStack();
        byte[] H = (byte[])stack.getPixels(1);
        byte[] S = (byte[])stack.getPixels(2);
        byte[] B = (byte[])stack.getPixels(3);
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        this.imp.trimProcessor();
        ColorProcessor cp = new ColorProcessor(width, height);
        cp.setHSB(H, S, B);
        this.imp.setImage(cp.createImage());
        this.imp.killStack();
        if (IJ.isLinux()) {
            this.imp.setTitle(this.imp.getTitle());
        }
    }

    public void convertHSB32ToRGB() {
        if (this.imp.getStackSize() != 3) {
            throw new IllegalArgumentException("3-slice 8-bit stack required");
        }
        ImageStack stack = this.imp.getStack();
        float[] H = (float[])stack.getPixels(1);
        float[] S = (float[])stack.getPixels(2);
        float[] B = (float[])stack.getPixels(3);
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        this.imp.trimProcessor();
        ColorProcessor cp = new ColorProcessor(width, height);
        cp.setHSB(H, S, B);
        this.imp.setImage(cp.createImage());
        this.imp.killStack();
        if (IJ.isLinux()) {
            this.imp.setTitle(this.imp.getTitle());
        }
    }

    public void convertLabToRGB() {
        if (this.imp.getStackSize() != 3) {
            throw new IllegalArgumentException("3-slice 32-bit stack required");
        }
        ColorSpaceConverter converter = new ColorSpaceConverter();
        ImagePlus imp2 = converter.LabToRGB(this.imp);
        imp2.setCalibration(this.imp.getCalibration());
        this.imp.setImage(imp2);
    }

    public void convertRGBtoIndexedColor(int nColors) {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        if (nColors < 2) {
            nColors = 2;
        }
        if (nColors > 256) {
            nColors = 256;
        }
        IJ.showProgress(0.1);
        IJ.showStatus("Grabbing pixels");
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        ImageProcessor ip = this.imp.getProcessor();
        ip.snapshot();
        int[] pixels = (int[])ip.getPixels();
        this.imp.trimProcessor();
        long start = System.currentTimeMillis();
        MedianCut mc = new MedianCut(pixels, width, height);
        ImageProcessor ip2 = mc.convertToByte(nColors);
        this.imp.setProcessor(null, ip2);
        this.imp.setTypeToColor256();
    }

    public static void setDoScaling(boolean scaleConversions) {
        doScaling = scaleConversions;
        IJ.register(ImageConverter.class);
    }

    public static boolean getDoScaling() {
        return doScaling;
    }
}

