/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.Prefs;
import ij.gui.ImageCanvas;
import ij.plugin.filter.LutWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;

public class LutViewer
implements PlugInFilter {
    private double guiScale = Prefs.getGuiScale();
    private ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 415;
    }

    @Override
    public void run(ImageProcessor ip) {
        int y2;
        int x2;
        int i;
        if (ip.getNChannels() == 3) {
            IJ.error("RGB images do not have LUTs.");
            return;
        }
        int xMargin = (int)(35.0 * this.guiScale);
        int yMargin = (int)(20.0 * this.guiScale);
        int width = (int)(256.0 * this.guiScale);
        int height = (int)(128.0 * this.guiScale);
        int barHeight = (int)(12.0 * this.guiScale);
        ip = this.imp.getChannelProcessor();
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        LookUpTable lut = new LookUpTable(cm);
        int mapSize = lut.getMapSize();
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        boolean isGray = lut.isGrayscale();
        int imageWidth = width + 2 * xMargin;
        int imageHeight = height + 3 * yMargin;
        Image img = IJ.getInstance().createImage(imageWidth, imageHeight);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(new Font("SansSerif", 0, (int)(12.0 * this.guiScale)));
        g.setColor(Color.white);
        g.fillRect(-1, 0, imageWidth, imageHeight);
        g.setColor(Color.black);
        g.drawRect(xMargin, yMargin - 1, width + 1, height + 1);
        if (isGray) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.red);
        }
        boolean drawSteps = width > mapSize;
        double xShift = drawSteps ? 0.5 : 0.0;
        int x1 = this.scaledX(-0.5, xMargin, width, mapSize);
        int y1 = yMargin + height - 1 - (int)Math.round(((double)(reds[0] & 0xFF) - 0.5) * this.guiScale / 2.0);
        for (i = 0; i < mapSize; ++i) {
            x2 = this.scaledX((double)i + xShift, xMargin, width, mapSize);
            y2 = yMargin + height - 1 - (int)Math.round(((double)(reds[i] & 0xFF) - 0.5) * this.guiScale / 2.0);
            if (drawSteps) {
                if (i > 0) {
                    g.drawLine(x1, y1, x1, y2);
                }
                g.drawLine(x1, y2, x2, y2);
            } else if (i > 0) {
                g.drawLine(x1, y1, x2, y2);
            }
            x1 = x2;
            y1 = y2;
        }
        if (!isGray) {
            g.setColor(Color.green);
            x1 = this.scaledX(-0.5, xMargin, width, mapSize);
            y1 = yMargin + height - 1 - (int)Math.round(((double)(greens[0] & 0xFF) - 0.5) * this.guiScale / 2.0);
            for (i = 0; i < mapSize; ++i) {
                x2 = this.scaledX((double)i + xShift, xMargin, width, mapSize);
                y2 = yMargin + height - 1 - (int)Math.round(((double)(greens[i] & 0xFF) - 0.5) * this.guiScale / 2.0);
                if (drawSteps) {
                    if (i > 0) {
                        g.drawLine(x1, y1, x1, y2);
                    }
                    g.drawLine(x1, y2, x2, y2);
                } else if (i > 0) {
                    g.drawLine(x1, y1, x2, y2);
                }
                x1 = x2;
                y1 = y2;
            }
            g.setColor(Color.blue);
            x1 = this.scaledX(-0.5, xMargin, width, mapSize);
            y1 = yMargin + height - 1 - (int)Math.round(((double)(blues[0] & 0xFF) - 0.5) * this.guiScale / 2.0);
            for (i = 0; i < mapSize; ++i) {
                x2 = this.scaledX((double)i + xShift, xMargin, width, mapSize);
                y2 = yMargin + height - 1 - (int)Math.round(((double)(blues[i] & 0xFF) - 0.5) * this.guiScale / 2.0);
                if (drawSteps) {
                    if (i > 0) {
                        g.drawLine(x1, y1, x1, y2);
                    }
                    g.drawLine(x1, y2, x2, y2);
                } else if (i > 0) {
                    g.drawLine(x1, y1, x2, y2);
                }
                x1 = x2;
                y1 = y2;
            }
        }
        int x = xMargin;
        int y = yMargin + height + (int)Math.round(2.0 * this.guiScale);
        lut.drawColorBar(g, x, y, width, barHeight);
        g.setColor(Color.black);
        g.drawString("0", x - (int)(4.0 * this.guiScale), y += barHeight + (int)(15.0 * this.guiScale));
        g.drawString("" + (mapSize - 1), x + width - (int)(10.0 * this.guiScale), y);
        g.drawString("255", (int)(7.0 * this.guiScale), yMargin + (int)(4.0 * this.guiScale));
        g.dispose();
        ImagePlus imp = new ImagePlus("Look-Up Table", img);
        new LutWindow(imp, new ImageCanvas(imp), ip);
    }

    private int scaledX(double x, int xMargin, int width, int mapSize) {
        return xMargin + (int)Math.round(0.5 + (x + 0.5) * (double)width * (1.0 / (double)mapSize));
    }
}

