/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class JavaScriptEvaluator
implements PlugIn,
Runnable {
    private Thread thread;
    private String script;
    private Object result;
    private String error;
    private boolean evaluating;
    ScriptEngine engine;

    @Override
    public void run(String script) {
        if (script.equals("")) {
            return;
        }
        this.script = script;
        this.thread = new Thread((Runnable)this, "JavaScript");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public String run(String script, String arg) {
        this.script = script;
        this.run();
        return null;
    }

    public String eval(String script) {
        this.script = script;
        this.evaluating = true;
        this.run();
        if (this.error != null) {
            return this.error;
        }
        return this.result != null ? "" + this.result : "";
    }

    @Override
    public void run() {
        block10: {
            this.result = null;
            this.error = null;
            Thread.currentThread().setContextClassLoader(IJ.getClassLoader());
            if (IJ.isJava19()) {
                System.setProperty("nashorn.args", "--language=es6");
            }
            try {
                if (this.engine == null) {
                    ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                    this.engine = scriptEngineManager.getEngineByName("ECMAScript");
                    if (this.engine == null) {
                        IJ.error("Could not find JavaScript engine");
                        return;
                    }
                    if (!IJ.isJava18()) {
                        this.engine.eval("function load(path) {\n  importClass(Packages.sun.org.mozilla.javascript.internal.Context);\n  importClass(Packages.java.io.FileReader);\n  var cx = Context.getCurrentContext();\n  cx.evaluateReader(this, new FileReader(path), path, 1, null);\n}");
                    }
                }
                this.result = this.engine.eval(this.script);
            }
            catch (Throwable e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "";
                }
                if (msg.startsWith("sun.org.mozilla.javascript.internal.EcmaError: ")) {
                    msg = msg.substring(47, msg.length());
                }
                if (msg.startsWith("sun.org.mozilla.javascript.internal.EvaluatorException")) {
                    msg = "Error" + msg.substring(54, msg.length());
                }
                if (msg.length() <= 0 || msg.contains("Macro canceled")) break block10;
                if (this.evaluating) {
                    this.error = msg;
                }
                IJ.log(msg);
            }
        }
    }

    public String toString() {
        return this.result != null ? "" + this.result : "";
    }
}

