/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;

public class Clipboard
implements PlugIn,
Transferable {
    static java.awt.datatransfer.Clipboard clipboard;
    private ImagePlus gImp;

    @Override
    public void run(String arg) {
        if (IJ.altKeyDown()) {
            if (arg.equals("copy")) {
                arg = "scopy";
            } else if (arg.equals("paste")) {
                arg = "spaste";
            }
        }
        if (arg.equals("copy")) {
            this.copy(false);
        } else if (arg.equals("paste")) {
            this.paste();
        } else if (arg.equals("cut")) {
            this.copy(true);
        } else if (arg.equals("scopy")) {
            this.copyToSystem();
        } else if (arg.equals("showsys")) {
            this.showSystemClipboard();
        } else if (arg.equals("show")) {
            this.showInternalClipboard();
        }
    }

    public static void copyToSystem(ImagePlus imp) {
        Clipboard cplugin = new Clipboard();
        cplugin.gImp = imp;
        cplugin.setup();
        try {
            clipboard.setContents(cplugin, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void copy(boolean cut) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.copy(cut);
            if (cut) {
                imp.changes = true;
            }
        } else {
            IJ.noImage();
        }
        if (Recorder.scriptMode()) {
            if (cut) {
                Recorder.recordCall("imp.cut();");
            } else {
                Recorder.recordCall("imp.copy();");
            }
        }
    }

    private ImagePlus flatten(ImagePlus imp) {
        if (imp.getOverlay() != null && !imp.getHideOverlay() && !imp.isHyperStack()) {
            ImagePlus imp2 = imp;
            Roi roi = imp.getRoi();
            if (imp.getStackSize() > 1) {
                imp.deleteRoi();
                int slice = imp.getCurrentSlice();
                imp = new Duplicator().run(imp, slice, slice);
            }
            imp = imp.flatten();
            imp.setRoi(roi);
            imp2.setRoi(roi);
        }
        return imp;
    }

    void paste() {
        if (ImagePlus.getClipboard() == null) {
            this.showSystemClipboard();
        } else {
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.paste();
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("imp.paste();");
                }
            } else {
                this.showInternalClipboard();
            }
        }
    }

    void setup() {
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    void copyToSystem() {
        this.gImp = WindowManager.getCurrentImage();
        this.setup();
        try {
            clipboard.setContents(this, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Recorder.scriptMode()) {
            Recorder.recordCall("imp.copyToSystem();");
        }
    }

    void showSystemClipboard() {
        this.setup();
        IJ.showStatus("Opening system clipboard...");
        try {
            Transferable transferable = clipboard.getContents(null);
            boolean imageSupported = transferable.isDataFlavorSupported(DataFlavor.imageFlavor);
            boolean textSupported = transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (imageSupported) {
                Image img = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                if (img == null) {
                    IJ.error("Unable to convert image on system clipboard");
                    IJ.showStatus("");
                    return;
                }
                int width = img.getWidth(null);
                int height = img.getHeight(null);
                BufferedImage bi = new BufferedImage(width, height, 1);
                Graphics2D g = bi.createGraphics();
                g.drawImage(img, 0, 0, null);
                g.dispose();
                WindowManager.checkForDuplicateName = true;
                new ImagePlus("Clipboard", bi).show();
            } else if (textSupported) {
                String text = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (IJ.isMacintosh()) {
                    text = Tools.fixNewLines(text);
                }
                Editor ed = new Editor();
                ed.setSize(600, 300);
                ed.create("Clipboard", text);
                IJ.showStatus("");
            } else {
                IJ.error("Unable to find an image on the system clipboard");
            }
        }
        catch (Throwable e) {
            IJ.handleException(e);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        boolean overlay;
        ImagePlus imp;
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        ImagePlus imagePlus = imp = this.gImp != null ? this.gImp : WindowManager.getCurrentImage();
        if (imp == null) {
            return null;
        }
        Roi roi = imp.getRoi();
        if (roi != null && !roi.isLine()) {
            Rectangle bounds = roi.getBounds();
            if (bounds.x != 0 || bounds.y != 0 || bounds.width != imp.getWidth() || bounds.height != imp.getHeight()) {
                imp = imp.crop();
            }
        }
        boolean bl = overlay = imp.getOverlay() != null && !imp.getHideOverlay();
        if (overlay && !imp.tempOverlay()) {
            imp = imp.flatten();
        }
        return imp.getImage();
    }

    void showInternalClipboard() {
        ImagePlus clipboard = ImagePlus.getClipboard();
        if (clipboard != null) {
            ImageProcessor ip = clipboard.getProcessor();
            ImagePlus imp2 = new ImagePlus("Clipboard", ip.duplicate());
            Roi roi = clipboard.getRoi();
            imp2.deleteRoi();
            if (roi != null && roi.isArea() && roi.getType() != 0) {
                roi = (Roi)roi.clone();
                roi.setLocation(0, 0);
                imp2.setRoi(roi);
                IJ.run(imp2, "Clear Outside", null);
                imp2.deleteRoi();
            }
            WindowManager.checkForDuplicateName = true;
            imp2.show();
        } else {
            IJ.error("The internal clipboard is empty.");
        }
    }
}

