/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.ThreadUtil;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class RankFilters
implements ExtendedPlugInFilter,
DialogListener {
    public static final int MEAN = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int VARIANCE = 3;
    public static final int MEDIAN = 4;
    public static final int OUTLIERS = 5;
    public static final int DESPECKLE = 6;
    public static final int REMOVE_NAN = 7;
    public static final int OPEN = 8;
    public static final int CLOSE = 9;
    public static final int TOP_HAT = 10;
    public static final int BRIGHT_OUTLIERS = 0;
    public static final int DARK_OUTLIERS = 1;
    private static final String[] outlierStrings = new String[]{"Bright", "Dark"};
    private static int HIGHEST_FILTER = 10;
    private int filterType;
    private double radius;
    private double threshold;
    private int whichOutliers;
    private boolean lightBackground = Prefs.get("bs.background", true);
    private boolean dontSubtract;
    private static double[] lastRadius = new double[HIGHEST_FILTER + 1];
    private static double lastThreshold = 50.0;
    private static int lastWhichOutliers = 0;
    private static boolean lastLightBackground = false;
    private static boolean lastDontSubtract = false;
    int flags = 16777311;
    private ImagePlus imp;
    private int nPasses = 1;
    private PlugInFilterRunner pfr;
    private int pass;
    private boolean previewing = false;
    private int numThreads = Prefs.getThreads();
    private AtomicInteger highestYinCache = new AtomicInteger(Integer.MIN_VALUE);
    private AtomicInteger nThreadsWaiting = new AtomicInteger(0);
    private AtomicBoolean copyingToCache = new AtomicBoolean(false);

    private boolean isMultiStepFilter(int filterType) {
        return filterType >= 8 && filterType <= 10;
    }

    @Override
    public int setup(String arg, ImagePlus imp) {
        Roi roi;
        this.imp = imp;
        if (arg.equals("mean")) {
            this.filterType = 0;
        } else if (arg.equals("min")) {
            this.filterType = 1;
        } else if (arg.equals("max")) {
            this.filterType = 2;
        } else if (arg.equals("variance")) {
            this.filterType = 3;
            this.flags |= 0x10000;
        } else if (arg.equals("median")) {
            this.filterType = 4;
        } else if (arg.equals("outliers")) {
            this.filterType = 5;
        } else if (arg.equals("despeckle")) {
            this.filterType = 6;
        } else if (arg.equals("tophat")) {
            this.filterType = 10;
        } else if (arg.equals("nan")) {
            this.filterType = 7;
            if (imp != null && imp.getBitDepth() != 32) {
                IJ.error("RankFilters", "\"Remove NaNs\" requires a 32-bit image");
                return 4096;
            }
        } else if (arg.equals("final")) {
            this.setDisplayRange(imp.getProcessor());
        } else {
            if (arg.equals("masks")) {
                this.showMasks();
                return 4096;
            }
            IJ.error("RankFilters", "Argument missing or undefined: " + arg);
            return 4096;
        }
        if (this.isMultiStepFilter(this.filterType) && imp != null && (roi = imp.getRoi()) != null && !roi.getBounds().contains(new Rectangle(imp.getWidth(), imp.getHeight()))) {
            this.flags |= 0x4000;
        }
        return this.flags;
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        if (this.filterType == 6) {
            this.filterType = 4;
            this.radius = 1.0;
        } else {
            GenericDialog gd = GUI.newNonBlockingDialog(command, imp);
            this.radius = lastRadius[this.filterType] <= 0.0 ? 2.0 : lastRadius[this.filterType];
            gd.addNumericField("Radius", this.radius, 1, 6, "pixels");
            if (this.filterType == 5) {
                int digits = imp.getType() == 2 ? 2 : 0;
                gd.addNumericField("Threshold", lastThreshold, digits);
                gd.addChoice("Which outliers", outlierStrings, outlierStrings[lastWhichOutliers]);
                gd.addHelp("http://imagej.net/ij/docs/menus/process.html#outliers");
            } else if (this.filterType == 7) {
                gd.addHelp("http://imagej.net/ij/docs/menus/process.html#nans");
            } else if (this.filterType == 10) {
                gd.addCheckbox("Light Background", lastLightBackground);
                gd.addCheckbox("Don't subtract (grayscale open)", lastDontSubtract);
            }
            gd.addPreviewCheckbox(pfr);
            gd.addDialogListener(this);
            this.previewing = true;
            gd.showDialog();
            this.previewing = false;
            if (gd.wasCanceled()) {
                return 4096;
            }
            IJ.register(this.getClass());
            if (Macro.getOptions() == null) {
                RankFilters.lastRadius[this.filterType] = this.radius;
                if (this.filterType == 5) {
                    lastThreshold = this.threshold;
                    lastWhichOutliers = this.whichOutliers;
                } else if (this.filterType == 10) {
                    lastLightBackground = this.lightBackground;
                    lastDontSubtract = this.dontSubtract;
                }
            }
        }
        this.pfr = pfr;
        this.flags = IJ.setupDialog(imp, this.flags);
        if ((this.flags & 0x20) != 0) {
            int size = imp.getWidth() * imp.getHeight();
            Roi roi = imp.getRoi();
            if (roi != null) {
                Rectangle roiRect = roi.getBounds();
                size = roiRect.width * roiRect.height;
            }
            double workToDo = (double)size * this.radius;
            if (this.filterType == 0 || this.filterType == 3) {
                workToDo *= 0.5;
            } else if (this.filterType == 4) {
                workToDo *= this.radius * 0.5;
            }
            if (workToDo < 1000000.0 && imp.getImageStackSize() >= 2 * this.numThreads) {
                this.numThreads = 1;
                this.flags |= 0x8000;
            }
        }
        return this.flags;
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        int maxRadius;
        this.radius = gd.getNextNumber();
        if (this.filterType == 5) {
            this.threshold = gd.getNextNumber();
            this.whichOutliers = gd.getNextChoiceIndex();
        } else if (this.filterType == 10 || this.filterType == 8 || this.filterType == 9) {
            this.lightBackground = gd.getNextBoolean();
            this.dontSubtract = gd.getNextBoolean();
        }
        int n = maxRadius = this.filterType == 4 || this.filterType == 5 || this.filterType == 7 ? 100 : 1000;
        if (gd.invalidNumber() || this.radius < 0.0 || this.radius > (double)maxRadius || this.filterType == 5 && this.threshold < 0.0) {
            return false;
        }
        if (this.filterType == 10) {
            this.flags = this.dontSubtract ? (this.flags &= 0xFFFEFFFF) : (this.flags |= 0x10000);
        }
        return true;
    }

    @Override
    public void run(ImageProcessor ip) {
        this.rank(ip, this.radius, this.filterType, this.whichOutliers, (float)this.threshold, this.lightBackground, this.dontSubtract);
        if (IJ.escapePressed()) {
            ip.reset();
        } else if (this.previewing && (this.flags & 0x10000) != 0) {
            this.setDisplayRange(ip);
        }
    }

    public void rank(ImageProcessor ip, double radius, int filterType) {
        this.rank(ip, radius, filterType, 0, 50.0f);
    }

    public void rank(ImageProcessor ip, double radius, int filterType, int whichOutliers, float threshold) {
        this.rank(ip, radius, filterType, whichOutliers, threshold, false, false);
    }

    public void rank(ImageProcessor ip, double radius, int filterType, int whichOutliers, float threshold, boolean lightBackground, boolean dontSubtract) {
        float minMaxOutliersSign;
        boolean snapshotRequired;
        Rectangle roi = ip.getRoi();
        ImageProcessor mask = ip.getMask();
        Rectangle roi1 = null;
        int[] lineRadii = this.makeLineRadii(radius);
        boolean bl = snapshotRequired = filterType == 10 && !dontSubtract || this.isMultiStepFilter(filterType) && (roi.width != ip.getWidth() || roi.height != ip.getHeight());
        if (snapshotRequired && ip.getSnapshotPixels() == null) {
            ip.snapshot();
        }
        float f = minMaxOutliersSign = filterType == 1 || filterType == 8 ? -1.0f : 1.0f;
        if (filterType == 5) {
            float f2 = minMaxOutliersSign = ip.isInvertedLut() == (whichOutliers == 1) ? -1.0f : 1.0f;
        }
        if (filterType == 10) {
            boolean invertedLut = ip.isInvertedLut();
            boolean invert = invertedLut && !lightBackground || !invertedLut && lightBackground;
            minMaxOutliersSign = invert ? 1.0f : -1.0f;
        }
        ImageProcessor snapIp = null;
        FloatProcessor fp = null;
        FloatProcessor snapFp = null;
        boolean isImagePart = roi.width < ip.getWidth() || roi.height < ip.getHeight();
        AtomicInteger nextY = new AtomicInteger();
        if (filterType == 10 && !dontSubtract) {
            snapIp = ip.createProcessor(ip.getWidth(), ip.getHeight());
            snapIp.setPixels(ip.getSnapshotPixels());
        }
        for (int ch = 0; ch < ip.getNChannels(); ++ch) {
            int filterType1 = filterType;
            if (this.isMultiStepFilter(filterType)) {
                int n = filterType1 = minMaxOutliersSign == -1.0f ? 1 : 2;
                if (isImagePart) {
                    int kRadius = this.kRadius(lineRadii);
                    int kHeight = this.kHeight(lineRadii);
                    Rectangle roiClone = (Rectangle)roi.clone();
                    roiClone.grow(kRadius, kHeight / 2);
                    roi1 = roiClone.intersection(new Rectangle(ip.getWidth(), ip.getHeight()));
                    ip.setRoi(roi1);
                }
            }
            this.doFiltering(ip, lineRadii, filterType1, minMaxOutliersSign, threshold, ch, nextY);
            if (this.isMultiStepFilter(filterType)) {
                ip.setRoi(roi);
                ip.setMask(mask);
                if (nextY.get() < 0) break;
                int filterType2 = minMaxOutliersSign == -1.0f ? 2 : 1;
                this.doFiltering(ip, lineRadii, filterType2, -minMaxOutliersSign, threshold, ch, nextY);
                if (isImagePart) {
                    this.resetRoiBoundary(ip, roi, roi1);
                }
            }
            if (nextY.get() < 0) break;
            if (filterType != 10 || dontSubtract) continue;
            float offset = 0.0f;
            if (minMaxOutliersSign == 1.0f && !(ip instanceof FloatProcessor)) {
                offset = (float)ip.maxValue();
            }
            fp = ip.toFloat(ch, fp);
            snapFp = snapIp.toFloat(ch, snapFp);
            float[] pixels = (float[])fp.getPixels();
            float[] snapPixels = (float[])snapFp.getPixels();
            int width = ip.getWidth();
            for (int y = roi.y; y < roi.y + roi.height; ++y) {
                int ix = 0;
                int p = y * width + roi.x;
                while (ix < roi.width) {
                    pixels[p] = snapPixels[p] - pixels[p] + offset;
                    ++ix;
                    ++p;
                }
            }
            ip.setPixels(ch, fp);
        }
    }

    private void doFiltering(final ImageProcessor ip, final int[] lineRadii, final int filterType, final float minMaxOutliersSign, final float threshold, final int colorChannel, final AtomicInteger nextY) {
        Rectangle roi = ip.getRoi();
        int width = ip.getWidth();
        Object pixels = ip.getPixels();
        int numThreads = Math.min(roi.height, this.numThreads);
        if (numThreads == 0) {
            return;
        }
        int kHeight = this.kHeight(lineRadii);
        int kRadius = this.kRadius(lineRadii);
        final int cacheWidth = roi.width + 2 * kRadius;
        final int cacheHeight = kHeight + (numThreads > 1 ? 2 * numThreads : 0);
        final float[] cache = new float[cacheWidth * cacheHeight];
        this.highestYinCache.set(Math.max(roi.y - kHeight / 2, 0) - 1);
        final AtomicIntegerArray yForThread = new AtomicIntegerArray(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            yForThread.set(i, -1);
        }
        nextY.set(roi.y);
        Callable[] callables = new Callable[numThreads - 1];
        for (int i = 0; i < numThreads - 1; ++i) {
            final int threadNumber = i + 1;
            callables[i] = new Callable<Void>(){

                @Override
                public final Void call() {
                    RankFilters.this.doFiltering(ip, lineRadii, cache, cacheWidth, cacheHeight, filterType, minMaxOutliersSign, threshold, colorChannel, yForThread, threadNumber, nextY);
                    return null;
                }
            };
        }
        Future[] futures = ThreadUtil.start(callables);
        this.doFiltering(ip, lineRadii, cache, cacheWidth, cacheHeight, filterType, minMaxOutliersSign, threshold, colorChannel, yForThread, 0, nextY);
        ThreadUtil.joinAll(futures);
        this.showProgress(1.0, ip instanceof ColorProcessor);
        ++this.pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doFiltering(ImageProcessor ip, int[] lineRadii, float[] cache, int cacheWidth, int cacheHeight, int filterType, float minMaxOutliersSign, float threshold, int colorChannel, AtomicIntegerArray yForThread, int threadNumber, AtomicInteger nextY) {
        if (nextY.get() < 0) return;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        int kHeight = this.kHeight(lineRadii);
        int kRadius = this.kRadius(lineRadii);
        int kNPoints = this.kNPoints(lineRadii);
        int xmin = roi.x - kRadius;
        int xmax = roi.x + roi.width + kRadius;
        int[] cachePointers = this.makeCachePointers(lineRadii, cacheWidth);
        int padLeft = xmin < 0 ? -xmin : 0;
        int padRight = xmax > width ? xmax - width : 0;
        int xminInside = xmin > 0 ? xmin : 0;
        int xmaxInside = xmax < width ? xmax : width;
        int widthInside = xmaxInside - xminInside;
        boolean minOrMax = filterType == 1 || filterType == 2;
        boolean minOrMaxOrOutliers = minOrMax || filterType == 5;
        boolean sumFilter = filterType == 0 || filterType == 3;
        boolean medianFilter = filterType == 4 || filterType == 5;
        double[] sums = sumFilter ? new double[2] : null;
        float[] medianBuf1 = (float[])(medianFilter || filterType == 7 ? new float[kNPoints] : null);
        float[] medianBuf2 = (float[])(medianFilter || filterType == 7 ? new float[kNPoints] : null);
        boolean smallKernel = kRadius < 2;
        Object pixels = ip.getPixels();
        boolean isFloat = pixels instanceof float[];
        float maxValue = isFloat ? Float.NaN : (float)ip.maxValue();
        float[] values = isFloat ? (float[])pixels : new float[roi.width];
        int numThreads = yForThread.length();
        long lastTime = System.currentTimeMillis();
        int previousY = kHeight / 2 - cacheHeight;
        boolean rgb = ip instanceof ColorProcessor;
        while (true) {
            int slowestThreadY;
            long time;
            boolean threadFinished;
            int y;
            if ((y = nextY.getAndIncrement()) >= 0) {
                yForThread.set(threadNumber, y);
            }
            boolean bl = threadFinished = y >= roi.y + roi.height || y < 0;
            if (numThreads > 1 && (this.nThreadsWaiting.get() > 0 || threadFinished)) {
                RankFilters rankFilters = this;
                // MONITORENTER : rankFilters
                this.notifyAll();
                // MONITOREXIT : rankFilters
            }
            if (threadFinished) {
                return;
            }
            if (threadNumber == 0 && (time = System.currentTimeMillis()) - lastTime > 100L) {
                lastTime = time;
                this.showProgress((double)(y - roi.y) / (double)roi.height, rgb);
                if (Thread.currentThread().isInterrupted() || this.imp != null && IJ.escapePressed()) {
                    nextY.set(Integer.MIN_VALUE);
                    RankFilters rankFilters = this;
                    // MONITORENTER : rankFilters
                    this.notifyAll();
                    // MONITOREXIT : rankFilters
                    return;
                }
            }
            for (int i = 0; i < cachePointers.length; ++i) {
                cachePointers[i] = (cachePointers[i] + cacheWidth * (y - previousY)) % cache.length;
            }
            previousY = y;
            if (numThreads > 1 && y - (slowestThreadY = this.arrayMinNonNegative(yForThread)) + kHeight > cacheHeight) {
                this.nThreadsWaiting.incrementAndGet();
                RankFilters rankFilters = this;
                // MONITORENTER : rankFilters
                slowestThreadY = this.arrayMinNonNegative(yForThread);
                if (y - slowestThreadY + kHeight > cacheHeight) {
                    do {
                        try {
                            this.wait();
                            if (nextY.get() < 0) {
                                // MONITOREXIT : rankFilters
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            nextY.set(Integer.MIN_VALUE);
                            this.notifyAll();
                            Thread.currentThread().interrupt();
                            // MONITOREXIT : rankFilters
                            return;
                        }
                    } while (y - (slowestThreadY = this.arrayMinNonNegative(yForThread)) + kHeight > cacheHeight);
                }
                // MONITOREXIT : rankFilters
                this.nThreadsWaiting.decrementAndGet();
            }
            if (numThreads == 1) {
                int yStartReading;
                for (int yNew = yStartReading = y == roi.y ? Math.max(roi.y - kHeight / 2, 0) : y + kHeight / 2; yNew <= y + kHeight / 2; ++yNew) {
                    RankFilters.readLineToCacheOrPad(pixels, width, height, roi.y, xminInside, widthInside, cache, cacheWidth, cacheHeight, padLeft, padRight, colorChannel, kHeight, yNew);
                }
            } else if (!this.copyingToCache.get() || this.highestYinCache.get() < y + kHeight / 2) {
                float[] yStartReading = cache;
                // MONITORENTER : cache
                this.copyingToCache.set(true);
                while (this.highestYinCache.get() < this.arrayMinNonNegative(yForThread) - kHeight / 2 + cacheHeight - 1) {
                    int yNew = this.highestYinCache.get() + 1;
                    RankFilters.readLineToCacheOrPad(pixels, width, height, roi.y, xminInside, widthInside, cache, cacheWidth, cacheHeight, padLeft, padRight, colorChannel, kHeight, yNew);
                    this.highestYinCache.set(yNew);
                }
                this.copyingToCache.set(false);
                // MONITOREXIT : yStartReading
            }
            int cacheLineP = cacheWidth * (y % cacheHeight) + kRadius;
            this.filterLine(values, width, cache, cachePointers, kNPoints, cacheLineP, roi, y, sums, medianBuf1, medianBuf2, minMaxOutliersSign, maxValue, isFloat, filterType, smallKernel, sumFilter, minOrMax, minOrMaxOrOutliers, threshold);
            if (isFloat) continue;
            RankFilters.writeLineToPixels(values, pixels, roi.x + y * width, roi.width, colorChannel);
        }
    }

    private int arrayMinNonNegative(AtomicIntegerArray array) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < array.length(); ++i) {
            int v = array.get(i);
            if (v >= min) continue;
            min = v;
        }
        return min < 0 ? 0 : min;
    }

    private void filterLine(float[] values, int width, float[] cache, int[] cachePointers, int kNPoints, int cacheLineP, Rectangle roi, int y, double[] sums, float[] medianBuf1, float[] medianBuf2, float minMaxOutliersSign, float maxValue, boolean isFloat, int filterType, boolean smallKernel, boolean sumFilter, boolean minOrMax, boolean minOrMaxOrOutliers, float threshold) {
        int valuesP = isFloat ? roi.x + y * width : 0;
        float max = 0.0f;
        float median = Float.isNaN(cache[cacheLineP]) ? 0.0f : cache[cacheLineP];
        boolean fullCalculation = true;
        int x = 0;
        while (x < roi.width) {
            block26: {
                block27: {
                    block28: {
                        block24: {
                            block25: {
                                if (!fullCalculation) break block24;
                                fullCalculation = smallKernel;
                                if (minOrMaxOrOutliers) {
                                    max = RankFilters.getAreaMax(cache, x, cachePointers, 0, -3.4028235E38f, minMaxOutliersSign);
                                }
                                if (!minOrMax) break block25;
                                values[valuesP] = max * minMaxOutliersSign;
                                break block26;
                            }
                            if (sumFilter) {
                                RankFilters.getAreaSums(cache, x, cachePointers, sums);
                            }
                            break block27;
                        }
                        if (!minOrMaxOrOutliers) break block28;
                        float newPointsMax = RankFilters.getSideMax(cache, x, cachePointers, true, minMaxOutliersSign);
                        if (newPointsMax >= max) {
                            max = newPointsMax;
                        } else {
                            float removedPointsMax = RankFilters.getSideMax(cache, x, cachePointers, false, minMaxOutliersSign);
                            if (removedPointsMax >= max) {
                                max = RankFilters.getAreaMax(cache, x, cachePointers, 1, newPointsMax, minMaxOutliersSign);
                            }
                        }
                        if (!minOrMax) break block27;
                        values[valuesP] = max * minMaxOutliersSign;
                        break block26;
                    }
                    if (sumFilter) {
                        RankFilters.addSideSums(cache, x, cachePointers, sums);
                        if (Double.isNaN(sums[0])) {
                            fullCalculation = true;
                        }
                    }
                }
                if (sumFilter) {
                    if (filterType == 0) {
                        values[valuesP] = (float)(sums[0] / (double)kNPoints);
                    } else {
                        float value = (float)((sums[1] - sums[0] * sums[0] / (double)kNPoints) / (double)kNPoints);
                        if (value > maxValue) {
                            value = maxValue;
                        }
                        if (value < 0.0f) {
                            value = 0.0f;
                        }
                        values[valuesP] = value;
                    }
                } else if (filterType == 4) {
                    if (isFloat) {
                        median = Float.isNaN(values[valuesP]) ? Float.NaN : values[valuesP];
                        median = RankFilters.getNaNAwareMedian(cache, x, cachePointers, medianBuf1, medianBuf2, kNPoints, median);
                    } else {
                        median = RankFilters.getMedian(cache, x, cachePointers, medianBuf1, medianBuf2, kNPoints, median);
                    }
                    values[valuesP] = median;
                } else if (filterType == 5) {
                    float v = cache[cacheLineP + x];
                    if (v * minMaxOutliersSign + threshold < max && v * minMaxOutliersSign + threshold < (median = RankFilters.getMedian(cache, x, cachePointers, medianBuf1, medianBuf2, kNPoints, median)) * minMaxOutliersSign) {
                        v = median;
                    }
                    values[valuesP] = v;
                } else if (filterType == 7) {
                    if (Float.isNaN(values[valuesP])) {
                        values[valuesP] = RankFilters.getNaNAwareMedian(cache, x, cachePointers, medianBuf1, medianBuf2, kNPoints, median);
                    } else {
                        median = values[valuesP];
                    }
                }
            }
            ++x;
            ++valuesP;
        }
    }

    private static void readLineToCacheOrPad(Object pixels, int width, int height, int roiY, int xminInside, int widthInside, float[] cache, int cacheWidth, int cacheHeight, int padLeft, int padRight, int colorChannel, int kHeight, int y) {
        int lineInCache = y % cacheHeight;
        if (y < height) {
            RankFilters.readLineToCache(pixels, y * width, xminInside, widthInside, cache, lineInCache * cacheWidth, padLeft, padRight, colorChannel);
            if (y == 0) {
                for (int prevY = roiY - kHeight / 2; prevY < 0; ++prevY) {
                    int prevLineInCache = cacheHeight + prevY;
                    System.arraycopy(cache, 0, cache, prevLineInCache * cacheWidth, cacheWidth);
                }
            }
        } else {
            System.arraycopy(cache, cacheWidth * ((height - 1) % cacheHeight), cache, lineInCache * cacheWidth, cacheWidth);
        }
    }

    private static void readLineToCache(Object pixels, int pixelLineP, int xminInside, int widthInside, float[] cache, int cacheLineP, int padLeft, int padRight, int colorChannel) {
        int cp;
        int cp2;
        int pp;
        if (pixels instanceof byte[]) {
            byte[] bPixels = (byte[])pixels;
            pp = pixelLineP + xminInside;
            cp2 = cacheLineP + padLeft;
            while (pp < pixelLineP + xminInside + widthInside) {
                cache[cp2] = bPixels[pp] & 0xFF;
                ++pp;
                ++cp2;
            }
        } else if (pixels instanceof short[]) {
            short[] sPixels = (short[])pixels;
            pp = pixelLineP + xminInside;
            cp2 = cacheLineP + padLeft;
            while (pp < pixelLineP + xminInside + widthInside) {
                cache[cp2] = sPixels[pp] & 0xFFFF;
                ++pp;
                ++cp2;
            }
        } else if (pixels instanceof float[]) {
            System.arraycopy(pixels, pixelLineP + xminInside, cache, cacheLineP + padLeft, widthInside);
        } else {
            int[] cPixels = (int[])pixels;
            int shift = 16 - 8 * colorChannel;
            int byteMask = 255 << shift;
            int pp2 = pixelLineP + xminInside;
            int cp3 = cacheLineP + padLeft;
            while (pp2 < pixelLineP + xminInside + widthInside) {
                cache[cp3] = (cPixels[pp2] & byteMask) >> shift;
                ++pp2;
                ++cp3;
            }
        }
        for (cp = cacheLineP; cp < cacheLineP + padLeft; ++cp) {
            cache[cp] = cache[cacheLineP + padLeft];
        }
        for (cp = cacheLineP + padLeft + widthInside; cp < cacheLineP + padLeft + widthInside + padRight; ++cp) {
            cache[cp] = cache[cacheLineP + padLeft + widthInside - 1];
        }
    }

    private static void writeLineToPixels(float[] values, Object pixels, int pixelP, int length, int colorChannel) {
        if (pixels instanceof byte[]) {
            byte[] bPixels = (byte[])pixels;
            int i = 0;
            int p = pixelP;
            while (i < length) {
                bPixels[p] = (byte)((int)(values[i] + 0.5f) & 0xFF);
                ++i;
                ++p;
            }
        } else if (pixels instanceof short[]) {
            short[] sPixels = (short[])pixels;
            int i = 0;
            int p = pixelP;
            while (i < length) {
                sPixels[p] = (short)((int)(values[i] + 0.5f) & 0xFFFF);
                ++i;
                ++p;
            }
        } else {
            int[] cPixels = (int[])pixels;
            int shift = 16 - 8 * colorChannel;
            int resetMask = 0xFFFFFFFF ^ 255 << shift;
            int i = 0;
            int p = pixelP;
            while (i < length) {
                cPixels[p] = cPixels[p] & resetMask | (int)(values[i] + 0.5f) << shift;
                ++i;
                ++p;
            }
        }
    }

    private static float getAreaMax(float[] cache, int xCache0, int[] kernel, int ignoreRight, float max, float sign) {
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0 - ignoreRight; ++p) {
                float v = cache[p] * sign;
                if (!(max < v)) continue;
                max = v;
            }
        }
        return max;
    }

    private static float getSideMax(float[] cache, int xCache0, int[] kernel, boolean isRight, float sign) {
        int kk;
        float max = -3.4028235E38f;
        if (!isRight) {
            --xCache0;
        }
        int n = kk = isRight ? 1 : 0;
        while (kk < kernel.length) {
            float v = cache[xCache0 + kernel[kk]] * sign;
            if (max < v) {
                max = v;
            }
            kk += 2;
        }
        return max;
    }

    private static void getAreaSums(float[] cache, int xCache0, int[] kernel, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0; ++p) {
                double v = cache[p];
                sum += v;
                sum2 += v * v;
            }
        }
        sums[0] = sum;
        sums[1] = sum2;
    }

    private static void addSideSums(float[] cache, int xCache0, int[] kernel, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        int kk = 0;
        while (kk < kernel.length) {
            double v = cache[kernel[kk++] + (xCache0 - 1)];
            sum -= v;
            sum2 -= v * v;
            v = cache[kernel[kk++] + xCache0];
            sum += v;
            sum2 += v * v;
        }
        sums[0] = sums[0] + sum;
        sums[1] = sums[1] + sum2;
    }

    private static float getMedian(float[] cache, int xCache0, int[] kernel, float[] aboveBuf, float[] belowBuf, int kNPoints, float guess) {
        int nAbove = 0;
        int nBelow = 0;
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0; ++p) {
                float v = cache[p];
                if (v > guess) {
                    aboveBuf[nAbove] = v;
                    ++nAbove;
                    continue;
                }
                if (!(v < guess)) continue;
                belowBuf[nBelow] = v;
                ++nBelow;
            }
        }
        int half = kNPoints / 2;
        if (nAbove > half) {
            return RankFilters.findNthLowestNumber(aboveBuf, nAbove, nAbove - half - 1);
        }
        if (nBelow > half) {
            return RankFilters.findNthLowestNumber(belowBuf, nBelow, half);
        }
        return guess;
    }

    private static float getNaNAwareMedian(float[] cache, int xCache0, int[] kernel, float[] aboveBuf, float[] belowBuf, int kNPoints, float guess) {
        int nAbove = 0;
        int nBelow = 0;
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0; ++p) {
                float v = cache[p];
                if (Float.isNaN(v)) {
                    --kNPoints;
                    continue;
                }
                if (v > guess) {
                    aboveBuf[nAbove] = v;
                    ++nAbove;
                    continue;
                }
                if (!(v < guess)) continue;
                belowBuf[nBelow] = v;
                ++nBelow;
            }
        }
        if (kNPoints == 0) {
            return Float.NaN;
        }
        int half = kNPoints / 2;
        if (nAbove > half) {
            return RankFilters.findNthLowestNumber(aboveBuf, nAbove, nAbove - half - 1);
        }
        if (nBelow > half) {
            return RankFilters.findNthLowestNumber(belowBuf, nBelow, half);
        }
        return guess;
    }

    public static final float findNthLowestNumber(float[] buf, int bufLength, int n) {
        int l = 0;
        int m = bufLength - 1;
        float med = buf[n];
        while (l < m) {
            int i = l;
            int j = m;
            while (true) {
                if (buf[i] < med) {
                    ++i;
                    continue;
                }
                while (med < buf[j]) {
                    --j;
                }
                float dum = buf[j];
                buf[j] = buf[i];
                buf[i] = dum;
                if (--j < n || ++i > n) break;
            }
            if (j < n) {
                l = i;
            }
            if (n < i) {
                m = j;
            }
            med = buf[n];
        }
        return med;
    }

    private void resetRoiBoundary(ImageProcessor ip, Rectangle roi, Rectangle roi1) {
        int width = ip.getWidth();
        Object pixels = ip.getPixels();
        Object snapshot = ip.getSnapshotPixels();
        int y = roi1.y;
        int p = roi1.x + y * width;
        while (y < roi.y) {
            System.arraycopy(snapshot, p, pixels, p, roi1.width);
            ++y;
            p += width;
        }
        int leftWidth = roi.x - roi1.x;
        int rightWidth = roi1.x + roi1.width - (roi.x + roi.width);
        int y2 = roi.y;
        int pL = roi1.x + y2 * width;
        int pR = roi.x + roi.width + y2 * width;
        while (y2 < roi.y + roi.height) {
            if (leftWidth > 0) {
                System.arraycopy(snapshot, pL, pixels, pL, leftWidth);
            }
            if (rightWidth > 0) {
                System.arraycopy(snapshot, pR, pixels, pR, rightWidth);
            }
            ++y2;
            pL += width;
            pR += width;
        }
        y2 = roi.y + roi.height;
        int p2 = roi1.x + y2 * width;
        while (y2 < roi1.y + roi1.height) {
            System.arraycopy(snapshot, p2, pixels, p2, roi1.width);
            ++y2;
            p2 += width;
        }
    }

    public void makeKernel(double radius) {
        this.radius = radius;
    }

    private void setDisplayRange(ImageProcessor ip) {
        if (ip instanceof ByteProcessor || ip instanceof ColorProcessor) {
            return;
        }
        new ContrastEnhancer().stretchHistogram(ip, 0.5);
    }

    protected int[] makeLineRadii(double radius) {
        if (radius >= 1.5 && radius < 1.75) {
            radius = 1.75;
        } else if (radius >= 2.5 && radius < 2.85) {
            radius = 2.85;
        }
        int r2 = (int)(radius * radius) + 1;
        int kRadius = (int)Math.sqrt((double)r2 + 1.0E-10);
        int kHeight = 2 * kRadius + 1;
        int[] kernel = new int[2 * kHeight + 2];
        kernel[2 * kRadius] = -kRadius;
        kernel[2 * kRadius + 1] = kRadius;
        int nPoints = 2 * kRadius + 1;
        for (int y = 1; y <= kRadius; ++y) {
            int dx = (int)Math.sqrt((double)(r2 - y * y) + 1.0E-10);
            kernel[2 * (kRadius - y)] = -dx;
            kernel[2 * (kRadius - y) + 1] = dx;
            kernel[2 * (kRadius + y)] = -dx;
            kernel[2 * (kRadius + y) + 1] = dx;
            nPoints += 4 * dx + 2;
        }
        kernel[kernel.length - 2] = nPoints;
        kernel[kernel.length - 1] = kRadius;
        return kernel;
    }

    private int kHeight(int[] lineRadii) {
        return (lineRadii.length - 2) / 2;
    }

    private int kRadius(int[] lineRadii) {
        return lineRadii[lineRadii.length - 1];
    }

    private int kNPoints(int[] lineRadii) {
        return lineRadii[lineRadii.length - 2];
    }

    private int[] makeCachePointers(int[] lineRadii, int cacheWidth) {
        int kRadius = this.kRadius(lineRadii);
        int kHeight = this.kHeight(lineRadii);
        int[] cachePointers = new int[2 * kHeight];
        for (int i = 0; i < kHeight; ++i) {
            cachePointers[2 * i] = i * cacheWidth + kRadius + lineRadii[2 * i];
            cachePointers[2 * i + 1] = i * cacheWidth + kRadius + lineRadii[2 * i + 1];
        }
        return cachePointers;
    }

    void showMasks() {
        int w = 150;
        int h = 150;
        ImageStack stack = new ImageStack(w, h);
        for (double r = 0.5; r < 50.0; r += 0.5) {
            FloatProcessor ip = new FloatProcessor(w, h, new int[w * h]);
            float[] pixels = (float[])((ImageProcessor)ip).getPixels();
            int[] lineRadii = this.makeLineRadii(r);
            int kHeight = this.kHeight(lineRadii);
            int kRadius = this.kRadius(lineRadii);
            int y0 = h / 2 - kHeight / 2;
            int i = 0;
            int y = y0;
            while (i < kHeight) {
                int x = w / 2 + lineRadii[2 * i];
                int p = x + y * w;
                while (x <= w / 2 + lineRadii[2 * i + 1]) {
                    pixels[p] = 1.0f;
                    ++x;
                    ++p;
                }
                ++i;
                ++y;
            }
            stack.addSlice("radius=" + r + ", size=" + (2 * kRadius + 1), ip);
        }
        new ImagePlus("Masks", stack).show();
    }

    @Override
    public void setNPasses(int nPasses) {
        this.nPasses = nPasses;
        this.pass = 0;
    }

    private void showProgress(double percent, boolean rgb) {
        if (this.nPasses == 0) {
            return;
        }
        int nPasses2 = rgb ? this.nPasses * 3 : this.nPasses;
        percent = (double)this.pass / (double)nPasses2 + percent / (double)nPasses2;
        IJ.showProgress(percent);
    }
}

