/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

public class StackStatistics
extends ImageStatistics {
    public StackStatistics(ImagePlus imp) {
        this(imp, 256, 0.0, imp.getBitDepth() == 8 || imp.getBitDepth() == 24 ? 256.0 : 0.0);
    }

    public StackStatistics(ImagePlus imp, int nBins, double xMin, double xMax) {
        int bits = imp.getBitDepth();
        this.stackStatistics = true;
        if ((bits == 8 || bits == 24) && nBins == 256 && xMin == 0.0 && xMax == 256.0) {
            this.sum8BitHistograms(imp);
        } else if (bits == 16 && nBins == 256 && xMin == 0.0 && xMax == 0.0 && !imp.getCalibration().calibrated()) {
            this.sum16BitHistograms(imp);
        } else {
            this.doCalculations(imp, nBins, xMin, xMax);
        }
    }

    void doCalculations(ImagePlus imp, int bins, double histogramMin, double histogramMax) {
        double v;
        int rh;
        int rw;
        int ry;
        int rx;
        ImageProcessor ip = imp.getProcessor();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        double minThreshold = -3.4028234663852886E38;
        double maxThreshold = 3.4028234663852886E38;
        Calibration cal = imp.getCalibration();
        if (limitToThreshold && ip.isThreshold()) {
            minThreshold = cal.getCValue(ip.getMinThreshold());
            maxThreshold = cal.getCValue(ip.getMaxThreshold());
        }
        this.nBins = bins;
        this.histMin = histogramMin;
        this.histMax = histogramMax;
        ImageStack stack = imp.getStack();
        int size = stack.size();
        ip.setRoi(imp.getRoi());
        byte[] mask = ip.getMaskArray();
        float[] cTable = imp.getCalibration().getCTable();
        this.longHistogram = new long[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        if (roi != null) {
            rx = roi.x;
            ry = roi.y;
            rw = roi.width;
            rh = roi.height;
        } else {
            rx = 0;
            ry = 0;
            rw = width;
            rh = height;
        }
        double pw = 1.0;
        double ph = 1.0;
        this.roiX = (double)rx * pw;
        this.roiY = (double)ry * ph;
        this.roiWidth = (double)rw * pw;
        this.roiHeight = (double)rh * ph;
        boolean fixedRange = this.histMin != 0.0 || this.histMax != 0.0;
        double roiMin = Double.MAX_VALUE;
        double roiMax = -1.7976931348623157E308;
        for (int slice = 1; slice <= size; ++slice) {
            IJ.showStatus("Calculating stack histogram...");
            IJ.showProgress(slice / 2, size);
            ip = stack.getProcessor(slice);
            int y = ry;
            int my = 0;
            while (y < ry + rh) {
                int i = y * width + rx;
                int mi = my * rw;
                for (int x = rx; x < rx + rw; ++x) {
                    if ((mask == null || mask[mi++] != 0) && (v = (double)ip.getPixelValue(x, y)) >= minThreshold && v <= maxThreshold) {
                        if (v < roiMin) {
                            roiMin = v;
                        }
                        if (v > roiMax) {
                            roiMax = v;
                        }
                    }
                    ++i;
                }
                ++y;
                ++my;
            }
        }
        this.min = roiMin;
        this.max = roiMax;
        if (fixedRange) {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        } else {
            this.histMin = this.min;
            this.histMax = this.max;
        }
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        boolean first = true;
        for (int slice = 1; slice <= size; ++slice) {
            IJ.showProgress(size / 2 + slice / 2, size);
            ip = stack.getProcessor(slice);
            ip.setCalibrationTable(cTable);
            int y = ry;
            int my = 0;
            while (y < ry + rh) {
                int i = y * width + rx;
                int mi = my * rw;
                for (int x = rx; x < rx + rw; ++x) {
                    if ((mask == null || mask[mi++] != 0) && (v = (double)ip.getPixelValue(x, y)) >= minThreshold && v <= maxThreshold && v >= this.histMin && v <= this.histMax) {
                        ++this.longPixelCount;
                        sum += v;
                        sum2 += v * v;
                        int index = (int)(scale * (v - this.histMin));
                        if (index >= this.nBins) {
                            index = this.nBins - 1;
                        }
                        int n = index;
                        this.longHistogram[n] = this.longHistogram[n] + 1L;
                    }
                    ++i;
                }
                ++y;
                ++my;
            }
        }
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * pw * ph;
        this.mean = sum / (double)this.longPixelCount;
        this.calculateStdDev(this.longPixelCount, sum, sum2);
        this.histMin = cal.getRawValue(this.histMin);
        this.histMax = cal.getRawValue(this.histMax);
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        int bits = imp.getBitDepth();
        if (this.histMin == 0.0 && this.histMax == 256.0 && (bits == 8 || bits == 24)) {
            this.histMax = 255.0;
        }
        this.dmode = this.getMode(cal);
        this.copyHistogram(this.nBins);
        this.median = this.getMedian(this.longHistogram, (int)minThreshold, (int)maxThreshold, cal);
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    void sum8BitHistograms(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        int minThreshold = 0;
        int maxThreshold = 255;
        ImageProcessor ip = imp.getProcessor();
        if (limitToThreshold && ip.isThreshold()) {
            minThreshold = (int)ip.getMinThreshold();
            maxThreshold = (int)ip.getMaxThreshold();
        }
        ImageStack stack = imp.getStack();
        Roi roi = imp.getRoi();
        this.longHistogram = new long[256];
        int n = stack.size();
        for (int slice = 1; slice <= n; ++slice) {
            IJ.showProgress(slice, n);
            ip = stack.getProcessor(slice);
            if (roi != null) {
                ip.setRoi(roi);
            }
            int[] hist = ip.getHistogram();
            for (int i = 0; i < 256; ++i) {
                int n2 = i;
                this.longHistogram[n2] = this.longHistogram[n2] + (long)hist[i];
            }
        }
        this.pw = 1.0;
        this.ph = 1.0;
        this.getRawStatistics(this.longHistogram, minThreshold, maxThreshold);
        this.getRawMinAndMax(this.longHistogram, minThreshold, maxThreshold);
        this.copyHistogram(256);
        this.median = this.getMedian(this.longHistogram, minThreshold, maxThreshold, cal);
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    private void copyHistogram(int nbins) {
        this.histogram = new int[nbins];
        for (int i = 0; i < nbins; ++i) {
            long count = this.longHistogram[i];
            this.histogram[i] = count <= Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
        }
    }

    void getRawStatistics(long[] histogram, int minThreshold, int maxThreshold) {
        long longMaxCount = 0L;
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = minThreshold; i <= maxThreshold; ++i) {
            long count = histogram[i];
            this.longPixelCount += count;
            sum += (double)i * (double)count;
            double value = i;
            sum2 += value * value * (double)count;
            if (count <= longMaxCount) continue;
            longMaxCount = count;
            this.mode = i;
        }
        this.maxCount = (int)longMaxCount;
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.longPixelCount;
        this.dmode = this.mode;
        this.calculateStdDev(this.longPixelCount, sum, sum2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void getRawMinAndMax(long[] histogram, int minThreshold, int maxThreshold) {
        int max;
        int min;
        for (min = minThreshold; histogram[min] == 0L && min < 255; ++min) {
        }
        this.min = min;
        for (max = maxThreshold; histogram[max] == 0L && max > 0; --max) {
        }
        this.max = max;
    }

    void sum16BitHistograms(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        int minThreshold = 0;
        int maxThreshold = 65535;
        ImageProcessor ip = imp.getProcessor();
        if (limitToThreshold && ip.getMinThreshold() != -808080.0) {
            minThreshold = (int)ip.getMinThreshold();
            maxThreshold = (int)ip.getMaxThreshold();
        }
        ImageStack stack = imp.getStack();
        Roi roi = imp.getRoi();
        long[] hist16 = new long[65536];
        int n = stack.size();
        for (int slice = 1; slice <= n; ++slice) {
            IJ.showProgress(slice, n);
            IJ.showStatus(slice + "/" + n);
            ip = stack.getProcessor(slice);
            if (roi != null) {
                ip.setRoi(roi);
            }
            int[] hist = ip.getHistogram();
            for (int i = 0; i < 65536; ++i) {
                int n2 = i;
                hist16[n2] = hist16[n2] + (long)hist[i];
            }
        }
        this.pw = 1.0;
        this.ph = 1.0;
        this.getRaw16BitMinAndMax(hist16, minThreshold, maxThreshold);
        this.get16BitStatistics(hist16, (int)this.min, (int)this.max);
        this.median = this.getMedian(hist16, minThreshold, maxThreshold, cal);
        this.histogram16 = new int[65536];
        for (int i = 0; i < 65536; ++i) {
            long count = hist16[i];
            this.histogram16[i] = count <= Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
        }
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    void getRaw16BitMinAndMax(long[] hist, int minThreshold, int maxThreshold) {
        int max;
        int min;
        for (min = minThreshold; hist[min] == 0L && min < 65535; ++min) {
        }
        this.min = min;
        for (max = maxThreshold; hist[max] == 0L && max > 0; --max) {
        }
        this.max = max;
    }

    void get16BitStatistics(long[] hist, int min, int max) {
        double sum = 0.0;
        double sum2 = 0.0;
        this.nBins = 256;
        this.histMin = min;
        this.histMax = max;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double scale = 1.0 / this.binSize;
        int hMin = (int)this.histMin;
        this.longHistogram = new long[this.nBins];
        this.maxCount = 0;
        for (int i = min; i <= max; ++i) {
            long count = hist[i];
            this.longPixelCount += count;
            double value = i;
            sum += value * (double)count;
            sum2 += value * value * (double)count;
            int index = (int)(scale * (double)(i - hMin));
            if (index >= this.nBins) {
                index = this.nBins - 1;
            }
            int n = index;
            this.longHistogram[n] = this.longHistogram[n] + count;
        }
        this.copyHistogram(this.nBins);
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.longPixelCount;
        this.dmode = this.getMode(null);
        this.calculateStdDev(this.longPixelCount, sum, sum2);
    }

    double getMode(Calibration cal) {
        long longMaxCount = 0L;
        for (int i = 0; i < this.nBins; ++i) {
            long count = this.longHistogram[i];
            if (count <= longMaxCount) continue;
            longMaxCount = count;
            this.mode = i;
        }
        this.maxCount = longMaxCount <= Integer.MAX_VALUE ? (int)longMaxCount : Integer.MAX_VALUE;
        double tmode = this.histMin + (double)this.mode * this.binSize;
        if (cal != null) {
            tmode = cal.getCValue(tmode);
        }
        return tmode;
    }

    double getMedian(long[] hist, int first, int last, Calibration cal) {
        if (this.pixelCount == 0 || first < 0 || last > hist.length) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = first - 1;
        double halfCount = (double)this.pixelCount / 2.0;
        while ((sum += (double)hist[++i]) <= halfCount && i < last) {
        }
        return cal != null ? cal.getCValue(i) : (double)i;
    }
}

