/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextField;

public class ScaleBar
implements PlugIn {
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static final String[] colors = new String[]{"White", "Black", "Light Gray", "Gray", "Dark Gray", "Red", "Green", "Blue", "Yellow"};
    static final String[] bcolors = new String[]{"None", "Black", "White", "Dark Gray", "Gray", "Light Gray", "Yellow", "Blue", "Green", "Red"};
    static final String[] checkboxLabels = new String[]{"Horizontal", "Vertical", "Bold Text", "Hide Text", "Serif Font", "Overlay"};
    static final String SCALE_BAR = "|SB|";
    private static final ScaleBarConfiguration sConfig = new ScaleBarConfiguration();
    private ScaleBarConfiguration config = new ScaleBarConfiguration(sConfig);
    ImagePlus imp;
    int hBarWidthInPixels;
    int vBarHeightInPixels;
    int roiX;
    int roiY;
    int roiWidth;
    int roiHeight;
    boolean userRoiExists;
    boolean[] checkboxStates = new boolean[6];
    Rectangle hBackground = new Rectangle();
    Rectangle hBar = new Rectangle();
    Rectangle hText = new Rectangle();
    Rectangle vBackground = new Rectangle();
    Rectangle vBar = new Rectangle();
    Rectangle vText = new Rectangle();

    @Override
    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.imp.getProcessor().snapshot();
        this.userRoiExists = this.parseCurrentROI();
        boolean userOKed = this.askUserConfiguration(this.userRoiExists);
        if (!userOKed) {
            this.removeScalebar();
            return;
        }
        if (!IJ.isMacro()) {
            this.persistConfiguration();
        }
        this.updateScalebar(!this.config.labelAll);
    }

    void removeScalebar() {
        this.imp.getProcessor().reset();
        this.imp.updateAndDraw();
        Overlay overlay = this.imp.getOverlay();
        if (overlay != null) {
            overlay.remove(SCALE_BAR);
            this.imp.draw();
        }
    }

    boolean parseCurrentROI() {
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return false;
        }
        Rectangle r = roi.getBounds();
        this.roiX = r.x;
        this.roiY = r.y;
        this.roiWidth = r.width;
        this.roiHeight = r.height;
        return true;
    }

    void computeDefaultBarWidth(boolean currentROIExists) {
        double pixelHeight;
        double pixelWidth;
        double mag;
        Calibration cal = this.imp.getCalibration();
        ImageWindow win = this.imp.getWindow();
        double d = mag = win != null ? win.getCanvas().getMagnification() : 1.0;
        if (mag > 1.0) {
            mag = 1.0;
        }
        if ((pixelWidth = cal.pixelWidth) == 0.0) {
            pixelWidth = 1.0;
        }
        if ((pixelHeight = cal.pixelHeight) == 0.0) {
            pixelHeight = 1.0;
        }
        double imageWidth = (double)this.imp.getWidth() * pixelWidth;
        double imageHeight = (double)this.imp.getHeight() * pixelHeight;
        if (currentROIExists && this.roiX >= 0 && this.roiWidth > 10) {
            this.config.hBarWidth = (double)this.roiWidth * pixelWidth;
        } else if (this.config.hBarWidth <= 0.0 || this.config.hBarWidth > 0.67 * imageWidth) {
            this.config.hBarWidth = 80.0 * pixelWidth / mag;
            if (this.config.hBarWidth > 0.67 * imageWidth) {
                this.config.hBarWidth = 0.67 * imageWidth;
            }
            if (this.config.hBarWidth > 5.0) {
                this.config.hBarWidth = (int)this.config.hBarWidth;
            }
        }
        if (currentROIExists && this.roiY >= 0 && this.roiHeight > 10) {
            this.config.vBarHeight = (double)this.roiHeight * pixelHeight;
        } else if (this.config.vBarHeight <= 0.0 || this.config.vBarHeight > 0.67 * imageHeight) {
            this.config.vBarHeight = 80.0 * pixelHeight / mag;
            if (this.config.vBarHeight > 0.67 * imageHeight) {
                this.config.vBarHeight = 0.67 * imageHeight;
            }
            if (this.config.vBarHeight > 5.0) {
                this.config.vBarHeight = (int)this.config.vBarHeight;
            }
        }
    }

    boolean askUserConfiguration(boolean currentROIExists) {
        if (currentROIExists) {
            this.config.location = locations[4];
        }
        if (IJ.isMacro()) {
            this.config.updateFrom(new ScaleBarConfiguration());
        }
        if (this.config.hBarWidth <= 0.0 || this.config.vBarHeight <= 0.0 || currentROIExists) {
            this.computeDefaultBarWidth(currentROIExists);
        }
        this.updateScalebar(true);
        boolean multipleSlices = this.imp.getStackSize() > 1;
        BarDialog dialog = new BarDialog(this.getHUnit(), this.getVUnit(), this.config.hDigits, this.config.vDigits, multipleSlices);
        BarDialogListener dialogListener = new BarDialogListener(multipleSlices);
        dialog.addDialogListener(dialogListener);
        dialog.showDialog();
        return dialog.wasOKed();
    }

    void persistConfiguration() {
        sConfig.updateFrom(this.config);
    }

    String getHUnit() {
        String hUnits = this.imp.getCalibration().getXUnits();
        if (hUnits.equals("microns")) {
            hUnits = "\u00b5m";
        }
        return hUnits;
    }

    String getVUnit() {
        String vUnits = this.imp.getCalibration().getYUnits();
        if (vUnits.equals("microns")) {
            vUnits = "\u00b5m";
        }
        return vUnits;
    }

    Overlay createScaleBarOverlay() throws MissingRoiException {
        Overlay overlay = new Overlay();
        Color color = this.getColor();
        Color bcolor = this.getBColor();
        int fontType = this.config.boldText ? 1 : 0;
        String face = this.config.serifFont ? "Serif" : "SanSerif";
        Font font = new Font(face, fontType, this.config.fontSize);
        ImageProcessor ip = this.imp.getProcessor();
        ip.setFont(font);
        this.setElementsPositions(ip);
        if (bcolor != null) {
            if (this.config.showHorizontal) {
                Roi hBackgroundRoi = new Roi(this.hBackground.x, this.hBackground.y, this.hBackground.width, this.hBackground.height);
                hBackgroundRoi.setFillColor(bcolor);
                overlay.add(hBackgroundRoi, SCALE_BAR);
            }
            if (this.config.showVertical) {
                Roi vBackgroundRoi = new Roi(this.vBackground.x, this.vBackground.y, this.vBackground.width, this.vBackground.height);
                vBackgroundRoi.setFillColor(bcolor);
                overlay.add(vBackgroundRoi, SCALE_BAR);
            }
        }
        if (this.config.showHorizontal) {
            Roi hBarRoi = new Roi(this.hBar.x, this.hBar.y, this.hBar.width, this.hBar.height);
            hBarRoi.setFillColor(color);
            overlay.add(hBarRoi, SCALE_BAR);
        }
        if (this.config.showVertical) {
            Roi vBarRoi = new Roi(this.vBar.x, this.vBar.y, this.vBar.width, this.vBar.height);
            vBarRoi.setFillColor(color);
            overlay.add(vBarRoi, SCALE_BAR);
        }
        if (!this.config.hideText) {
            if (this.config.showHorizontal) {
                TextRoi hTextRoi = new TextRoi(this.hText.x, this.hText.y, this.getHLabel(), font);
                hTextRoi.setStrokeColor(color);
                overlay.add(hTextRoi, SCALE_BAR);
            }
            if (this.config.showVertical) {
                TextRoi vTextRoi = new TextRoi(this.vText.x, this.vText.y + this.vText.height, this.getVLabel(), font);
                vTextRoi.setStrokeColor(color);
                vTextRoi.setAngle(90.0);
                overlay.add(vTextRoi, SCALE_BAR);
            }
        }
        return overlay;
    }

    String getHLabel() {
        return IJ.d2s(this.config.hBarWidth, this.config.hDigits) + " " + this.getHUnit();
    }

    String getVLabel() {
        return IJ.d2s(this.config.vBarHeight, this.config.vDigits) + " " + this.getVUnit();
    }

    int getHBoxWidthInPixels() {
        this.updateFont();
        ImageProcessor ip = this.imp.getProcessor();
        int hLabelWidth = this.config.hideText ? 0 : ip.getStringWidth(this.getHLabel());
        int hBoxWidth = Math.max(this.hBarWidthInPixels, hLabelWidth);
        return this.config.showHorizontal ? hBoxWidth : 0;
    }

    int getHBoxHeightInPixels() {
        int hLabelHeight = this.config.hideText ? 0 : this.config.fontSize;
        int hBoxHeight = this.config.barThicknessInPixels + (int)((double)hLabelHeight * 1.25);
        return this.config.showHorizontal ? hBoxHeight : 0;
    }

    int getVBoxHeightInPixels() {
        this.updateFont();
        ImageProcessor ip = this.imp.getProcessor();
        int vLabelHeight = this.config.hideText ? 0 : ip.getStringWidth(this.getVLabel());
        int vBoxHeight = Math.max(this.vBarHeightInPixels, vLabelHeight);
        return this.config.showVertical ? vBoxHeight : 0;
    }

    int getVBoxWidthInPixels() {
        int vLabelWidth = this.config.hideText ? 0 : this.config.fontSize;
        int vBoxWidth = this.config.barThicknessInPixels + (int)((double)vLabelWidth * 1.25);
        return this.config.showVertical ? vBoxWidth : 0;
    }

    int getOuterMarginSizeInPixels() {
        int imageWidth = this.imp.getWidth();
        int imageHeight = this.imp.getHeight();
        return (imageWidth + imageHeight) / 100;
    }

    int getInnerMarginSizeInPixels() {
        int maxWidth = Math.max(this.getHBoxWidthInPixels(), this.getVBoxHeightInPixels());
        int margin = Math.max(maxWidth / 20, 2);
        return this.config.bcolor.equals("None") ? 0 : margin;
    }

    void updateFont() {
        int fontType = this.config.boldText ? 1 : 0;
        String font = this.config.serifFont ? "Serif" : "SanSerif";
        ImageProcessor ip = this.imp.getProcessor();
        ip.setFont(new Font(font, fontType, this.config.fontSize));
        ip.setAntialiasedText(true);
    }

    void setBackgroundBoxesPositions(ImageProcessor ip) throws MissingRoiException {
        Calibration cal = this.imp.getCalibration();
        this.hBarWidthInPixels = (int)Math.round(this.config.hBarWidth / cal.pixelWidth);
        this.vBarHeightInPixels = (int)Math.round(this.config.vBarHeight / cal.pixelHeight);
        boolean hTextTop = this.config.showVertical && (this.config.location.equals(locations[3]) || this.config.location.equals(locations[0]));
        int imageWidth = this.imp.getWidth();
        int imageHeight = this.imp.getHeight();
        int hBoxWidth = this.getHBoxWidthInPixels();
        int hBoxHeight = this.getHBoxHeightInPixels();
        int vBoxWidth = this.getVBoxWidthInPixels();
        int vBoxHeight = this.getVBoxHeightInPixels();
        int outerMargin = this.getOuterMarginSizeInPixels();
        int innerMargin = this.getInnerMarginSizeInPixels();
        this.hBackground.width = innerMargin + hBoxWidth + innerMargin;
        this.hBackground.height = innerMargin + hBoxHeight + innerMargin;
        this.vBackground.width = innerMargin + vBoxWidth + innerMargin;
        this.vBackground.height = innerMargin + vBoxHeight + innerMargin;
        if (this.config.location.equals(locations[0])) {
            this.hBackground.x = imageWidth - outerMargin - innerMargin - vBoxWidth + (this.config.showVertical ? this.config.barThicknessInPixels : 0) - hBoxWidth - innerMargin;
            this.hBackground.y = outerMargin;
            this.vBackground.x = imageWidth - outerMargin - innerMargin - vBoxWidth - innerMargin;
            this.vBackground.y = outerMargin + (hTextTop ? hBoxHeight - this.config.barThicknessInPixels : 0);
            this.hBackground.width = this.hBackground.width + (this.config.showVertical ? vBoxWidth - this.config.barThicknessInPixels : 0);
        } else if (this.config.location.equals(locations[1])) {
            this.hBackground.x = imageWidth - outerMargin - innerMargin - vBoxWidth - hBoxWidth + (this.config.showVertical ? this.config.barThicknessInPixels : 0) - innerMargin;
            this.hBackground.y = imageHeight - outerMargin - innerMargin - hBoxHeight - innerMargin;
            this.vBackground.x = imageWidth - outerMargin - innerMargin - vBoxWidth - innerMargin;
            this.vBackground.y = imageHeight - outerMargin - innerMargin - hBoxHeight + (this.config.showHorizontal ? this.config.barThicknessInPixels : 0) - vBoxHeight - innerMargin;
            this.vBackground.height = this.vBackground.height + (this.config.showHorizontal ? hBoxHeight - this.config.barThicknessInPixels : 0);
        } else if (this.config.location.equals(locations[3])) {
            this.hBackground.x = outerMargin + (this.config.showVertical ? this.vBackground.width - 2 * innerMargin - this.config.barThicknessInPixels : 0);
            this.hBackground.y = outerMargin;
            this.vBackground.x = outerMargin;
            this.vBackground.y = outerMargin + (hTextTop ? hBoxHeight - this.config.barThicknessInPixels : 0);
            this.hBackground.width = this.hBackground.width + (this.config.showVertical ? vBoxWidth - this.config.barThicknessInPixels : 0);
            this.hBackground.x = this.hBackground.x - (this.config.showVertical ? vBoxWidth - this.config.barThicknessInPixels : 0);
        } else if (this.config.location.equals(locations[2])) {
            this.hBackground.x = outerMargin + (this.config.showVertical ? this.vBackground.width - 2 * innerMargin - this.config.barThicknessInPixels : 0);
            this.hBackground.y = imageHeight - outerMargin - innerMargin - hBoxHeight - innerMargin;
            this.vBackground.x = outerMargin;
            this.vBackground.y = imageHeight - outerMargin - innerMargin - hBoxHeight + (this.config.showHorizontal ? this.config.barThicknessInPixels : 0) - vBoxHeight - innerMargin;
            this.vBackground.height = this.vBackground.height + (this.config.showHorizontal ? hBoxHeight - this.config.barThicknessInPixels : 0);
        } else {
            if (!this.userRoiExists) {
                throw new MissingRoiException();
            }
            this.hBackground.x = this.roiX;
            this.hBackground.y = this.roiY;
            this.vBackground.x = this.roiX;
            this.vBackground.y = this.roiY;
        }
    }

    void setElementsPositions(ImageProcessor ip) throws MissingRoiException {
        this.setBackgroundBoxesPositions(ip);
        int hBoxWidth = this.getHBoxWidthInPixels();
        int hBoxHeight = this.getHBoxHeightInPixels();
        int vBoxWidth = this.getVBoxWidthInPixels();
        int vBoxHeight = this.getVBoxHeightInPixels();
        int innerMargin = this.getInnerMarginSizeInPixels();
        boolean right = this.config.location.equals(locations[1]) || this.config.location.equals(locations[0]);
        boolean upper = this.config.location.equals(locations[0]) || this.config.location.equals(locations[3]);
        boolean hTextTop = this.config.showVertical && upper;
        this.hBar.x = this.hBackground.x + innerMargin + (hBoxWidth - this.hBarWidthInPixels) / 2 + (this.config.showVertical && !right && upper ? vBoxWidth - this.config.barThicknessInPixels : 0);
        this.hBar.y = this.hBackground.y + innerMargin + (hTextTop ? hBoxHeight - this.config.barThicknessInPixels : 0);
        this.hBar.width = this.hBarWidthInPixels;
        this.hBar.height = this.config.barThicknessInPixels;
        this.hText.height = this.config.hideText ? 0 : this.config.fontSize;
        this.hText.width = this.config.hideText ? 0 : ip.getStringWidth(this.getHLabel());
        this.hText.x = this.hBackground.x + innerMargin + (hBoxWidth - this.hText.width) / 2 + (this.config.showVertical && !right && upper ? vBoxWidth - this.config.barThicknessInPixels : 0);
        this.hText.y = hTextTop ? this.hBackground.y + innerMargin - (int)Math.round((double)this.config.fontSize * 0.25) : this.hBar.y + this.hBar.height;
        this.vBar.width = this.config.barThicknessInPixels;
        this.vBar.height = this.vBarHeightInPixels;
        this.vBar.x = this.vBackground.x + (right ? innerMargin : this.vBackground.width - this.config.barThicknessInPixels - innerMargin);
        this.vBar.y = this.vBackground.y + innerMargin + (vBoxHeight - this.vBar.height) / 2;
        this.vText.height = this.config.hideText ? 0 : ip.getStringWidth(this.getVLabel());
        this.vText.width = this.config.hideText ? 0 : this.config.fontSize;
        this.vText.x = right ? this.vBar.x + this.vBar.width : this.vBar.x - vBoxWidth + this.config.barThicknessInPixels - (int)Math.round((double)this.config.fontSize * 0.25);
        this.vText.y = this.vBackground.y + innerMargin + (vBoxHeight - this.vText.height) / 2;
    }

    Color getColor() {
        Color c = Color.black;
        if (this.config.color.equals(colors[0])) {
            c = Color.white;
        } else if (this.config.color.equals(colors[2])) {
            c = Color.lightGray;
        } else if (this.config.color.equals(colors[3])) {
            c = Color.gray;
        } else if (this.config.color.equals(colors[4])) {
            c = Color.darkGray;
        } else if (this.config.color.equals(colors[5])) {
            c = Color.red;
        } else if (this.config.color.equals(colors[6])) {
            c = Color.green;
        } else if (this.config.color.equals(colors[7])) {
            c = Color.blue;
        } else if (this.config.color.equals(colors[8])) {
            c = Color.yellow;
        }
        return c;
    }

    Color getBColor() {
        if (this.config.bcolor == null || this.config.bcolor.equals(bcolors[0])) {
            return null;
        }
        Color bc = Color.white;
        if (this.config.bcolor.equals(bcolors[1])) {
            bc = Color.black;
        } else if (this.config.bcolor.equals(bcolors[3])) {
            bc = Color.darkGray;
        } else if (this.config.bcolor.equals(bcolors[4])) {
            bc = Color.gray;
        } else if (this.config.bcolor.equals(bcolors[5])) {
            bc = Color.lightGray;
        } else if (this.config.bcolor.equals(bcolors[6])) {
            bc = Color.yellow;
        } else if (this.config.bcolor.equals(bcolors[7])) {
            bc = Color.blue;
        } else if (this.config.bcolor.equals(bcolors[8])) {
            bc = Color.green;
        } else if (this.config.bcolor.equals(bcolors[9])) {
            bc = Color.red;
        }
        return bc;
    }

    void updateScalebar(boolean previewOnly) {
        Overlay scaleBarOverlay;
        this.removeScalebar();
        try {
            scaleBarOverlay = this.createScaleBarOverlay();
        }
        catch (MissingRoiException e) {
            return;
        }
        Overlay impOverlay = this.imp.getOverlay();
        if (impOverlay == null) {
            impOverlay = new Overlay();
        }
        if (this.config.useOverlay) {
            for (Roi roi : scaleBarOverlay) {
                impOverlay.add(roi);
            }
            this.imp.setOverlay(impOverlay);
        } else if (previewOnly) {
            ImageProcessor ip = this.imp.getProcessor();
            this.drawOverlayOnProcessor(scaleBarOverlay, ip);
            this.imp.updateAndDraw();
        } else {
            ImageStack stack = this.imp.getStack();
            for (int i = 1; i <= stack.size(); ++i) {
                ImageProcessor ip = stack.getProcessor(i);
                this.drawOverlayOnProcessor(scaleBarOverlay, ip);
                this.imp.updateAndDraw();
            }
            this.imp.setStack(stack);
        }
    }

    void drawOverlayOnProcessor(Overlay overlay, ImageProcessor processor) {
        if (processor.getBitDepth() == 8 || processor.getBitDepth() == 24) {
            processor.drawOverlay(overlay);
            return;
        }
        ByteProcessor ip = new ByteProcessor(this.imp.getWidth(), this.imp.getHeight());
        ip.setCalibrationTable(processor.getCalibrationTable());
        LUT lut = ip.getLut();
        for (Roi roi : overlay) {
            Color strokeColor;
            Color fillColor = roi.getFillColor();
            if (fillColor != null) {
                int i = processor.getBestIndex(fillColor);
                roi.setFillColor(new Color(lut.getRed(i), lut.getGreen(i), lut.getBlue(i)));
                if (roi.getFillColor().equals(Color.BLACK)) {
                    roi.setFillColor(new Color(1, 1, 1));
                }
            }
            if ((strokeColor = roi.getStrokeColor()) == null) continue;
            int i = processor.getBestIndex(strokeColor);
            roi.setStrokeColor(new Color(lut.getRed(i), lut.getGreen(i), lut.getBlue(i)));
            if (!roi.getStrokeColor().equals(Color.BLACK)) continue;
            roi.setStrokeColor(new Color(1, 1, 1));
        }
        ip.drawOverlay(overlay);
        for (int y = 0; y < ip.getHeight(); ++y) {
            for (int x = 0; x < ip.getWidth(); ++x) {
                int p = ((ImageProcessor)ip).get(x, y);
                if (p <= 0) continue;
                p = (int)Math.round((double)p * ((processor.getMax() - processor.getMin()) / 255.0) + (double)((float)processor.getMin()));
                if (processor.getBitDepth() == 32) {
                    p = Float.floatToIntBits(p);
                }
                processor.putPixel(x, y, p);
            }
        }
    }

    static class ScaleBarConfiguration {
        private static int defaultBarHeight = 4;
        boolean showHorizontal;
        boolean showVertical;
        double hBarWidth;
        double vBarHeight;
        int hDigits;
        int vDigits;
        int barThicknessInPixels;
        String location;
        String color;
        String bcolor;
        boolean boldText;
        boolean hideText;
        boolean serifFont;
        boolean useOverlay;
        int fontSize;
        boolean labelAll;

        ScaleBarConfiguration() {
            this.showHorizontal = true;
            this.showVertical = false;
            this.hBarWidth = -1.0;
            this.vBarHeight = -1.0;
            this.barThicknessInPixels = defaultBarHeight;
            this.location = locations[1];
            this.color = colors[0];
            this.bcolor = bcolors[0];
            this.boldText = true;
            this.hideText = false;
            this.serifFont = false;
            this.useOverlay = true;
            this.fontSize = 14;
            this.labelAll = false;
        }

        ScaleBarConfiguration(ScaleBarConfiguration model) {
            this.updateFrom(model);
        }

        void updateFrom(ScaleBarConfiguration model) {
            this.showHorizontal = model.showHorizontal;
            this.showVertical = model.showVertical;
            this.hBarWidth = model.hBarWidth;
            this.vBarHeight = model.vBarHeight;
            this.hDigits = model.hDigits;
            this.vDigits = model.vDigits;
            this.barThicknessInPixels = model.barThicknessInPixels;
            this.location = locations[1];
            this.color = model.color;
            this.bcolor = model.bcolor;
            this.boldText = model.boldText;
            this.serifFont = model.serifFont;
            this.hideText = model.hideText;
            this.useOverlay = model.useOverlay;
            this.fontSize = model.fontSize;
            this.labelAll = model.labelAll;
        }
    }

    class MissingRoiException
    extends Exception {
        MissingRoiException() {
            super("Scalebar location is set to AT_SELECTION but there is no selection on the image.");
        }
    }

    class BarDialogListener
    implements DialogListener {
        boolean multipleSlices;

        public BarDialogListener(boolean multipleSlices) {
            this.multipleSlices = multipleSlices;
        }

        @Override
        public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
            ((ScaleBar)ScaleBar.this).config.hBarWidth = gd.getNextNumber();
            ((ScaleBar)ScaleBar.this).config.vBarHeight = gd.getNextNumber();
            ((ScaleBar)ScaleBar.this).config.barThicknessInPixels = (int)gd.getNextNumber();
            ((ScaleBar)ScaleBar.this).config.fontSize = (int)gd.getNextNumber();
            ((ScaleBar)ScaleBar.this).config.color = gd.getNextChoice();
            ((ScaleBar)ScaleBar.this).config.bcolor = gd.getNextChoice();
            ((ScaleBar)ScaleBar.this).config.location = gd.getNextChoice();
            ((ScaleBar)ScaleBar.this).config.showHorizontal = gd.getNextBoolean();
            ((ScaleBar)ScaleBar.this).config.showVertical = gd.getNextBoolean();
            ((ScaleBar)ScaleBar.this).config.boldText = gd.getNextBoolean();
            ((ScaleBar)ScaleBar.this).config.hideText = gd.getNextBoolean();
            ((ScaleBar)ScaleBar.this).config.serifFont = gd.getNextBoolean();
            ((ScaleBar)ScaleBar.this).config.useOverlay = gd.getNextBoolean();
            if (this.multipleSlices) {
                ((ScaleBar)ScaleBar.this).config.labelAll = gd.getNextBoolean();
            }
            if (!((ScaleBar)ScaleBar.this).config.showHorizontal && !((ScaleBar)ScaleBar.this).config.showVertical && IJ.isMacro()) {
                ((ScaleBar)ScaleBar.this).config.showHorizontal = true;
                ((ScaleBar)ScaleBar.this).config.barThicknessInPixels = (int)((ScaleBar)ScaleBar.this).config.vBarHeight;
                ((ScaleBar)ScaleBar.this).config.vBarHeight = 0.0;
            }
            String widthString = ((TextField)gd.getNumericFields().elementAt(0)).getText();
            boolean hasDecimalPoint = false;
            ((ScaleBar)ScaleBar.this).config.hDigits = 0;
            for (int i = 0; i < widthString.length(); ++i) {
                if (hasDecimalPoint) {
                    ++((ScaleBar)ScaleBar.this).config.hDigits;
                }
                if (widthString.charAt(i) != '.') continue;
                hasDecimalPoint = true;
            }
            String heightString = ((TextField)gd.getNumericFields().elementAt(1)).getText();
            hasDecimalPoint = false;
            ((ScaleBar)ScaleBar.this).config.vDigits = 0;
            for (int i = 0; i < heightString.length(); ++i) {
                if (hasDecimalPoint) {
                    ++((ScaleBar)ScaleBar.this).config.vDigits;
                }
                if (heightString.charAt(i) != '.') continue;
                hasDecimalPoint = true;
            }
            ScaleBar.this.updateScalebar(true);
            return true;
        }
    }

    class BarDialog
    extends GenericDialog {
        BarDialog(String hUnits, String vUnits, int hDigits, int vDigits, boolean multipleSlices) {
            super("Scale Bar");
            this.addNumericField("Width in " + hUnits + ": ", ((ScaleBar)ScaleBar.this).config.hBarWidth, hDigits);
            this.addNumericField("Height in " + vUnits + ": ", ((ScaleBar)ScaleBar.this).config.vBarHeight, vDigits);
            this.addNumericField("Thickness in pixels: ", ((ScaleBar)ScaleBar.this).config.barThicknessInPixels, 0);
            this.addNumericField("Font size: ", ((ScaleBar)ScaleBar.this).config.fontSize, 0);
            this.addChoice("Color: ", colors, ((ScaleBar)ScaleBar.this).config.color);
            this.addChoice("Background: ", bcolors, ((ScaleBar)ScaleBar.this).config.bcolor);
            this.addChoice("Location: ", locations, ((ScaleBar)ScaleBar.this).config.location);
            ScaleBar.this.checkboxStates[0] = ((ScaleBar)ScaleBar.this).config.showHorizontal;
            ScaleBar.this.checkboxStates[1] = ((ScaleBar)ScaleBar.this).config.showVertical;
            ScaleBar.this.checkboxStates[2] = ((ScaleBar)ScaleBar.this).config.boldText;
            ScaleBar.this.checkboxStates[3] = ((ScaleBar)ScaleBar.this).config.hideText;
            ScaleBar.this.checkboxStates[4] = ((ScaleBar)ScaleBar.this).config.serifFont;
            ScaleBar.this.checkboxStates[5] = ((ScaleBar)ScaleBar.this).config.useOverlay;
            this.setInsets(10, 25, 0);
            this.addCheckboxGroup(3, 2, checkboxLabels, ScaleBar.this.checkboxStates);
            if (multipleSlices) {
                this.setInsets(0, 25, 0);
                this.addCheckbox("Label all slices", ((ScaleBar)ScaleBar.this).config.labelAll);
            }
        }
    }
}

