/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.io.File;
import java.util.Locale;
import java.util.Properties;

public class StackWriter
implements PlugIn {
    private static String[] choices = new String[]{"BMP", "FITS", "GIF", "JPEG", "PGM", "PNG", "Raw", "Text", "TIFF", "ZIP"};
    private static String staticFileType = "TIFF";
    private String fileType = "TIFF";
    private int ndigits = 4;
    private boolean useLabels;
    private boolean firstTime = true;
    private int startAt;
    private boolean hyperstack;
    private int[] dim;

    @Override
    public void run(String arg) {
        boolean isOverlay;
        int maxImages;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp != null && imp.getStackSize() < 2 && !IJ.isMacro()) {
            IJ.error("Stack Writer", "This command requires a stack.");
            return;
        }
        int stackSize = imp.getStackSize();
        String name = imp.getTitle();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        this.hyperstack = imp.isHyperStack();
        LUT[] luts = null;
        int lutIndex = 0;
        int nChannels = imp.getNChannels();
        if (this.hyperstack) {
            this.dim = imp.getDimensions();
            if (imp.isComposite()) {
                luts = ((CompositeImage)imp).getLuts();
            }
            if (this.firstTime && this.ndigits == 4) {
                this.ndigits = 3;
                this.firstTime = false;
            }
        }
        GenericDialog gd = new GenericDialog("Save Image Sequence");
        if (!IJ.isMacro()) {
            this.fileType = staticFileType;
        }
        gd.addChoice("Format:", choices, this.fileType);
        gd.addStringField("Name:", name, 12);
        if (!this.hyperstack) {
            gd.addNumericField("Start At:", this.startAt, 0);
        }
        gd.addNumericField("Digits (1-8):", this.ndigits, 0);
        if (!this.hyperstack) {
            gd.addCheckbox("Use slice labels as file names", this.useLabels);
        }
        gd.setSmartRecording(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.fileType = gd.getNextChoice();
        if (!IJ.isMacro()) {
            staticFileType = this.fileType;
        }
        name = gd.getNextString();
        if (!this.hyperstack) {
            this.startAt = (int)gd.getNextNumber();
        }
        if (this.startAt < 0) {
            this.startAt = 0;
        }
        this.ndigits = (int)gd.getNextNumber();
        this.useLabels = !this.hyperstack ? gd.getNextBoolean() : false;
        int number = 0;
        if (this.ndigits < 1) {
            this.ndigits = 1;
        }
        if (this.ndigits > 8) {
            this.ndigits = 8;
        }
        if (stackSize > (maxImages = (int)Math.pow(10.0, this.ndigits)) && !this.useLabels && !this.hyperstack) {
            IJ.error("Stack Writer", "More than " + this.ndigits + " digits are required to generate \nunique file names for " + stackSize + " images.");
            return;
        }
        String format = this.fileType.toLowerCase(Locale.US);
        if (format.equals("fits") && !FileSaver.okForFits(imp)) {
            return;
        }
        if (format.equals("text")) {
            format = "text image";
        }
        String extension = "." + format;
        if (format.equals("tiff")) {
            extension = ".tif";
        } else if (format.equals("text image")) {
            extension = ".txt";
        }
        String title = "Save Image Sequence";
        String macroOptions = Macro.getOptions();
        String directory = null;
        if (macroOptions != null && (directory = Macro.getValue(macroOptions, title, null)) != null) {
            File f = new File(directory);
            boolean exists = f.exists();
            if (directory.indexOf(".") == -1 && !exists) {
                Interpreter interp;
                String directory2;
                if (directory.startsWith("&")) {
                    directory = directory.substring(1);
                }
                String string = directory2 = (interp = Interpreter.getInstance()) != null ? interp.getStringVariable(directory) : null;
                if (directory2 != null) {
                    directory = directory2;
                }
            }
            if (!f.isDirectory() && (exists || directory.lastIndexOf(".") > directory.length() - 5)) {
                directory = f.getParent();
            }
            if (!directory.endsWith(File.separator) && !directory.endsWith("/")) {
                directory = directory + "/";
            }
        }
        if (directory == null) {
            if (Prefs.useFileChooser && !IJ.isMacOSX()) {
                String digits = this.getDigits(number);
                SaveDialog sd = new SaveDialog(title, name + digits + extension, extension);
                String name2 = sd.getFileName();
                if (name2 == null) {
                    return;
                }
                directory = sd.getDirectory();
            } else {
                directory = IJ.getDirectory(title);
            }
        }
        if (directory == null) {
            return;
        }
        Overlay overlay = imp.getOverlay();
        boolean bl = isOverlay = overlay != null && !imp.getHideOverlay();
        if (!format.equals("jpeg") && !format.equals("png")) {
            isOverlay = false;
        }
        ImageStack stack = imp.getStack();
        ImagePlus imp2 = new ImagePlus();
        imp2.setTitle(imp.getTitle());
        Calibration cal = imp.getCalibration();
        int nSlices = stack.getSize();
        String label = null;
        imp.lock();
        for (int i = 1; i <= nSlices; ++i) {
            File f;
            IJ.showStatus("writing: " + i + "/" + nSlices);
            IJ.showProgress(i, nSlices);
            ImageProcessor ip = stack.getProcessor(i);
            if (isOverlay) {
                imp.setSliceWithoutUpdate(i);
                ip = imp.flatten().getProcessor();
            } else if (luts != null && nChannels > 1 && this.hyperstack) {
                ip.setColorModel(luts[lutIndex++]);
                if (lutIndex >= luts.length) {
                    lutIndex = 0;
                }
            }
            imp2.setProcessor(null, ip);
            String label2 = stack.getSliceLabel(i);
            if (label2 != null && label2.indexOf("\n") != -1) {
                imp2.setProperty("Info", label2);
            } else {
                Properties props = imp2.getProperties();
                if (props != null) {
                    props.remove("Info");
                }
            }
            imp2.setCalibration(cal);
            String digits = this.getDigits(number++);
            if (this.useLabels) {
                label = stack.getShortSliceLabel(i);
                if (label != null && label.equals("")) {
                    label = null;
                }
                if (label != null) {
                    label = label.replaceAll("/", "-");
                }
            }
            String path = label == null ? directory + name + digits + extension : directory + label + extension;
            if (i == 1 && (f = new File(path)).exists() && !IJ.isMacro() && !IJ.showMessageWithCancel("Overwrite files?", "One or more files will be overwritten if you click \"OK\".\n \n" + path)) {
                imp.unlock();
                IJ.showStatus("");
                IJ.showProgress(1.0);
                return;
            }
            if (Recorder.record) {
                Recorder.disablePathRecording();
            }
            imp2.setOverlay(null);
            if (overlay != null && format.equals("tiff")) {
                Overlay overlay2 = overlay.duplicate();
                overlay2.crop(i, i);
                if (overlay2.size() > 0) {
                    for (int j = 0; j < overlay2.size(); ++j) {
                        Roi roi = overlay2.get(j);
                        int pos = roi.getPosition();
                        if (pos != 1) continue;
                        roi.setPosition(i);
                    }
                    imp2.setOverlay(overlay2);
                }
            }
            IJ.saveAs(imp2, format, path);
        }
        imp.unlock();
        if (isOverlay) {
            imp.setSlice(1);
        }
        IJ.showStatus("");
    }

    String getDigits(int n) {
        if (this.hyperstack) {
            int c = n % this.dim[2] + 1;
            int z = n / this.dim[2] % this.dim[3] + 1;
            int t = n / (this.dim[2] * this.dim[3]) % this.dim[4] + 1;
            String cs = "";
            String zs = "";
            String ts = "";
            if (this.dim[2] > 1) {
                cs = "00000000" + c;
                cs = "_c" + cs.substring(cs.length() - this.ndigits);
            }
            if (this.dim[3] > 1) {
                zs = "00000000" + z;
                zs = "_z" + zs.substring(zs.length() - this.ndigits);
            }
            if (this.dim[4] > 1) {
                ts = "00000000" + t;
                ts = "_t" + ts.substring(ts.length() - this.ndigits);
            }
            return ts + zs + cs;
        }
        String digits = "00000000" + (this.startAt + n);
        return digits.substring(digits.length() - this.ndigits);
    }
}

