/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.RoiEnlarger;
import ij.plugin.RoiRotator;
import ij.plugin.filter.EDM;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.LineWidthAdjuster;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Selection
implements PlugIn,
Measurements {
    private ImagePlus imp;
    private float[] kernel = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private float[] kernel3 = new float[]{1.0f, 1.0f, 1.0f};
    private static int bandSize = 15;
    private static Color linec;
    private static Color fillc;
    private static int lineWidth;
    private static boolean smooth;
    private static boolean adjust;

    @Override
    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (arg.equals("add")) {
            this.addToRoiManager(this.imp);
            return;
        }
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("all")) {
            this.imp.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else if (arg.equals("none")) {
            this.imp.deleteRoi();
        } else if (arg.equals("restore")) {
            this.imp.restoreRoi();
        } else if (arg.equals("spline")) {
            this.fitSpline();
        } else if (arg.equals("interpolate")) {
            this.interpolate();
        } else if (arg.equals("circle")) {
            this.fitCircle(this.imp);
        } else if (arg.equals("ellipse")) {
            this.createEllipse(this.imp);
        } else if (arg.equals("hull")) {
            this.convexHull(this.imp);
        } else if (arg.equals("mask")) {
            this.createMask(this.imp);
        } else if (arg.equals("from")) {
            this.createSelectionFromMask(this.imp);
        } else if (arg.equals("inverse")) {
            this.invert(this.imp);
        } else if (arg.equals("toarea")) {
            this.lineToArea(this.imp);
        } else if (arg.equals("toline")) {
            this.areaToLine(this.imp);
        } else if (arg.equals("properties")) {
            this.setProperties("Properties ", this.imp.getRoi());
            this.imp.draw();
        } else if (arg.equals("band")) {
            this.makeBand(this.imp);
        } else if (arg.equals("tobox")) {
            this.toBoundingBox(this.imp);
        } else if (arg.equals("rotate")) {
            this.rotate(this.imp);
        } else if (arg.equals("enlarge")) {
            this.enlarge(this.imp);
        }
    }

    private void rotate(ImagePlus imp) {
        String options;
        Roi roi = imp.getRoi();
        if (IJ.macroRunning() && (options = Macro.getOptions()) != null && (options.indexOf("grid=") != -1 || options.indexOf("interpolat") != -1)) {
            IJ.run("Rotate... ", options);
            return;
        }
        new RoiRotator().run("");
    }

    private void enlarge(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi != null) {
            Undo.setup(8, imp);
            roi = (Roi)roi.clone();
            new RoiEnlarger().run("");
        } else {
            this.noRoi("Enlarge");
        }
    }

    void fitCircle(ImagePlus imp) {
        double CenterY;
        double DET;
        double CenterX;
        double radius;
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi("Fit Circle");
            return;
        }
        if (roi.isArea()) {
            Undo.setup(8, imp);
            ImageProcessor ip = imp.getProcessor();
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, 33, null);
            double r = Math.sqrt((double)stats.pixelCount / Math.PI);
            imp.deleteRoi();
            int d = (int)Math.round(2.0 * r);
            OvalRoi roi2 = new OvalRoi((int)Math.round(stats.xCentroid - r), (int)Math.round(stats.yCentroid - r), d, d);
            Selection.transferProperties(roi, roi2);
            imp.setRoi(roi2);
            return;
        }
        Polygon poly = roi.getPolygon();
        int n = poly.npoints;
        int[] x = poly.xpoints;
        int[] y = poly.ypoints;
        if (n < 3) {
            IJ.error("Fit Circle", "At least 3 points are required to fit a circle.");
            return;
        }
        double sumx = 0.0;
        double sumy = 0.0;
        for (int i = 0; i < n; ++i) {
            sumx += (double)poly.xpoints[i];
            sumy += (double)poly.ypoints[i];
        }
        double meanx = sumx / (double)n;
        double meany = sumy / (double)n;
        double[] X = new double[n];
        double[] Y = new double[n];
        double Mxx = 0.0;
        double Myy = 0.0;
        double Mxy = 0.0;
        double Mxz = 0.0;
        double Myz = 0.0;
        double Mzz = 0.0;
        for (int i = 0; i < n; ++i) {
            X[i] = (double)x[i] - meanx;
            Y[i] = (double)y[i] - meany;
            double Zi = X[i] * X[i] + Y[i] * Y[i];
            Mxy += X[i] * Y[i];
            Mxx += X[i] * X[i];
            Myy += Y[i] * Y[i];
            Mxz += X[i] * Zi;
            Myz += Y[i] * Zi;
            Mzz += Zi * Zi;
        }
        double Mz = (Mxx /= (double)n) + (Myy /= (double)n);
        double Cov_xy = Mxx * Myy - (Mxy /= (double)n) * Mxy;
        double Mxz2 = (Mxz /= (double)n) * Mxz;
        double Myz2 = (Myz /= (double)n) * Myz;
        double A2 = 4.0 * Cov_xy - 3.0 * Mz * Mz - (Mzz /= (double)n);
        double A1 = Mzz * Mz + 4.0 * Cov_xy * Mz - Mxz2 - Myz2 - Mz * Mz * Mz;
        double A0 = Mxz2 * Myy + Myz2 * Mxx - Mzz * Cov_xy - 2.0 * Mxz * Myz * Mxy + Mz * Mz * Cov_xy;
        double A22 = A2 + A2;
        double epsilon = 1.0E-12;
        double ynew = 1.0E20;
        int IterMax = 20;
        double xnew = 0.0;
        int iterations = 0;
        for (int iter = 1; iter <= IterMax; ++iter) {
            iterations = iter;
            double yold = ynew;
            ynew = A0 + xnew * (A1 + xnew * (A2 + 4.0 * xnew * xnew));
            if (Math.abs(ynew) > Math.abs(yold)) {
                if (IJ.debugMode) {
                    IJ.log("Fit Circle: wrong direction: |ynew| > |yold|");
                }
                xnew = 0.0;
                break;
            }
            double xold = xnew;
            double Dy = A1 + xnew * (A22 + 16.0 * xnew * xnew);
            if (Math.abs(((xnew = xold - ynew / Dy) - xold) / xnew) < epsilon) break;
            if (iter >= IterMax) {
                if (IJ.debugMode) {
                    IJ.log("Fit Circle: will not converge");
                }
                xnew = 0.0;
            }
            if (!(xnew < 0.0)) continue;
            if (IJ.debugMode) {
                IJ.log("Fit Circle: negative root:  x = " + xnew);
            }
            xnew = 0.0;
        }
        if (IJ.debugMode) {
            IJ.log("Fit Circle: n=" + n + ", xnew=" + IJ.d2s(xnew, 2) + ", iterations=" + iterations);
        }
        if (Double.isNaN(radius = Math.sqrt((CenterX = (Mxz * (Myy - xnew) - Myz * Mxy) / (2.0 * (DET = xnew * xnew - xnew * Mz + Cov_xy))) * CenterX + (CenterY = (Myz * (Mxx - xnew) - Mxz * Mxy) / (2.0 * DET)) * CenterY + Mz + 2.0 * xnew))) {
            IJ.error("Fit Circle", "Points are collinear.");
            return;
        }
        Undo.setup(8, imp);
        imp.deleteRoi();
        IJ.makeOval((int)Math.round((CenterX += meanx) - radius), (int)Math.round((CenterY += meany) - radius), (int)Math.round(2.0 * radius), (int)Math.round(2.0 * radius));
    }

    void fitSpline() {
        String options;
        boolean segmentedSelection;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            this.noRoi("Spline");
            return;
        }
        int type = roi.getType();
        boolean bl = segmentedSelection = type == 2 || type == 6;
        if (!segmentedSelection && type != 3 && type != 4 && type != 7) {
            IJ.error("Spline Fit", "Polygon or polyline selection required");
            return;
        }
        if (roi instanceof EllipseRoi) {
            return;
        }
        PolygonRoi p = (PolygonRoi)roi;
        Undo.setup(8, this.imp);
        if (!segmentedSelection && p.getNCoordinates() > 3) {
            p = p.subPixelResolution() ? this.trimFloatPolygon(p, p.getUncalibratedLength()) : this.trimPolygon(p, p.getUncalibratedLength());
        }
        if ((options = Macro.getOptions()) != null && options.indexOf("straighten") != -1) {
            p.fitSplineForStraightening();
        } else if (options != null && options.indexOf("remove") != -1) {
            p.removeSplineFit();
        } else {
            p.fitSpline();
        }
        this.imp.draw();
        LineWidthAdjuster.update();
    }

    void interpolate() {
        int type;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            this.noRoi("Interpolate");
            return;
        }
        if (roi.getType() == 10) {
            return;
        }
        if (IJ.isMacro() && Macro.getOptions() == null) {
            Macro.setOptions("interval=1");
        }
        GenericDialog gd = new GenericDialog("Interpolate");
        gd.addNumericField("Interval:", 1.0, 1, 4, "pixel");
        gd.addCheckbox("Smooth", IJ.isMacro() ? false : smooth);
        gd.addCheckbox("Adjust interval to match", IJ.isMacro() ? false : adjust);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double interval = gd.getNextNumber();
        smooth = gd.getNextBoolean();
        Undo.setup(8, this.imp);
        adjust = gd.getNextBoolean();
        int sign = adjust ? -1 : 1;
        FloatPolygon poly = roi.getInterpolatedPolygon((double)sign * interval, smooth);
        int t = roi.getType();
        int n = type = roi.isLine() ? 7 : 3;
        if (t == 2 && interval > 1.0) {
            type = 2;
        }
        if ((t == 0 || t == 1 || t == 3) && interval >= 8.0) {
            type = 2;
        }
        if ((t == 5 || t == 7) && interval >= 8.0) {
            type = 6;
        }
        if (t == 6 && interval >= 8.0) {
            type = 6;
        }
        ImageCanvas ic = this.imp.getCanvas();
        if (poly.npoints <= 150 && ic != null && ic.getMagnification() >= 12.0) {
            type = roi.isLine() ? 6 : 2;
        }
        PolygonRoi p = new PolygonRoi(poly, type);
        if (roi.getStroke() != null) {
            p.setStrokeWidth(roi.getStrokeWidth());
        }
        p.setStrokeColor(roi.getStrokeColor());
        p.setName(roi.getName());
        Selection.transferProperties(roi, p);
        this.imp.setRoi(p);
    }

    private static void transferProperties(Roi roi1, Roi roi2) {
        if (roi1 == null || roi2 == null) {
            return;
        }
        roi2.setStrokeColor(roi1.getStrokeColor());
        if (roi1.getStroke() != null) {
            roi2.setStroke(roi1.getStroke());
        }
        roi2.setDrawOffset(roi1.getDrawOffset());
    }

    PolygonRoi trimPolygon(PolygonRoi roi, double length) {
        int type;
        int[] x = roi.getXCoordinates();
        int[] y = roi.getYCoordinates();
        int n = roi.getNCoordinates();
        x = this.smooth(x, n);
        y = this.smooth(y, n);
        float[] curvature = this.getCurvature(x, y, n);
        Rectangle r = roi.getBounds();
        double threshold = this.rodbard(length);
        double distance = Math.sqrt((x[1] - x[0]) * (x[1] - x[0]) + (y[1] - y[0]) * (y[1] - y[0]));
        x[0] = x[0] + r.x;
        y[0] = y[0] + r.y;
        int i2 = 1;
        int x2 = 0;
        int y2 = 0;
        for (int i = 1; i < n - 1; ++i) {
            int x1 = x[i];
            int y1 = y[i];
            x2 = x[i + 1];
            y2 = y[i + 1];
            distance += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) + 1.0;
            if (!((distance += (double)(curvature[i] * 2.0f)) >= threshold)) continue;
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
            distance = 0.0;
        }
        int n2 = type = roi.getType() == 7 ? 6 : 2;
        if (type == 6 && distance > 0.0) {
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
        }
        PolygonRoi p = new PolygonRoi(x, y, i2, type);
        if (roi.getStroke() != null) {
            p.setStrokeWidth(roi.getStrokeWidth());
        }
        p.setStrokeColor(roi.getStrokeColor());
        p.setName(roi.getName());
        this.imp.setRoi(p);
        return p;
    }

    double rodbard(double x) {
        double ex = x == 0.0 ? 5.0 : Math.exp(Math.log(x / 700.0) * 0.88);
        double y = -40.1;
        return (y /= 1.0 + ex) + 44.0;
    }

    int[] smooth(int[] a, int n) {
        FloatProcessor fp = new FloatProcessor(n, 1);
        for (int i = 0; i < n; ++i) {
            fp.putPixelValue(i, 0, a[i]);
        }
        GaussianBlur gb = new GaussianBlur();
        gb.blur1Direction(fp, 2.0, 0.01, true, 0);
        for (int i = 0; i < n; ++i) {
            a[i] = Math.round(fp.getPixelValue(i, 0));
        }
        return a;
    }

    float[] getCurvature(int[] x, int[] y, int n) {
        float[] x2 = new float[n];
        float[] y2 = new float[n];
        for (int i = 0; i < n; ++i) {
            x2[i] = x[i];
            y2[i] = y[i];
        }
        FloatProcessor ipx = new FloatProcessor(n, 1, x2, null);
        FloatProcessor ipy = new FloatProcessor(n, 1, y2, null);
        ((ImageProcessor)ipx).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)ipy).convolve(this.kernel, this.kernel.length, 1);
        float[] indexes = new float[n];
        float[] curvature = new float[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = i;
            curvature[i] = (float)Math.sqrt((x2[i] - (float)x[i]) * (x2[i] - (float)x[i]) + (y2[i] - (float)y[i]) * (y2[i] - (float)y[i]));
        }
        return curvature;
    }

    PolygonRoi trimFloatPolygon(PolygonRoi roi, double length) {
        int type;
        FloatPolygon poly = roi.getFloatPolygon();
        float[] x = poly.xpoints;
        float[] y = poly.ypoints;
        int n = poly.npoints;
        x = this.smooth(x, n);
        y = this.smooth(y, n);
        float[] curvature = this.getCurvature(x, y, n);
        double threshold = this.rodbard(length);
        double distance = Math.sqrt((x[1] - x[0]) * (x[1] - x[0]) + (y[1] - y[0]) * (y[1] - y[0]));
        int i2 = 1;
        double x2 = 0.0;
        double y2 = 0.0;
        for (int i = 1; i < n - 1; ++i) {
            double x1 = x[i];
            double y1 = y[i];
            x2 = x[i + 1];
            y2 = y[i + 1];
            distance += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) + 1.0;
            if (!((distance += (double)(curvature[i] * 2.0f)) >= threshold)) continue;
            x[i2] = (float)x2;
            y[i2] = (float)y2;
            ++i2;
            distance = 0.0;
        }
        int n2 = type = roi.getType() == 7 ? 6 : 2;
        if (type == 6 && distance > 0.0) {
            x[i2] = (float)x2;
            y[i2] = (float)y2;
            ++i2;
        }
        PolygonRoi p = new PolygonRoi(x, y, i2, type);
        if (roi.getStroke() != null) {
            p.setStrokeWidth(roi.getStrokeWidth());
        }
        p.setStrokeColor(roi.getStrokeColor());
        p.setDrawOffset(roi.getDrawOffset());
        p.setName(roi.getName());
        this.imp.setRoi(p);
        return p;
    }

    float[] smooth(float[] a, int n) {
        FloatProcessor fp = new FloatProcessor(n, 1);
        for (int i = 0; i < n; ++i) {
            fp.setf(i, 0, a[i]);
        }
        GaussianBlur gb = new GaussianBlur();
        gb.blur1Direction(fp, 2.0, 0.01, true, 0);
        for (int i = 0; i < n; ++i) {
            a[i] = fp.getf(i, 0);
        }
        return a;
    }

    float[] getCurvature(float[] x, float[] y, int n) {
        float[] x2 = new float[n];
        float[] y2 = new float[n];
        for (int i = 0; i < n; ++i) {
            x2[i] = x[i];
            y2[i] = y[i];
        }
        FloatProcessor ipx = new FloatProcessor(n, 1, x, null);
        FloatProcessor ipy = new FloatProcessor(n, 1, y, null);
        ((ImageProcessor)ipx).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)ipy).convolve(this.kernel, this.kernel.length, 1);
        float[] indexes = new float[n];
        float[] curvature = new float[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = i;
            curvature[i] = (float)Math.sqrt((x2[i] - x[i]) * (x2[i] - x[i]) + (y2[i] - y[i]) * (y2[i] - y[i]));
        }
        return curvature;
    }

    void createEllipse(ImagePlus imp) {
        IJ.showStatus("Fitting ellipse");
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi("Fit Ellipse");
            return;
        }
        if (roi.isLine()) {
            IJ.error("Fit Ellipse", "\"Fit Ellipse\" does not work with line selections");
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        ip.setRoi(roi);
        int options = 2080;
        ImageStatistics stats = ImageStatistics.getStatistics(ip, options, null);
        double dx = stats.major * Math.cos(stats.angle / 180.0 * Math.PI) / 2.0;
        double dy = -stats.major * Math.sin(stats.angle / 180.0 * Math.PI) / 2.0;
        double x1 = stats.xCentroid - dx;
        double x2 = stats.xCentroid + dx;
        double y1 = stats.yCentroid - dy;
        double y2 = stats.yCentroid + dy;
        double aspectRatio = stats.minor / stats.major;
        Undo.setup(8, imp);
        imp.deleteRoi();
        EllipseRoi roi2 = new EllipseRoi(x1, y1, x2, y2, aspectRatio);
        Selection.transferProperties(roi, roi2);
        imp.setRoi(roi2);
    }

    void convexHull(ImagePlus imp) {
        int type;
        Roi roi = imp.getRoi();
        int n = type = roi != null ? roi.getType() : -1;
        if (type != 3 && type != 4 && type != 2 && type != 10) {
            IJ.error("Convex Hull", "Polygonal or point selection required");
            return;
        }
        if (roi instanceof EllipseRoi) {
            return;
        }
        Polygon p = roi.getConvexHull();
        if (p != null) {
            Undo.setup(8, imp);
            PolygonRoi roi2 = new PolygonRoi(p.xpoints, p.ypoints, p.npoints, 2);
            Selection.transferProperties(roi, roi2);
            imp.setRoi(roi2);
        }
    }

    int findFirstPoint(int[] xCoordinates, int[] yCoordinates, int n, ImagePlus imp) {
        int y;
        int smallestY = imp.getHeight();
        for (int i = 0; i < n; ++i) {
            y = yCoordinates[i];
            if (y >= smallestY) continue;
            smallestY = y;
        }
        int smallestX = imp.getWidth();
        int p1 = 0;
        for (int i = 0; i < n; ++i) {
            int x = xCoordinates[i];
            y = yCoordinates[i];
            if (y != smallestY || x >= smallestX) continue;
            smallestX = x;
            p1 = i;
        }
        return p1;
    }

    void createMask(ImagePlus imp) {
        boolean overlay;
        Roi roi = imp.getRoi();
        boolean useInvertingLut = Prefs.useInvertingLut;
        Prefs.useInvertingLut = false;
        boolean selectAll = roi != null && roi.getType() == 0 && roi.getBounds().width == imp.getWidth() && roi.getBounds().height == imp.getHeight() && imp.isThreshold();
        boolean bl = overlay = imp.getOverlay() != null && imp.getProcessor().getMinThreshold() == -808080.0;
        if (!overlay && (roi == null || selectAll)) {
            this.createMaskFromThreshold(imp);
            Prefs.useInvertingLut = useInvertingLut;
            return;
        }
        if (roi == null && imp.getOverlay() == null) {
            IJ.error("Create Mask", "Selection, overlay or threshold required");
            return;
        }
        ByteProcessor mask = imp.createRoiMask();
        if (!Prefs.blackBackground) {
            mask.invertLut();
        }
        ImagePlus maskImp = null;
        Frame frame = WindowManager.getFrame("Mask");
        if (frame != null && frame instanceof ImageWindow) {
            maskImp = ((ImageWindow)frame).getImagePlus();
        }
        if (maskImp != null && maskImp.getBitDepth() == 8) {
            ImageProcessor ip = maskImp.getProcessor();
            ip.copyBits(mask, 0, 0, 10);
            maskImp.setProcessor(ip);
        } else {
            maskImp = new ImagePlus("Mask", mask);
            maskImp.show();
        }
        Calibration cal = imp.getCalibration();
        if (cal.scaled()) {
            Calibration cal2 = maskImp.getCalibration();
            cal2.pixelWidth = cal.pixelWidth;
            cal2.pixelHeight = cal.pixelHeight;
            cal2.setUnit(cal.getUnit());
        }
        maskImp.updateAndRepaintWindow();
        Prefs.useInvertingLut = useInvertingLut;
        Recorder.recordCall("mask = imp.createRoiMask();");
    }

    void createMaskFromThreshold(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMinThreshold() == -808080.0) {
            IJ.error("Create Mask", "Area selection, overlay or thresholded image required");
            return;
        }
        ByteProcessor mask = imp.createThresholdMask();
        if (!Prefs.blackBackground) {
            mask.invertLut();
        }
        new ImagePlus("mask", mask).show();
        Recorder.recordCall("mask = imp.createThresholdMask();");
    }

    void createSelectionFromMask(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMinThreshold() != -808080.0) {
            IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
            return;
        }
        if (!ip.isBinary()) {
            IJ.error("Create Selection", "This command creates a composite selection from\na mask (8-bit binary image with white background)\nor from an image that has been thresholded using\nthe Image>Adjust>Threshold tool. The current\nimage is not a mask and has not been thresholded.");
            return;
        }
        int threshold = ip.isInvertedLut() ? 255 : 0;
        ip.setThreshold(threshold, threshold, 2);
        IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
    }

    void invert(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isArea()) {
            IJ.error("Inverse", "Area selection required");
            return;
        }
        ShapeRoi s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        ShapeRoi s2 = new ShapeRoi(new Roi(0, 0, imp.getWidth(), imp.getHeight()));
        Undo.setup(8, imp);
        imp.setRoi(s1.xor(s2));
    }

    private void lineToArea(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isLine()) {
            IJ.error("Line to Area", "Line selection required");
            return;
        }
        Undo.setup(8, imp);
        Roi roi2 = Selection.lineToArea(roi);
        imp.setRoi(roi2);
        Roi.previousRoi = (Roi)roi.clone();
    }

    public static Roi lineToArea(Roi roi) {
        Roi roi2 = null;
        if (roi.getType() == 5) {
            double width = roi.getStrokeWidth();
            if (width <= 1.0) {
                roi.setStrokeWidth(1.0000001);
            }
            FloatPolygon p = roi.getFloatPolygon();
            roi.setStrokeWidth(width);
            roi2 = new PolygonRoi(p, 2);
            roi2.setDrawOffset(roi.getDrawOffset());
        } else {
            int lwidth = (int)(roi = (Roi)roi.clone()).getStrokeWidth();
            if (lwidth < 1) {
                lwidth = 1;
            }
            Rectangle bounds = roi.getBounds();
            int width = bounds.width + lwidth * 2;
            int height = bounds.height + lwidth * 2;
            ByteProcessor ip2 = new ByteProcessor(width, height);
            roi.setLocation(lwidth, lwidth);
            ip2.setColor(255);
            roi.drawPixels(ip2);
            ((ImageProcessor)ip2).setThreshold(255.0, 255.0, 2);
            ThresholdToSelection tts = new ThresholdToSelection();
            roi2 = tts.convert(ip2);
            if (roi2 == null) {
                return roi;
            }
            if (bounds.x == 0 && bounds.y == 0) {
                roi2.setLocation(0, 0);
            } else {
                roi2.setLocation(bounds.x - lwidth / 2, bounds.y - lwidth / 2);
            }
        }
        Selection.transferProperties(roi, roi2);
        roi2.setStrokeWidth(0.0f);
        Color c = roi2.getStrokeColor();
        if (c != null) {
            roi2.setStrokeColor(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        }
        return roi2;
    }

    void areaToLine(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isArea()) {
            IJ.error("Area to Line", "Area selection required");
            return;
        }
        Undo.setup(8, imp);
        Polygon p = roi.getPolygon();
        if (p == null) {
            return;
        }
        int type1 = roi.getType();
        if (type1 == 9) {
            IJ.error("Area to Line", "Composite selections cannot be converted to lines.");
            return;
        }
        int type2 = 6;
        if (type1 == 1 || type1 == 3 || type1 == 4 || roi instanceof PolygonRoi && ((PolygonRoi)roi).isSplineFit()) {
            type2 = 7;
        }
        PolygonRoi roi2 = new PolygonRoi(p.xpoints, p.ypoints, p.npoints, type2);
        Selection.transferProperties(roi, roi2);
        imp.setRoi(roi2);
    }

    void toBoundingBox(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi("To Bounding Box");
            return;
        }
        Undo.setup(8, imp);
        Rectangle r = roi.getBounds();
        imp.deleteRoi();
        Roi roi2 = new Roi(r.x, r.y, r.width, r.height);
        Selection.transferProperties(roi, roi2);
        imp.setRoi(roi2);
    }

    void addToRoiManager(ImagePlus imp) {
        RoiManager rm;
        block8: {
            Frame frame;
            if (IJ.macroRunning() && Interpreter.isBatchModeRoiManager()) {
                IJ.error("run(\"Add to Manager\") may not work in batch mode macros");
            }
            if ((frame = WindowManager.getFrame("ROI Manager")) == null) {
                IJ.run("ROI Manager...");
            }
            if (imp == null) {
                return;
            }
            Roi roi = imp.getRoi();
            if (roi == null) {
                return;
            }
            frame = WindowManager.getFrame("ROI Manager");
            if (frame == null || !(frame instanceof RoiManager)) {
                IJ.error("ROI Manager not found");
            }
            rm = (RoiManager)frame;
            boolean altDown = IJ.altKeyDown();
            IJ.setKeyUp(-1);
            if (altDown && !IJ.macroRunning()) {
                IJ.setKeyDown(16);
            }
            if (roi.getState() == 0) {
                long start = System.currentTimeMillis();
                do {
                    IJ.wait(10);
                    if (roi.getState() != 0) break block8;
                } while (System.currentTimeMillis() - start <= 2000L);
                IJ.beep();
                IJ.error("Add to Manager", "Selection is not complete");
                return;
            }
        }
        rm.allowRecording(true);
        rm.runCommand("add");
        rm.allowRecording(false);
        IJ.setKeyUp(-1);
    }

    boolean setProperties(String title, Roi roi) {
        if (roi instanceof PointRoi && Toolbar.getMultiPointMode() && IJ.altKeyDown()) {
            ((PointRoi)roi).displayCounts();
            return true;
        }
        Frame f = WindowManager.getFrontWindow();
        if (f != null && f.getTitle().indexOf("3D Viewer") != -1) {
            return false;
        }
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return false;
        }
        RoiProperties rp = new RoiProperties(title, roi);
        boolean ok = rp.showDialog();
        if (IJ.debugMode) {
            IJ.log(roi.getDebugInfo());
        }
        return ok;
    }

    private void makeBand(ImagePlus imp) {
        int count;
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi("Make Band");
            return;
        }
        Roi roiOrig = roi;
        if (!roi.isArea()) {
            IJ.error("Make Band", "Area selection required");
            return;
        }
        Calibration cal = imp.getCalibration();
        double pixels = bandSize;
        double size = pixels * cal.pixelWidth;
        int decimalPlaces = 0;
        if ((double)((int)size) != size) {
            decimalPlaces = 2;
        }
        GenericDialog gd = new GenericDialog("Make Band");
        gd.addNumericField("Band Size:", size, decimalPlaces, 4, cal.getUnits());
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        size = gd.getNextNumber();
        if (Double.isNaN(size)) {
            IJ.error("Make Band", "invalid number");
            return;
        }
        int n = (int)Math.round(size / cal.pixelWidth);
        if (n > 255) {
            IJ.error("Make Band", "Cannot make bands wider that 255 pixels");
            return;
        }
        int width = imp.getWidth();
        int height = imp.getHeight();
        Rectangle r = roi.getBounds();
        ImageProcessor ip = roi.getMask();
        if (ip == null) {
            ip = new ByteProcessor(r.width, r.height);
            ip.invert();
        }
        ByteProcessor mask = new ByteProcessor(width, height);
        mask.insert(ip, r.x, r.y);
        ImagePlus edm = new ImagePlus("mask", mask);
        boolean saveBlackBackground = Prefs.blackBackground;
        Prefs.blackBackground = false;
        int saveType = EDM.getOutputType();
        EDM.setOutputType(0);
        IJ.run(edm, "Distance Map", "");
        EDM.setOutputType(saveType);
        Prefs.blackBackground = saveBlackBackground;
        ip = edm.getProcessor();
        ip.setThreshold(0.0, n, 2);
        int xx = -1;
        int yy = -1;
        for (int x = r.x; x < r.x + r.width; ++x) {
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (ip.getPixel(x, y) >= n) continue;
                xx = x;
                yy = y;
                break;
            }
            if (xx >= 0 || yy >= 0) break;
        }
        if ((count = IJ.doWand(edm, xx, yy, 0.0, null)) <= 0) {
            IJ.error("Make Band", "Unable to make band");
            return;
        }
        ShapeRoi roi2 = new ShapeRoi(edm.getRoi());
        if (!(roi instanceof ShapeRoi)) {
            roi = new ShapeRoi(roi);
        }
        ShapeRoi roi1 = (ShapeRoi)roi;
        roi2 = roi2.not(roi1);
        Undo.setup(8, imp);
        Selection.transferProperties(roiOrig, roi2);
        imp.setRoi(roi2);
        bandSize = n;
    }

    void noRoi(String command) {
        IJ.error(command, "This command requires a selection");
    }

    static {
        lineWidth = 1;
    }
}

