/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.wrapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers;
    private final byte[] bytes;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        byte[] bytesEi;
        ArrayList<String> list;
        Object values;
        String name;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            values = request.getParameterValues(name);
            if (values != null) {
                list = new ArrayList<String>(Arrays.asList(values));
                this.parameters.put(name, list);
                continue;
            }
            this.parameters.put(name, null);
        }
        this.headers = new HashMap<String, List<String>>();
        en = request.getHeaderNames();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            values = request.getHeaders(name);
            if (values != null) {
                list = new ArrayList();
                while (values.hasMoreElements()) {
                    list.add((String)values.nextElement());
                }
                this.headers.put(name, list);
                continue;
            }
            this.headers.put(name, null);
        }
        try {
            ServletInputStream stream = request.getInputStream();
            bytesEi = IOUtils.toByteArray((InputStream)stream);
        }
        catch (Exception e) {
            bytesEi = new byte[]{};
        }
        this.bytes = bytesEi;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> values = this.headers.get(name);
        return values != null ? Collections.enumeration(values) : Collections.enumeration(Arrays.asList(new String[0]));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public void setHeader(String name, String[] values) {
        this.headers.put(name, (List<String>)(values != null ? new ArrayList<String>(Arrays.asList(values)) : null));
    }

    public void setHeader(String name, String value) {
        this.setHeader(name, new String[]{value});
    }

    public void addHeader(String name, String[] values) {
        if (values == null) {
            return;
        }
        ArrayList<String> list = this.headers.getOrDefault(name, null);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(name, list);
        }
        list.addAll(Arrays.asList(values));
    }

    public void addHeader(String name, String value) {
        this.addHeader(name, new String[]{value});
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public String getParameter(String name) {
        List<String> values = this.parameters.get(name);
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            map.put(entry.getKey(), entry.getValue() != null ? entry.getValue().toArray(new String[0]) : null);
        }
        return Collections.unmodifiableMap(map);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        List<String> values = this.parameters.get(name);
        return values != null ? values.toArray(new String[0]) : null;
    }

    public void setParameter(String name, String[] values) {
        this.parameters.put(name, (List<String>)(values != null ? new ArrayList<String>(Arrays.asList(values)) : null));
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        if (values == null) {
            return;
        }
        ArrayList<String> list = this.parameters.getOrDefault(name, null);
        if (list == null) {
            list = new ArrayList<String>();
            this.parameters.put(name, list);
        }
        list.addAll(Arrays.asList(values));
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new InternalServletInputStream(this.bytes);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.bytes), StandardCharsets.UTF_8));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    private static class InternalServletInputStream
    extends ServletInputStream {
        private final InputStream inputStream;

        public InternalServletInputStream(byte[] bytes) {
            this.inputStream = new ByteArrayInputStream(bytes);
        }

        public boolean isFinished() {
            try {
                return this.inputStream.available() == 0;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }
    }
}

