/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static Long toEpochMillis(String date, Integer totalSeconds, DateTimeFormatter formatter) {
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(totalSeconds);
        OffsetDateTime offsetDateTime = LocalDateTime.parse(date, formatter).atOffset(zoneOffset);
        return offsetDateTime.toInstant().toEpochMilli();
    }

    public static Long toEpochMillis(String date, Integer totalSeconds, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return TimeUtil.toEpochMillis(date, totalSeconds, formatter);
    }

    public static Long toEpochMillis(String date, ZoneId zoneId, DateTimeFormatter formatter) {
        ZonedDateTime zonedDateTime = LocalDateTime.parse(date, formatter).atZone(zoneId);
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static Long toEpochMillis(String date, ZoneId zoneId, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return TimeUtil.toEpochMillis(date, zoneId, formatter);
    }

    public static ZonedDateTime toZonedDateTime(Long epochMillis, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), zoneId);
    }

    public static ZonedDateTime toZonedDateTime(Long epochMillis, Integer totalSeconds) {
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(totalSeconds);
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), zoneOffset);
    }

    public static String toStringFormat(Long epochMillis, Integer totalSeconds, String format) {
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(totalSeconds);
        return TimeUtil.toStringFormat(epochMillis, zoneOffset, format);
    }

    public static String toStringFormat(Long epochMillis, ZoneId zoneId, String format) {
        ZonedDateTime zonedDateTime = TimeUtil.toZonedDateTime(epochMillis, zoneId);
        return TimeUtil.toStringFormat(zonedDateTime, format);
    }

    public static String toStringFormat(TemporalAccessor temporal, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(temporal);
    }

    public static Long currentEpochMillis() {
        return Instant.now().toEpochMilli();
    }

    public static Long dateAsLong(String date) {
        String string = date = date != null ? date.trim() : "";
        if (date.length() < 6) {
            return null;
        }
        return Long.valueOf(date.replace("-", ""));
    }
}

