/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ideahut.springboot.object.Message;

public final class ErrorUtil {
    private static final List<Class<? extends RuntimeException>> THROWABLES = Arrays.asList(UndeclaredThrowableException.class);

    private ErrorUtil() {
    }

    public static Throwable getCause(Throwable throwable) {
        if (THROWABLES.contains(throwable.getClass())) {
            return throwable.getCause();
        }
        return throwable;
    }

    public static List<Message> getErrors(Throwable ex) {
        return ErrorUtil.getErrors(ex, false);
    }

    public static List<Message> getErrors(Throwable ex, boolean isCheckSql) {
        ArrayList<Message> errors = new ArrayList<Message>();
        Throwable throwable = ex;
        int i = 0;
        while (throwable != null) {
            if (isCheckSql && throwable instanceof SQLIntegrityConstraintViolationException) {
                String errmsg = ((SQLIntegrityConstraintViolationException)throwable).getMessage();
                if (errmsg.indexOf("Duplicate entry") != -1) {
                    errors.clear();
                    errors.add(Message.of("SQL-DUPLICATE", errmsg));
                    return errors;
                }
                if (errmsg.indexOf("cannot be null") != -1) {
                    errors.clear();
                    errors.add(Message.of("SQL-NOTNULL", errmsg));
                    return errors;
                }
            }
            errors.add(Message.of("ERR-" + i, throwable.getMessage()));
            throwable = throwable.getCause();
            ++i;
        }
        return errors;
    }
}

