/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.singleton;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.ideahut.springboot.singleton.SingletonDestroyable;
import net.ideahut.springboot.singleton.SingletonHandler;
import net.ideahut.springboot.singleton.SingletonObject;

public class SingletonHandlerImpl
implements SingletonHandler {
    private final Map<String, SingletonObject> singletons = new ConcurrentHashMap<String, SingletonObject>();

    @Override
    public <T> T getSingleton(String name, Callable<T> callable, SingletonDestroyable destroyable, Object ... validations) {
        SingletonObject singleton;
        if (validations == null) {
            validations = new Object[]{};
        }
        if ((singleton = this.singletons.get(name)) != null) {
            if (Arrays.equals(validations, singleton.getValidations())) {
                return (T)singleton.getObject();
            }
            if (singleton.getDestroyable() != null) {
                singleton.getDestroyable().onDestroy(singleton.getObject());
            }
            this.singletons.remove(name);
        }
        if (callable != null) {
            try {
                T object = callable.call();
                singleton = SingletonObject.of(object, validations, destroyable);
                this.singletons.put(name, singleton);
                return (T)singleton.getObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public <T> T getSingleton(String name, Callable<T> callable, Object ... validations) {
        return this.getSingleton(name, callable, null, validations);
    }
}

