/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Message;

public final class Result
implements Serializable {
    private static final long serialVersionUID = 3635693412249849007L;
    private Long time;
    private Integer status;
    private List<Message> error;
    private transient Object data;
    private transient MapStringObject info;

    private Result() {
    }

    private Result(Integer status, Object data, List<Message> error) {
        this.status = status;
        this.data = data;
        this.error = error;
        this.time = RequestContext.time();
    }

    public Result setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public Result setError(List<Message> error) {
        this.error = error;
        return this;
    }

    public Result setData(Object data) {
        this.data = data;
        return this;
    }

    public Result setInfo(MapStringObject info) {
        this.info = info;
        return this;
    }

    public Result setInfo(String key, Object value) {
        if (this.info == null) {
            this.info = new MapStringObject();
        }
        this.info.put(key, value);
        return this;
    }

    public Result updateTime(Long time) {
        this.time = time != null ? time : RequestContext.time();
        return this;
    }

    public Result updateTime() {
        return this.updateTime(null);
    }

    public Result nullTime() {
        this.time = null;
        return this;
    }

    public boolean hasError() {
        return this.error != null && !this.error.isEmpty();
    }

    public static Result status(Integer status, Object data) {
        return new Result(status, data, null);
    }

    public static Result status(Integer status) {
        return new Result(status, null, null);
    }

    public static Result success(Object data) {
        return new Result(0, data, null);
    }

    public static Result success() {
        return new Result(0, null, null);
    }

    public static Result error(List<Message> error) {
        return new Result(1, null, error);
    }

    public static Result error(Message error) {
        return Result.error(Arrays.asList(error));
    }

    public static Result error(String code, String text) {
        return Result.error(new Message(code, text));
    }

    public static Result error(String code) {
        return Result.error(new Message(code, null));
    }

    public static Result error() {
        return new Result(1, null, null);
    }

    public Long getTime() {
        return this.time;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<Message> getError() {
        return this.error;
    }

    public Object getData() {
        return this.data;
    }

    public MapStringObject getInfo() {
        return this.info;
    }

    public static final class Status {
        public static final int SUCCESS = 0;
        public static final int ERROR = 1;

        private Status() {
        }
    }
}

