/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.object.KeyValue;

public class ParameterInfo
implements Serializable {
    private static final long serialVersionUID = 6593895128907010875L;
    private String type;
    private String name;
    private int modifiers;
    private List<KeyValue<String, String>> annotations;

    public static ParameterInfo of(Parameter parameter) {
        ParameterInfo info = new ParameterInfo();
        info.type = parameter.getType().getName();
        info.name = parameter.getName();
        info.modifiers = parameter.getModifiers();
        info.annotations = new ArrayList<KeyValue<String, String>>();
        for (Annotation annotation : parameter.getAnnotations()) {
            KeyValue<String, String> nv = new KeyValue<String, String>(annotation.annotationType().getName(), annotation.toString());
            info.annotations.add(nv);
        }
        return info;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public List<KeyValue<String, String>> getAnnotations() {
        return this.annotations;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setAnnotations(List<KeyValue<String, String>> annotations) {
        this.annotations = annotations;
    }
}

