/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;

public final class ImageReader {
    private final BufferedImage image;
    private final String format;

    private ImageReader(BufferedImage image, String format) {
        this.image = image;
        this.format = format;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getFormat() {
        return this.format;
    }

    public static ImageReader of(InputStream inputStream) throws Exception {
        return ImageReader.of(inputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageReader of(InputStream inputStream, boolean ignoreMetadata) throws Exception {
        ImageInputStream stream = null;
        try {
            stream = ImageIO.createImageInputStream(inputStream);
            Iterator<javax.imageio.ImageReader> readers = ImageIO.getImageReaders(stream);
            if (!readers.hasNext()) {
                throw new Exception("ImageReaders is not found");
            }
            javax.imageio.ImageReader reader = readers.next();
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(stream, true, ignoreMetadata);
            BufferedImage image = reader.read(0, param);
            String format = reader.getFormatName();
            ImageReader imageReader = new ImageReader(image, format);
            return imageReader;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

