/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.object.SelfReference;
import net.ideahut.springboot.util.StringUtil;

public abstract class AttributeBase<S>
extends SelfReference<S> {
    private static final long serialVersionUID = 5953749518801904832L;
    private Map<String, String> attributes;

    public <T> T getAttribute(Class<T> type, String name, T defaultValue) {
        String value = this.attributes != null ? this.attributes.get(name) : null;
        return StringUtil.valueOf(type, value, defaultValue);
    }

    public <T> T getAttribute(Class<T> type, String name) {
        return this.getAttribute(type, name, null);
    }

    public S setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        this.attributes.put(name, value);
        return this.self();
    }

    public S setAttributeMap(Map<String, String> map) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        this.attributes.putAll(map);
        return this.self();
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

