/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.Logical;

public class Filter {
    private String field;
    private Condition condition;
    private Logical logical;
    private List<Object> values;
    private List<Filter> filters;

    public String getStringValue() {
        return this.values != null && !this.values.isEmpty() ? this.values.iterator().next() + "" : "";
    }

    public Filter setField(String field) {
        this.field = field;
        return this;
    }

    public Filter setCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public Filter setLogical(Logical logical) {
        this.logical = logical;
        return this;
    }

    public Filter setValues(List<Object> values) {
        this.values = values;
        return this;
    }

    public Filter addValue(Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        this.values.add(value);
        return this;
    }

    public Filter setFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public Filter addFilter(Filter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        this.filters.add(filter);
        return this;
    }

    public static Filter of(Logical logical, String field, Condition condition, Object ... values) {
        Filter o = new Filter();
        o.condition = condition;
        o.logical = logical;
        o.field = field;
        o.values = values != null ? new ArrayList<Object>(Arrays.asList(values)) : null;
        return o;
    }

    public static Filter and(String field, Condition condition, Object ... values) {
        return Filter.of(Logical.AND, field, condition, values);
    }

    public static Filter or(String field, Condition condition, Object ... values) {
        return Filter.of(Logical.OR, field, condition, values);
    }

    public String getField() {
        return this.field;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }
}

