/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.object.Result;

public class CrudResult {
    private Object value;
    private Message error;
    private MapStringObject info;

    private CrudResult() {
    }

    public CrudResult setInfo(String key, Object value) {
        if (this.info == null) {
            this.info = new MapStringObject();
        }
        this.info.put(key, value);
        return this;
    }

    protected CrudResult setInfo(MapStringObject info) {
        this.info = info;
        return this;
    }

    public Result toResult() {
        if (this.error != null) {
            return Result.error(this.error);
        }
        return Result.success(this.value).setInfo(this.info);
    }

    public static CrudResult success(Object value, MapStringObject info) {
        CrudResult crudResult = new CrudResult();
        crudResult.value = value;
        crudResult.info = info;
        return crudResult;
    }

    public static CrudResult success(Object value) {
        return CrudResult.success(value, null);
    }

    public static CrudResult error(Message error, MapStringObject info) {
        CrudResult crudResult = new CrudResult();
        crudResult.error = error;
        crudResult.info = info;
        return crudResult;
    }

    public static CrudResult error(Message error) {
        return CrudResult.error(error, null);
    }

    public static CrudResult error(String code, String message) {
        return CrudResult.error(Message.of(code, message), null);
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public Message getError() {
        return this.error;
    }

    public MapStringObject getInfo() {
        return this.info;
    }
}

