/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void executeUninterruptibly(BlockingOperation operation) {
        boolean wasInterrupted = false;
        while (true) {
            try {
                operation.run();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean joinUninterruptibly(Thread thread, long timeoutMs) {
        long startTimeMs = SystemClock.elapsedRealtime();
        long timeRemainingMs = timeoutMs;
        boolean wasInterrupted = false;
        while (timeRemainingMs > 0L) {
            try {
                thread.join(timeRemainingMs);
                break;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                long elapsedTimeMs = SystemClock.elapsedRealtime() - startTimeMs;
                timeRemainingMs = timeoutMs - elapsedTimeMs;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return !thread.isAlive();
    }

    public static void joinUninterruptibly(final Thread thread) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                thread.join();
            }
        });
    }

    public static void awaitUninterruptibly(final CountDownLatch latch) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                latch.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch barrier, long timeoutMs) {
        long startTimeMs = SystemClock.elapsedRealtime();
        long timeRemainingMs = timeoutMs;
        boolean wasInterrupted = false;
        boolean result = false;
        while (true) {
            try {
                result = barrier.await(timeRemainingMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                long elapsedTimeMs;
                wasInterrupted = true;
                if ((timeRemainingMs = timeoutMs - (elapsedTimeMs = SystemClock.elapsedRealtime() - startTimeMs)) > 0L) continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public static <V> V invokeAtFrontUninterruptibly(Handler handler, final Callable<V> callable) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            V value;
            try {
                value = callable.call();
            }
            catch (Exception e) {
                RuntimeException runtimeException = new RuntimeException("Callable threw exception: " + e);
                runtimeException.setStackTrace(e.getStackTrace());
                throw runtimeException;
            }
            return value;
        }
        class Result {
            public V value;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch barrier = new CountDownLatch(1);
        handler.post(new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    result.value = callable.call();
                }
                catch (Exception e) {
                    RuntimeException runtimeException = new RuntimeException("Callable threw exception: " + e);
                    runtimeException.setStackTrace(e.getStackTrace());
                    throw runtimeException;
                }
                barrier.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(barrier);
        return result.value;
    }

    public static void invokeAtFrontUninterruptibly(Handler handler, final Runnable runner) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            runner.run();
            return;
        }
        final CountDownLatch barrier = new CountDownLatch(1);
        handler.postAtFrontOfQueue(new Runnable(){

            @Override
            public void run() {
                runner.run();
                barrier.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(barrier);
    }

    public static interface BlockingOperation {
        public void run() throws InterruptedException;
    }

    public static class ThreadChecker {
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

