/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Range;
import android.view.Surface;
import android.view.WindowManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCapturer;

@TargetApi(value=21)
public class Camera2Capturer
implements CameraVideoCapturer,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "Camera2Capturer";
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final int STOP_TIMEOUT = 10000;
    private static final int START_TIMEOUT = 10000;
    private static final Object STOP_TIMEOUT_RUNNABLE_TOKEN = new Object();
    private final CameraManager cameraManager;
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private SurfaceTextureHelper surfaceTextureHelper;
    private Context applicationContext;
    private VideoCapturer.CapturerObserver capturerObserver;
    private Handler cameraThreadHandler;
    private final Object cameraStateLock = new Object();
    private volatile CameraState cameraState = CameraState.IDLE;
    private int requestedWidth;
    private int requestedHeight;
    private int requestedFramerate;
    private String cameraName;
    private boolean isFrontCamera;
    private int cameraOrientation;
    private final AtomicBoolean isPendingCameraSwitch = new AtomicBoolean();
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private CameraCaptureSession captureSession;
    private Surface surface;
    private CameraDevice cameraDevice;
    private int fpsUnitFactor;
    private boolean firstFrameReported;
    private int consecutiveCameraOpenFailures;

    public Camera2Capturer(Context context, String cameraName, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        Logging.d(TAG, "Camera2Capturer ctor, camera name: " + cameraName);
        this.cameraManager = (CameraManager)context.getSystemService("camera");
        this.eventsHandler = eventsHandler;
        this.setCameraName(cameraName);
    }

    private boolean isOnCameraThread() {
        return Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread();
    }

    private void checkIsOnCameraThread() {
        if (!this.isOnCameraThread()) {
            throw new IllegalStateException("Not on camera thread");
        }
    }

    private void checkNotOnCameraThread() {
        if (this.cameraThreadHandler == null) {
            return;
        }
        if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Method waiting for camera state to change executed on camera thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCameraToExitTransitionalState(CameraState transitionalState, long timeoutMs) {
        this.checkNotOnCameraThread();
        Object object = this.cameraStateLock;
        synchronized (object) {
            long timeoutAt = SystemClock.uptimeMillis() + timeoutMs;
            while (this.cameraState == transitionalState) {
                Logging.d(TAG, "waitForCameraToExitTransitionalState waiting: " + (Object)((Object)this.cameraState));
                long timeLeft = timeoutAt - SystemClock.uptimeMillis();
                if (timeLeft <= 0L) {
                    Logging.e(TAG, "Camera failed to exit transitional state " + (Object)((Object)transitionalState) + " within the time limit.");
                    break;
                }
                try {
                    this.cameraStateLock.wait(timeLeft);
                }
                catch (InterruptedException e) {
                    Logging.w(TAG, "Trying to interrupt while waiting to exit transitional state " + (Object)((Object)transitionalState) + ", ignoring: " + e);
                }
            }
        }
    }

    private void waitForCameraToStopIfStopping() {
        this.waitForCameraToExitTransitionalState(CameraState.STOPPING, 10000L);
    }

    private void waitForCameraToStartIfStarting() {
        this.waitForCameraToExitTransitionalState(CameraState.STARTING, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCameraName(String cameraName) {
        CameraCharacteristics characteristics;
        try {
            String[] cameraIds = this.cameraManager.getCameraIdList();
            if (cameraName.isEmpty() && cameraIds.length != 0) {
                cameraName = cameraIds[0];
            }
            if (!Arrays.asList(cameraIds).contains(cameraName)) {
                throw new IllegalArgumentException("Camera name: " + cameraName + " does not match any known camera device:");
            }
            characteristics = this.cameraManager.getCameraCharacteristics(cameraName);
        }
        catch (CameraAccessException e) {
            throw new RuntimeException("Camera access exception: " + (Object)((Object)e));
        }
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.waitForCameraToStopIfStopping();
            if (this.cameraState != CameraState.IDLE) {
                throw new RuntimeException("Changing camera name on running camera.");
            }
            this.cameraName = cameraName;
            this.isFrontCamera = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) == 0;
            this.cameraOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        }
    }

    private void reportError(String errorDescription) {
        this.checkIsOnCameraThread();
        Logging.e(TAG, "Error in camera at state " + (Object)((Object)this.cameraState) + ": " + errorDescription);
        if (this.switchEventsHandler != null) {
            this.switchEventsHandler.onCameraSwitchError(errorDescription);
            this.switchEventsHandler = null;
        }
        this.isPendingCameraSwitch.set(false);
        switch (this.cameraState) {
            case STARTING: {
                this.capturerObserver.onCapturerStarted(false);
            }
            case RUNNING: {
                if (this.eventsHandler == null) break;
                this.eventsHandler.onCameraError(errorDescription);
                break;
            }
            case STOPPING: {
                this.setCameraState(CameraState.IDLE);
                Logging.e(TAG, "Closing camera failed: " + errorDescription);
                return;
            }
            default: {
                throw new RuntimeException("Unknown camera state: " + (Object)((Object)this.cameraState));
            }
        }
        this.closeAndRelease();
    }

    private void closeAndRelease() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "Close and release.");
        this.setCameraState(CameraState.STOPPING);
        this.capturerObserver.onCapturerStopped();
        this.cameraThreadHandler.removeCallbacksAndMessages((Object)this);
        if (this.cameraStatistics != null) {
            this.cameraStatistics.release();
            this.cameraStatistics = null;
        }
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.stopListening();
        }
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraThreadHandler.postAtTime(new Runnable(){

                @Override
                public void run() {
                    Logging.e(Camera2Capturer.TAG, "Camera failed to stop within the timeout. Force stopping.");
                    Camera2Capturer.this.setCameraState(CameraState.IDLE);
                    if (Camera2Capturer.this.eventsHandler != null) {
                        Camera2Capturer.this.eventsHandler.onCameraError("Camera failed to stop (timeout).");
                    }
                }
            }, STOP_TIMEOUT_RUNNABLE_TOKEN, SystemClock.uptimeMillis() + 10000L);
            this.cameraDevice.close();
            this.cameraDevice = null;
        } else {
            Logging.w(TAG, "closeAndRelease called while cameraDevice is null");
            this.setCameraState(CameraState.IDLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCameraState(CameraState newState) {
        if (this.cameraState != CameraState.IDLE) {
            this.checkIsOnCameraThread();
        }
        switch (newState) {
            case STARTING: {
                if (this.cameraState == CameraState.IDLE) break;
                throw new IllegalStateException("Only stopped camera can start.");
            }
            case RUNNING: {
                if (this.cameraState == CameraState.STARTING) break;
                throw new IllegalStateException("Only starting camera can go to running state.");
            }
            case STOPPING: {
                if (this.cameraState == CameraState.STARTING || this.cameraState == CameraState.RUNNING) break;
                throw new IllegalStateException("Only starting or running camera can stop.");
            }
            case IDLE: {
                if (this.cameraState == CameraState.STOPPING) break;
                throw new IllegalStateException("Only stopping camera can go to idle state.");
            }
            default: {
                throw new RuntimeException("Unknown camera state: " + (Object)((Object)newState));
            }
        }
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.cameraState = newState;
            this.cameraStateLock.notifyAll();
        }
    }

    private void openCamera() {
        try {
            this.checkIsOnCameraThread();
            if (this.cameraState != CameraState.STARTING) {
                throw new IllegalStateException("Camera should be in state STARTING in openCamera.");
            }
            this.cameraManager.openCamera(this.cameraName, (CameraDevice.StateCallback)new CameraStateCallback(), this.cameraThreadHandler);
        }
        catch (CameraAccessException e) {
            this.reportError("Failed to open camera: " + (Object)((Object)e));
        }
    }

    private boolean isInitialized() {
        return this.applicationContext != null && this.capturerObserver != null;
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, VideoCapturer.CapturerObserver capturerObserver) {
        Logging.d(TAG, "initialize");
        if (applicationContext == null) {
            throw new IllegalArgumentException("applicationContext not set.");
        }
        if (capturerObserver == null) {
            throw new IllegalArgumentException("capturerObserver not set.");
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }
        this.applicationContext = applicationContext;
        this.capturerObserver = capturerObserver;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCaptureOnCameraThread(int requestedWidth, int requestedHeight, int requestedFramerate) {
        CameraCharacteristics cameraCharacteristics;
        this.checkIsOnCameraThread();
        this.firstFrameReported = false;
        this.consecutiveCameraOpenFailures = 0;
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.requestedWidth = requestedWidth;
            this.requestedHeight = requestedHeight;
            this.requestedFramerate = requestedFramerate;
        }
        try {
            cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraName);
        }
        catch (CameraAccessException e) {
            this.reportError("getCameraCharacteristics(): " + e.getMessage());
            return;
        }
        Range[] fpsRanges = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(fpsRanges);
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> framerateRanges = Camera2Enumerator.convertFramerates(fpsRanges, this.fpsUnitFactor);
        List<Size> sizes = Camera2Enumerator.getSupportedSizes(cameraCharacteristics);
        if (framerateRanges.isEmpty() || sizes.isEmpty()) {
            this.reportError("No supported capture formats.");
        }
        CameraEnumerationAndroid.CaptureFormat.FramerateRange bestFpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(framerateRanges, requestedFramerate);
        Size bestSize = CameraEnumerationAndroid.getClosestSupportedSize(sizes, requestedWidth, requestedHeight);
        this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(bestSize.width, bestSize.height, bestFpsRange);
        Logging.d(TAG, "Using capture format: " + this.captureFormat);
        Logging.d(TAG, "Opening camera " + this.cameraName);
        if (this.eventsHandler != null) {
            int cameraIndex = -1;
            try {
                cameraIndex = Integer.parseInt(this.cameraName);
            }
            catch (NumberFormatException e) {
                Logging.d(TAG, "External camera with non-int identifier: " + this.cameraName);
            }
            this.eventsHandler.onCameraOpening(cameraIndex);
        }
        this.openCamera();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(final int requestedWidth, final int requestedHeight, final int requestedFramerate) {
        Logging.d(TAG, "startCapture requested: " + requestedWidth + "x" + requestedHeight + "@" + requestedFramerate);
        if (!this.isInitialized()) {
            throw new IllegalStateException("startCapture called in uninitialized state");
        }
        if (this.surfaceTextureHelper == null) {
            this.capturerObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("No SurfaceTexture created.");
            }
            return;
        }
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.waitForCameraToStopIfStopping();
            if (this.cameraState != CameraState.IDLE) {
                Logging.e(TAG, "Unexpected camera state for startCapture: " + (Object)((Object)this.cameraState));
                return;
            }
            this.setCameraState(CameraState.STARTING);
        }
        this.postOnCameraThread(new Runnable(){

            @Override
            public void run() {
                Camera2Capturer.this.startCaptureOnCameraThread(requestedWidth, requestedHeight, requestedFramerate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchCamera(CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        int requestedFramerate;
        int requestedHeight;
        int requestedWidth;
        String newCameraId;
        Object[] cameraIds;
        try {
            cameraIds = this.cameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("Could not get camera names: " + (Object)((Object)e));
            }
            return;
        }
        if (cameraIds.length < 2) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        if (this.isPendingCameraSwitch.getAndSet(true)) {
            Logging.w(TAG, "Ignoring camera switch request.");
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("Pending camera switch already in progress.");
            }
            return;
        }
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.waitForCameraToStartIfStarting();
            if (this.cameraState != CameraState.RUNNING) {
                Logging.e(TAG, "Calling swithCamera() on stopped camera.");
                if (switchEventsHandler != null) {
                    switchEventsHandler.onCameraSwitchError("Camera is stopped.");
                }
                this.isPendingCameraSwitch.set(false);
                return;
            }
            int currentCameraIndex = Arrays.asList(cameraIds).indexOf(this.cameraName);
            if (currentCameraIndex == -1) {
                Logging.e(TAG, "Couldn't find current camera id " + this.cameraName + " in list of camera ids: " + Arrays.toString(cameraIds));
            }
            int newCameraIndex = (currentCameraIndex + 1) % cameraIds.length;
            newCameraId = cameraIds[newCameraIndex];
            requestedWidth = this.requestedWidth;
            requestedHeight = this.requestedHeight;
            requestedFramerate = this.requestedFramerate;
            this.switchEventsHandler = switchEventsHandler;
        }
        this.stopCapture();
        this.setCameraName(newCameraId);
        this.startCapture(requestedWidth, requestedHeight, requestedFramerate);
    }

    @Override
    public void onOutputFormatRequest(final int width, final int height, final int framerate) {
        this.postOnCameraThread(new Runnable(){

            @Override
            public void run() {
                Logging.d(Camera2Capturer.TAG, "onOutputFormatRequestOnCameraThread: " + width + "x" + height + "@" + framerate);
                Camera2Capturer.this.capturerObserver.onOutputFormatRequest(width, height, framerate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.waitForCameraToStartIfStarting();
            if (this.cameraState != CameraState.RUNNING) {
                Logging.e(TAG, "Calling changeCaptureFormat() on stopped camera.");
                return;
            }
            this.requestedWidth = width;
            this.requestedHeight = height;
            this.requestedFramerate = framerate;
        }
        this.stopCapture();
        this.startCapture(width, height, framerate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        CameraState cameraState = this.cameraState;
        synchronized (cameraState) {
            return Camera2Enumerator.getSupportedFormats(this.cameraManager, this.cameraName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.waitForCameraToStopIfStopping();
            if (this.cameraState != CameraState.IDLE) {
                throw new IllegalStateException("Unexpected camera state for dispose: " + (Object)((Object)this.cameraState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        final CountDownLatch cameraStoppingLatch = new CountDownLatch(1);
        Logging.d(TAG, "stopCapture");
        this.checkNotOnCameraThread();
        Object object = this.cameraStateLock;
        synchronized (object) {
            this.waitForCameraToStartIfStarting();
            if (this.cameraState != CameraState.RUNNING) {
                Logging.w(TAG, "stopCapture called for already stopped camera.");
                return;
            }
            this.postOnCameraThread(new Runnable(){

                @Override
                public void run() {
                    Logging.d(Camera2Capturer.TAG, "stopCaptureOnCameraThread");
                    Camera2Capturer.this.closeAndRelease();
                    cameraStoppingLatch.countDown();
                }
            });
        }
        ThreadUtils.awaitUninterruptibly(cameraStoppingLatch);
        Logging.d(TAG, "stopCapture done");
    }

    private void postOnCameraThread(Runnable runnable) {
        this.postDelayedOnCameraThread(0, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postDelayedOnCameraThread(int delayMs, Runnable runnable) {
        Object object = this.cameraStateLock;
        synchronized (object) {
            if (this.cameraState != CameraState.STARTING && this.cameraState != CameraState.RUNNING || !this.cameraThreadHandler.postAtTime(runnable, (Object)this, SystemClock.uptimeMillis() + (long)delayMs)) {
                Logging.w(TAG, "Runnable not scheduled even though it was requested.");
            }
        }
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.applicationContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        int rotation;
        this.checkIsOnCameraThread();
        if (this.cameraState != CameraState.RUNNING) {
            Logging.d(TAG, "Texture frame received while camera was not running.");
            return;
        }
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        if (this.isFrontCamera) {
            rotation = this.cameraOrientation + this.getDeviceOrientation();
            transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.horizontalFlipMatrix());
        } else {
            rotation = this.cameraOrientation - this.getDeviceOrientation();
        }
        rotation = (360 + rotation % 360) % 360;
        transformMatrix = RendererCommon.rotateTextureMatrix(transformMatrix, -this.cameraOrientation);
        this.cameraStatistics.addFrame();
        this.capturerObserver.onTextureFrameCaptured(this.captureFormat.width, this.captureFormat.height, oesTextureId, transformMatrix, rotation, timestampNs);
    }

    final class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        static final int MAX_CONSECUTIVE_CAMERA_CAPTURE_FAILURES = 10;
        int consecutiveCameraCaptureFailures;

        CameraCaptureCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            Camera2Capturer.this.checkIsOnCameraThread();
            ++this.consecutiveCameraCaptureFailures;
            if (this.consecutiveCameraCaptureFailures > 10) {
                Camera2Capturer.this.reportError("Capture failed " + this.consecutiveCameraCaptureFailures + " consecutive times.");
            }
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            Camera2Capturer.this.checkIsOnCameraThread();
            this.consecutiveCameraCaptureFailures = 0;
        }
    }

    final class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        CaptureSessionCallback() {
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            Camera2Capturer.this.checkIsOnCameraThread();
            Camera2Capturer.this.captureSession = session;
            Camera2Capturer.this.reportError("Failed to configure capture session.");
        }

        public void onConfigured(CameraCaptureSession session) {
            Camera2Capturer.this.checkIsOnCameraThread();
            Logging.d(Camera2Capturer.TAG, "Camera capture session configured.");
            Camera2Capturer.this.captureSession = session;
            try {
                CaptureRequest.Builder captureRequestBuilder = Camera2Capturer.this.cameraDevice.createCaptureRequest(3);
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Capturer)Camera2Capturer.this).captureFormat.framerate.min / Camera2Capturer.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Capturer)Camera2Capturer.this).captureFormat.framerate.max / Camera2Capturer.this.fpsUnitFactor)));
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                captureRequestBuilder.addTarget(Camera2Capturer.this.surface);
                session.setRepeatingRequest(captureRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)new CameraCaptureCallback(), Camera2Capturer.this.cameraThreadHandler);
            }
            catch (CameraAccessException e) {
                Camera2Capturer.this.reportError("Failed to start capture request. " + (Object)((Object)e));
                return;
            }
            Logging.d(Camera2Capturer.TAG, "Camera device successfully started.");
            Camera2Capturer.this.surfaceTextureHelper.startListening(Camera2Capturer.this);
            Camera2Capturer.this.capturerObserver.onCapturerStarted(true);
            Camera2Capturer.this.cameraStatistics = new CameraVideoCapturer.CameraStatistics(Camera2Capturer.this.surfaceTextureHelper, Camera2Capturer.this.eventsHandler);
            Camera2Capturer.this.setCameraState(CameraState.RUNNING);
            if (Camera2Capturer.this.switchEventsHandler != null) {
                Camera2Capturer.this.switchEventsHandler.onCameraSwitchDone(Camera2Capturer.this.isFrontCamera);
                Camera2Capturer.this.switchEventsHandler = null;
            }
            Camera2Capturer.this.isPendingCameraSwitch.set(false);
        }
    }

    final class CameraStateCallback
    extends CameraDevice.StateCallback {
        CameraStateCallback() {
        }

        private String getErrorDescription(int errorCode) {
            switch (errorCode) {
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
            }
            return "Unknown camera error: " + errorCode;
        }

        public void onDisconnected(CameraDevice camera) {
            Camera2Capturer.this.checkIsOnCameraThread();
            Camera2Capturer.this.cameraDevice = camera;
            Camera2Capturer.this.reportError("Camera disconnected.");
        }

        public void onError(CameraDevice camera, int errorCode) {
            Camera2Capturer.this.checkIsOnCameraThread();
            Camera2Capturer.this.cameraDevice = camera;
            if (Camera2Capturer.this.cameraState == CameraState.STARTING && (errorCode == 1 || errorCode == 2)) {
                Camera2Capturer.this.consecutiveCameraOpenFailures++;
                if (Camera2Capturer.this.consecutiveCameraOpenFailures < 3) {
                    Logging.w(Camera2Capturer.TAG, "Opening camera failed, trying again: " + this.getErrorDescription(errorCode));
                    Camera2Capturer.this.postDelayedOnCameraThread(500, new Runnable(){

                        @Override
                        public void run() {
                            Camera2Capturer.this.openCamera();
                        }
                    });
                    return;
                }
                Logging.e(Camera2Capturer.TAG, "Opening camera failed too many times. Passing the error.");
            }
            Camera2Capturer.this.reportError(this.getErrorDescription(errorCode));
        }

        public void onOpened(CameraDevice camera) {
            Camera2Capturer.this.checkIsOnCameraThread();
            Logging.d(Camera2Capturer.TAG, "Camera opened.");
            if (Camera2Capturer.this.cameraState != CameraState.STARTING) {
                throw new IllegalStateException("Unexpected state when camera opened: " + (Object)((Object)Camera2Capturer.this.cameraState));
            }
            Camera2Capturer.this.cameraDevice = camera;
            SurfaceTexture surfaceTexture = Camera2Capturer.this.surfaceTextureHelper.getSurfaceTexture();
            surfaceTexture.setDefaultBufferSize(((Camera2Capturer)Camera2Capturer.this).captureFormat.width, ((Camera2Capturer)Camera2Capturer.this).captureFormat.height);
            Camera2Capturer.this.surface = new Surface(surfaceTexture);
            try {
                camera.createCaptureSession(Arrays.asList(Camera2Capturer.this.surface), (CameraCaptureSession.StateCallback)new CaptureSessionCallback(), Camera2Capturer.this.cameraThreadHandler);
            }
            catch (CameraAccessException e) {
                Camera2Capturer.this.reportError("Failed to create capture session. " + (Object)((Object)e));
            }
        }

        public void onClosed(CameraDevice camera) {
            Camera2Capturer.this.checkIsOnCameraThread();
            Logging.d(Camera2Capturer.TAG, "Camera device closed.");
            if (Camera2Capturer.this.cameraState != CameraState.STOPPING) {
                Logging.e(Camera2Capturer.TAG, "Camera state was not STOPPING in onClosed. Most likely camera didn't stop within timelimit and this method was invoked twice.");
                return;
            }
            Camera2Capturer.this.cameraThreadHandler.removeCallbacksAndMessages(STOP_TIMEOUT_RUNNABLE_TOKEN);
            Camera2Capturer.this.setCameraState(CameraState.IDLE);
            if (Camera2Capturer.this.eventsHandler != null) {
                Camera2Capturer.this.eventsHandler.onCameraClosed();
            }
        }
    }

    private static enum CameraState {
        IDLE,
        STARTING,
        RUNNING,
        STOPPING;

    }
}

