/*
 * Decompiled with CFR 0.152.
 */
package org.appspot.apprtc.util;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public class LooperExecutor
extends Thread
implements Executor {
    private static final String TAG = "LooperExecutor";
    private final Object looperStartedEvent = new Object();
    private final List<Runnable> scheduledPeriodicRunnables = new LinkedList<Runnable>();
    private Handler handler = null;
    private boolean running = false;
    private long threadId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Object object = this.looperStartedEvent;
        synchronized (object) {
            Log.d((String)TAG, (String)"Looper thread started.");
            this.handler = new Handler();
            this.threadId = Thread.currentThread().getId();
            this.looperStartedEvent.notify();
        }
        Looper.loop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestStart() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.handler = null;
        this.start();
        Object object = this.looperStartedEvent;
        synchronized (object) {
            while (this.handler == null) {
                try {
                    this.looperStartedEvent.wait();
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"Can not start looper thread");
                    this.running = false;
                }
            }
        }
    }

    public synchronized void requestStop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LooperExecutor.this.handler.getLooper().quit();
                Log.d((String)LooperExecutor.TAG, (String)"Looper thread finished.");
            }
        });
    }

    public boolean checkOnLooperThread() {
        return Thread.currentThread().getId() == this.threadId;
    }

    public synchronized void scheduleAtFixedRate(final Runnable command, final long periodMillis) {
        if (!this.running) {
            Log.w((String)TAG, (String)"Trying to schedule task for non running executor");
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (LooperExecutor.this.running) {
                    command.run();
                    if (!LooperExecutor.this.handler.postDelayed((Runnable)this, periodMillis)) {
                        Log.e((String)LooperExecutor.TAG, (String)"Failed to post a delayed runnable in the chain.");
                    }
                }
            }
        };
        this.scheduledPeriodicRunnables.add(runnable);
        if (!this.handler.postDelayed(runnable, periodMillis)) {
            Log.e((String)TAG, (String)"Failed to post a delayed runnable.");
        }
    }

    public synchronized void cancelScheduledTasks() {
        if (!this.running) {
            Log.w((String)TAG, (String)"Trying to cancel schedule tasks for non running executor");
            return;
        }
        for (Runnable r : this.scheduledPeriodicRunnables) {
            this.handler.removeCallbacks(r);
        }
        this.scheduledPeriodicRunnables.clear();
    }

    @Override
    public synchronized void execute(Runnable runnable) {
        if (!this.running) {
            Log.w((String)TAG, (String)"Running looper executor without calling requestStart()");
            return;
        }
        if (Thread.currentThread().getId() == this.threadId) {
            runnable.run();
        } else {
            this.handler.post(runnable);
        }
    }

    Handler getHandler() {
        return this.handler;
    }
}

