/*
 * Decompiled with CFR 0.152.
 */
package org.appspot.apprtc.util;

import android.util.Log;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Scanner;

public class AsyncHttpURLConnection {
    private static final int HTTP_TIMEOUT_MS = 8000;
    private static final int MAX_RETRIES = 5;
    private final String method;
    private final String url;
    private final String message;
    private final AsyncHttpEvents events;
    private String contentType;

    public AsyncHttpURLConnection(String method, String url, String message, AsyncHttpEvents events) {
        this.method = method;
        this.url = url;
        this.message = message;
        this.events = events;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void send() {
        Runnable runHttp = new Runnable(){

            @Override
            public void run() {
                AsyncHttpURLConnection.this.sendHttpMessage(5);
            }
        };
        new Thread(runHttp).start();
    }

    private void sendHttpMessage(int attemptsLeft) {
        try {
            int responseCode;
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
            byte[] postData = new byte[]{};
            if (this.message != null) {
                postData = this.message.getBytes("UTF-8");
            }
            connection.setRequestMethod(this.method);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(8000);
            connection.setReadTimeout(8000);
            boolean doOutput = false;
            if (this.method.equals("POST")) {
                doOutput = true;
                connection.setDoOutput(true);
                connection.setFixedLengthStreamingMode(postData.length);
            }
            if (this.contentType == null) {
                connection.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
            } else {
                connection.setRequestProperty("Content-Type", this.contentType);
            }
            if (doOutput && postData.length > 0) {
                OutputStream outStream = connection.getOutputStream();
                outStream.write(postData);
                outStream.close();
            }
            if ((responseCode = connection.getResponseCode()) != 200) {
                this.events.onHttpError("Non-200 response to " + this.method + " to URL: " + this.url + " : " + connection.getHeaderField(null));
                connection.disconnect();
                return;
            }
            InputStream responseStream = connection.getInputStream();
            String response = AsyncHttpURLConnection.drainStream(responseStream);
            responseStream.close();
            connection.disconnect();
            this.events.onHttpComplete(response);
        }
        catch (SocketTimeoutException e) {
            this.events.onHttpError("HTTP " + this.method + " to " + this.url + " timeout");
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                if (--attemptsLeft == 0) {
                    this.events.onHttpError("HTTP " + this.method + " to " + this.url + " error: " + e.getMessage());
                } else {
                    Log.d((String)AsyncHttpURLConnection.class.getCanonicalName(), (String)("EOFException while HTTP " + this.method + " to " + this.url + ", retrying (" + attemptsLeft + " attempt(s) left)"));
                    this.sendHttpMessage(attemptsLeft);
                }
            }
            this.events.onHttpError("HTTP " + this.method + " to " + this.url + " error: " + e.getMessage());
            Log.e((String)AsyncHttpURLConnection.class.getCanonicalName(), (String)"", (Throwable)e);
        }
    }

    private static String drainStream(InputStream in) {
        Scanner s = new Scanner(in).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static interface AsyncHttpEvents {
        public void onHttpError(String var1);

        public void onHttpComplete(String var1);
    }
}

