/*
 * Decompiled with CFR 0.152.
 */
package org.appspot.apprtc;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.View;
import android.widget.ScrollView;
import android.widget.TextView;
import java.io.PrintWriter;
import java.io.StringWriter;

public class UnhandledExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "AppRTCDemoActivity";
    private final Activity activity;

    public UnhandledExceptionHandler(Activity activity) {
        this.activity = activity;
    }

    @Override
    public void uncaughtException(Thread unusedThread, final Throwable e) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String title = "Fatal error: " + UnhandledExceptionHandler.getTopLevelCauseMessage(e);
                String msg = UnhandledExceptionHandler.getRecursiveStackTrace(e);
                TextView errorView = new TextView((Context)UnhandledExceptionHandler.this.activity);
                errorView.setText((CharSequence)msg);
                errorView.setTextSize(2, 8.0f);
                ScrollView scrollingContainer = new ScrollView((Context)UnhandledExceptionHandler.this.activity);
                scrollingContainer.addView((View)errorView);
                Log.e((String)UnhandledExceptionHandler.TAG, (String)(title + "\n\n" + msg));
                DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        System.exit(1);
                    }
                };
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)UnhandledExceptionHandler.this.activity);
                builder.setTitle((CharSequence)title).setView((View)scrollingContainer).setPositiveButton((CharSequence)"Exit", listener).show();
            }
        });
    }

    private static String getTopLevelCauseMessage(Throwable t) {
        Throwable topLevelCause = t;
        while (topLevelCause.getCause() != null) {
            topLevelCause = topLevelCause.getCause();
        }
        return topLevelCause.getMessage();
    }

    private static String getRecursiveStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

