/*
 * Decompiled with CFR 0.152.
 */
package org.appspot.apprtc;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.appspot.apprtc.AppRTCClient;
import org.appspot.apprtc.util.AsyncHttpURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.SessionDescription;

public class RoomParametersFetcher {
    private static final String TAG = "RoomRTCClient";
    private static final int TURN_HTTP_TIMEOUT_MS = 5000;
    private final RoomParametersFetcherEvents events;
    private final String roomUrl;
    private final String roomMessage;
    private AsyncHttpURLConnection httpConnection;

    public RoomParametersFetcher(String roomUrl, String roomMessage, RoomParametersFetcherEvents events) {
        this.roomUrl = roomUrl;
        this.roomMessage = roomMessage;
        this.events = events;
    }

    public void makeRequest() {
        Log.d((String)TAG, (String)("Connecting to room: " + this.roomUrl));
        this.httpConnection = new AsyncHttpURLConnection("POST", this.roomUrl, this.roomMessage, new AsyncHttpURLConnection.AsyncHttpEvents(){

            @Override
            public void onHttpError(String errorMessage) {
                Log.e((String)RoomParametersFetcher.TAG, (String)("Room connection error: " + errorMessage));
                RoomParametersFetcher.this.events.onSignalingParametersError(errorMessage);
            }

            @Override
            public void onHttpComplete(String response) {
                RoomParametersFetcher.this.roomHttpResponseParse(response);
            }
        });
        this.httpConnection.send();
    }

    private void roomHttpResponseParse(String response) {
        Log.d((String)TAG, (String)("Room response: " + response));
        try {
            boolean initiator;
            LinkedList<IceCandidate> iceCandidates = null;
            SessionDescription offerSdp = null;
            JSONObject roomJson = new JSONObject(response);
            String result = roomJson.getString("result");
            if (!result.equals("SUCCESS")) {
                this.events.onSignalingParametersError("Room response error: " + result);
                return;
            }
            response = roomJson.getString("params");
            roomJson = new JSONObject(response);
            String roomId = roomJson.getString("room_id");
            String clientId = roomJson.getString("client_id");
            String wssUrl = roomJson.getString("wss_url");
            String wssPostUrl = roomJson.getString("wss_post_url");
            String turnTimeLimitedLTCURL = null;
            if (roomJson.has("turn_time_limited_ltc_url")) {
                turnTimeLimitedLTCURL = roomJson.getString("turn_time_limited_ltc_url");
            }
            if (!(initiator = roomJson.getBoolean("is_initiator"))) {
                iceCandidates = new LinkedList<IceCandidate>();
                String messagesString = roomJson.getString("messages");
                JSONArray messages = new JSONArray(messagesString);
                for (int i = 0; i < messages.length(); ++i) {
                    StringBuilder sb;
                    String messageSdp;
                    String messageString = messages.getString(i);
                    JSONObject message = new JSONObject(messageString);
                    String messageType = message.getString("type");
                    Log.d((String)TAG, (String)("GAE->C #" + i + " : " + messageString));
                    if (messageType.equals("offer")) {
                        messageSdp = message.getString("sdp");
                        String[] parts = messageSdp.split("\n");
                        Integer index = 0;
                        sb = new StringBuilder();
                        String[] stringArray = parts;
                        int n = stringArray.length;
                        for (int j = 0; j < n; ++j) {
                            String frase;
                            String newFrase = frase = stringArray[j];
                            if (frase.contains("ufrag")) {
                                newFrase = frase.replace(" ", "+");
                            }
                            if (frase.contains("ice-pwd")) {
                                newFrase = frase.replace(" ", "+");
                            }
                            sb.append(newFrase);
                            if (index != parts.length - 1) {
                                sb.append("\n");
                            }
                            Integer n2 = index;
                            Integer n3 = index = Integer.valueOf(index + 1);
                        }
                        offerSdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)messageType), sb.toString());
                        continue;
                    }
                    if (messageType.equals("candidate")) {
                        messageSdp = message.getString("candidate");
                        int len = messageSdp.length();
                        Boolean uFragFound = false;
                        sb = new StringBuilder();
                        Integer charactersUfrag = 0;
                        for (int index = 0; index < len; ++index) {
                            Character character = Character.valueOf(messageSdp.charAt(index));
                            if (!uFragFound.booleanValue()) {
                                Character characterPrevPrevPrev;
                                Character characterPrevPrev;
                                Character characterPrev;
                                if (index > 3 && character.charValue() == 'g' && (characterPrev = Character.valueOf(messageSdp.charAt(index - 1))).charValue() == 'a' && (characterPrevPrev = Character.valueOf(messageSdp.charAt(index - 2))).charValue() == 'r' && (characterPrevPrevPrev = Character.valueOf(messageSdp.charAt(index - 3))).charValue() == 'f') {
                                    uFragFound = true;
                                }
                                sb.append(character);
                                continue;
                            }
                            if (charactersUfrag == 0) {
                                sb.append(character);
                            } else if (charactersUfrag > 0 && charactersUfrag < 5) {
                                if (character.charValue() == ' ') {
                                    sb.append("+");
                                } else {
                                    sb.append(character);
                                }
                            } else {
                                sb.append(character);
                            }
                            Integer n = charactersUfrag;
                            Integer n4 = charactersUfrag = Integer.valueOf(charactersUfrag + 1);
                        }
                        IceCandidate candidate = new IceCandidate(message.getString("id"), message.getInt("label"), sb.toString());
                        iceCandidates.add(candidate);
                        continue;
                    }
                    Log.e((String)TAG, (String)("Unknown message: " + messageString));
                }
            }
            Log.d((String)TAG, (String)("RoomId: " + roomId + ". ClientId: " + clientId));
            Log.d((String)TAG, (String)("Initiator: " + initiator));
            Log.d((String)TAG, (String)("WSS url: " + wssUrl));
            Log.d((String)TAG, (String)("WSS POST url: " + wssPostUrl));
            List<PeerConnection.IceServer> iceServers = this.iceServersFromPCConfigJSON(roomJson.getString("pc_config"));
            boolean sigParamsOK = true;
            if (!this.checkTURNServers(iceServers)) {
                if (turnTimeLimitedLTCURL != null) {
                    Log.d((String)TAG, (String)("Request TURN credentials from: " + turnTimeLimitedLTCURL));
                    iceServers = this.getCredentialsForTURNServers(turnTimeLimitedLTCURL, iceServers);
                } else {
                    sigParamsOK = false;
                    this.events.onSignalingParametersError("No username nor password provided for TURN server(s)");
                }
            }
            if (sigParamsOK) {
                AppRTCClient.SignalingParameters params = new AppRTCClient.SignalingParameters(iceServers, initiator, clientId, wssUrl, wssPostUrl, offerSdp, iceCandidates);
                this.events.onSignalingParametersReady(params);
            }
        }
        catch (JSONException e) {
            this.events.onSignalingParametersError("Room JSON parsing error: " + e.toString());
        }
        catch (IOException e) {
            this.events.onSignalingParametersError("Room IO error: " + e.toString());
        }
    }

    private boolean checkTURNServers(List<PeerConnection.IceServer> iceServers) {
        boolean hasTURNServerWithCredentials = false;
        for (PeerConnection.IceServer iceServer : iceServers) {
            if (!"turn".equals(iceServer.uri.split(":")[0]) || iceServer.username == null || iceServer.username.length() <= 0 || iceServer.password == null || iceServer.password.length() <= 0) continue;
            hasTURNServerWithCredentials = true;
            break;
        }
        return hasTURNServerWithCredentials;
    }

    private List<PeerConnection.IceServer> getCredentialsForTURNServers(String timedLTCUrl, List<PeerConnection.IceServer> iceServers) throws IOException, JSONException {
        Log.d((String)TAG, (String)("Request TURN credentials from: " + timedLTCUrl));
        HttpURLConnection connection = (HttpURLConnection)new URL(timedLTCUrl).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        JSONObject paramJSON = new JSONObject();
        paramJSON.put("loginName", (Object)("user" + System.currentTimeMillis()));
        OutputStream os = connection.getOutputStream();
        os.write(paramJSON.toString().getBytes("UTF-8"));
        os.close();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Non-200 response when requesting TURN credentials from " + timedLTCUrl + " : " + connection.getHeaderField(null));
        }
        InputStream responseStream = connection.getInputStream();
        String response = RoomParametersFetcher.drainStream(responseStream);
        connection.disconnect();
        Log.d((String)TAG, (String)("TURN credentials response: " + response));
        JSONObject responseJSON = new JSONObject(response);
        String username = responseJSON.getString("username");
        String password = responseJSON.getString("credential");
        ArrayList<PeerConnection.IceServer> updatedICEServers = new ArrayList<PeerConnection.IceServer>(iceServers.size());
        for (PeerConnection.IceServer iceServer : iceServers) {
            if ("turn".equals(iceServer.uri.split(":")[0])) {
                updatedICEServers.add(new PeerConnection.IceServer(iceServer.uri, username, password));
                continue;
            }
            updatedICEServers.add(iceServer);
        }
        return updatedICEServers;
    }

    private LinkedList<PeerConnection.IceServer> requestTurnServers(String url) throws IOException, JSONException {
        LinkedList<PeerConnection.IceServer> turnServers = new LinkedList<PeerConnection.IceServer>();
        Log.d((String)TAG, (String)("Request TURN from: " + url));
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Non-200 response when requesting TURN server from " + url + " : " + connection.getHeaderField(null));
        }
        InputStream responseStream = connection.getInputStream();
        String response = RoomParametersFetcher.drainStream(responseStream);
        connection.disconnect();
        Log.d((String)TAG, (String)("TURN response: " + response));
        JSONObject responseJSON = new JSONObject(response);
        String username = responseJSON.getString("username");
        String password = responseJSON.getString("password");
        JSONArray turnUris = responseJSON.getJSONArray("uris");
        for (int i = 0; i < turnUris.length(); ++i) {
            String uri = turnUris.getString(i);
            turnServers.add(new PeerConnection.IceServer(uri, username, password));
        }
        return turnServers;
    }

    private LinkedList<PeerConnection.IceServer> iceServersFromPCConfigJSON(String pcConfig) throws JSONException {
        JSONObject json = new JSONObject(pcConfig);
        JSONArray servers = json.getJSONArray("iceServers");
        LinkedList<PeerConnection.IceServer> ret = new LinkedList<PeerConnection.IceServer>();
        for (int i = 0; i < servers.length(); ++i) {
            JSONObject server = servers.getJSONObject(i);
            String url = server.getString("urls");
            String user = server.has("username") ? server.getString("username") : "";
            String credential = server.has("credential") ? server.getString("credential") : "";
            ret.add(new PeerConnection.IceServer(url, user, credential));
        }
        return ret;
    }

    private static String drainStream(InputStream in) {
        Scanner s = new Scanner(in).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static interface RoomParametersFetcherEvents {
        public void onSignalingParametersReady(AppRTCClient.SignalingParameters var1);

        public void onSignalingParametersError(String var1);
    }
}

