/*
 * Decompiled with CFR 0.152.
 */
package net.i2cat.seg.webrtcat4.stats;

import net.i2cat.seg.webrtcat4.WebRTUtils;
import net.i2cat.seg.webrtcat4.stats.WebRTCAudioStats;
import net.i2cat.seg.webrtcat4.stats.WebRTCMediaStats;
import net.i2cat.seg.webrtcat4.stats.WebRTCVideoStats;
import org.json.JSONObject;

public class WebRTStats {
    private Long callStartTime;
    private String localConnectionType;
    private String localAddress;
    private String remoteConnectionType;
    private String remoteAddress;
    private String transportType;
    private WebRTCAudioStats inAudioStats;
    private WebRTCAudioStats outAudioStats;
    private WebRTCVideoStats inVideoStats;
    private WebRTCVideoStats outVideoStats;

    public Long getCallStartTime() {
        return this.callStartTime;
    }

    public void setCallStartTime(Long callStartTime) {
        this.callStartTime = callStartTime;
    }

    public String getTransportType() {
        return this.transportType;
    }

    public void setTransportType(String transportType) {
        this.transportType = transportType;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public WebRTCAudioStats getInAudioStats() {
        return this.inAudioStats;
    }

    public long getInAudioStatsBytes() {
        return this.inAudioStats != null ? this.inAudioStats.getBytes() : 0L;
    }

    public void setInAudioStats(WebRTCAudioStats inAudioStats) {
        this.inAudioStats = inAudioStats;
    }

    public WebRTCVideoStats getInVideoStats() {
        return this.inVideoStats;
    }

    public long getInVideoStatsBytes() {
        return this.inVideoStats != null ? this.inVideoStats.getBytes() : 0L;
    }

    public void setInVideoStats(WebRTCVideoStats inVideoStats) {
        this.inVideoStats = inVideoStats;
    }

    public String getLocalConnectionType() {
        return this.localConnectionType;
    }

    public void setLocalConnectionType(String localConnectionType) {
        this.localConnectionType = localConnectionType;
    }

    public WebRTCMediaStats getOutAudioStats() {
        return this.outAudioStats;
    }

    public long getOutAudioStatsBytes() {
        return this.outAudioStats != null ? this.outAudioStats.getBytes() : 0L;
    }

    public void setOutAudioStats(WebRTCAudioStats outAudioStats) {
        this.outAudioStats = outAudioStats;
    }

    public WebRTCVideoStats getOutVideoStats() {
        return this.outVideoStats;
    }

    public long getOutVideoStatsBytes() {
        return this.outVideoStats != null ? this.outVideoStats.getBytes() : 0L;
    }

    public void setOutVideoStats(WebRTCVideoStats outVideoStats) {
        this.outVideoStats = outVideoStats;
    }

    public long getTotalAudioBytes() {
        return this.getInAudioStatsBytes() + this.getOutAudioStatsBytes();
    }

    public long getTotalVideoBytes() {
        return this.getInVideoStatsBytes() + this.getOutVideoStatsBytes();
    }

    public String getRemoteConnectionType() {
        return this.remoteConnectionType;
    }

    public void setRemoteConnectionType(String remoteConnectionType) {
        this.remoteConnectionType = remoteConnectionType;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Long elapsedTimeMillis) {
        StringBuilder sb = new StringBuilder();
        sb.append("LOCAL : ").append(this.localAddress).append(" (").append(this.localConnectionType).append(" over ").append(this.transportType).append(")\n");
        sb.append("REMOTE: ").append(this.remoteAddress).append(" (").append(this.remoteConnectionType).append(" over ").append(this.transportType).append(")\n");
        if (this.inAudioStats != null) {
            sb.append(this.inAudioStats.toString(elapsedTimeMillis)).append("\n");
        }
        if (this.outAudioStats != null) {
            sb.append(this.outAudioStats.toString(elapsedTimeMillis)).append("\n");
        }
        if (this.inVideoStats != null) {
            sb.append(this.inVideoStats.toString(elapsedTimeMillis)).append("\n");
        }
        if (this.outVideoStats != null) {
            sb.append(this.outVideoStats.toString(elapsedTimeMillis)).append("\n");
        }
        return sb.toString();
    }

    public JSONObject toJSON() {
        JSONObject stats = new JSONObject();
        WebRTUtils.jsonPut(stats, "address", this.localAddress);
        WebRTUtils.jsonPut(stats, "transport", this.transportType);
        Long elapsedTimeMillis = null;
        if (this.callStartTime != null) {
            elapsedTimeMillis = System.currentTimeMillis() - this.callStartTime;
        }
        JSONObject audioStats = new JSONObject();
        if (this.inAudioStats != null) {
            WebRTUtils.jsonPut(audioStats, "in", this.inAudioStats.toJSON(elapsedTimeMillis));
        }
        if (this.outAudioStats != null) {
            WebRTUtils.jsonPut(audioStats, "out", this.outAudioStats.toJSON(elapsedTimeMillis));
        }
        WebRTUtils.jsonPut(stats, "audio", audioStats);
        JSONObject videoStats = new JSONObject();
        if (this.inVideoStats != null) {
            WebRTUtils.jsonPut(videoStats, "in", this.inVideoStats.toJSON(elapsedTimeMillis));
        }
        if (this.outVideoStats != null) {
            WebRTUtils.jsonPut(videoStats, "out", this.outVideoStats.toJSON(elapsedTimeMillis));
        }
        WebRTUtils.jsonPut(stats, "video", videoStats);
        return stats;
    }
}

