/*
 * Decompiled with CFR 0.152.
 */
package net.i2cat.seg.webrtcat4.stats;

import java.text.DecimalFormat;
import net.i2cat.seg.webrtcat4.WebRTUtils;
import org.json.JSONObject;

public class WebRTCMediaStats {
    private MediaType mediaType;
    private MediaDirection mediaDirection;
    private Long bytes;
    private String codec;
    private Long packetsLost;
    private Long packetsSentRecvd;

    protected WebRTCMediaStats(MediaType mediaType, MediaDirection mediaDirection) {
        this.mediaType = mediaType;
        this.mediaDirection = mediaDirection;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public Long getPacketsSentRecvd() {
        return this.packetsSentRecvd;
    }

    public void setPacketsSentRecvd(Long packetsSentRecvd) {
        this.packetsSentRecvd = packetsSentRecvd;
    }

    public Long getPacketsLost() {
        return this.packetsLost;
    }

    public void setPacketsLost(Long packetsLost) {
        this.packetsLost = packetsLost;
    }

    public Double getPacketLossRatio() {
        if (this.packetsLost == null || this.packetsSentRecvd == null) {
            return null;
        }
        if (this.packetsSentRecvd > 0L) {
            return (double)this.packetsLost.longValue() / (double)this.packetsSentRecvd.longValue();
        }
        return null;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Long elapsedTimeMillis) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mediaDirection == MediaDirection.INCOMING ? "IN" : "OUT").append(this.mediaType == MediaType.AUDIO ? " AUDIO" : " VIDEO").append(" (").append(this.codec).append("): ");
        if (elapsedTimeMillis != null) {
            sb.append(WebRTUtils.formatBitratePerSecond(this.bytes, (double)elapsedTimeMillis.longValue() / 1000.0));
        } else {
            sb.append(this.bytes).append(" bytes");
        }
        String pktLossStr = "???";
        Double packetLoss = this.getPacketLossRatio();
        if (packetLoss != null) {
            pktLossStr = new DecimalFormat("##0.00").format(packetLoss * 100.0) + "%";
        }
        sb.append(" (pkt loss: ").append(pktLossStr).append(")");
        return sb.toString();
    }

    public JSONObject toJSON(Long elapsedTimeMillis) {
        JSONObject json = new JSONObject();
        WebRTUtils.jsonPut(json, "bytes", this.bytes);
        WebRTUtils.jsonPut(json, "formattedBytes", WebRTUtils.formatBytes(this.bytes.longValue()));
        WebRTUtils.jsonPut(json, "codec", this.codec);
        if (elapsedTimeMillis != null) {
            WebRTUtils.jsonPut(json, "avgBitrate", WebRTUtils.formatBitratePerSecond(this.bytes, (double)elapsedTimeMillis.longValue() / 1000.0));
        }
        if (this.packetsLost != null) {
            WebRTUtils.jsonPut(json, "packetsLost", this.packetsLost);
        }
        if (this.packetsSentRecvd != null) {
            WebRTUtils.jsonPut(json, this.mediaDirection == MediaDirection.INCOMING ? "packetsRecvd" : "packetsSent", this.packetsSentRecvd);
        }
        return json;
    }

    public static enum MediaDirection {
        INCOMING,
        OUTGOING;

    }

    public static enum MediaType {
        AUDIO,
        VIDEO;

    }
}

