/*
 * Decompiled with CFR 0.152.
 */
package net.i2cat.seg.webrtcat4;

import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class WebRTUtils {
    private static int BITS_IN_BYTE = 8;
    private static long KB = 1024L;
    private static long KBITS = KB * (long)BITS_IN_BYTE;
    private static long MB = 1024L * KB;
    private static long MBITS = MB * (long)BITS_IN_BYTE;
    private static long GB = 1024L * MB;
    private static long GBITS = GB * (long)BITS_IN_BYTE;

    public static String formatBytes(double bytes) {
        DecimalFormat df = new DecimalFormat("#.###");
        if (bytes > (double)GB) {
            return df.format(bytes / (double)GB) + " GB";
        }
        if (bytes > (double)MB) {
            return df.format(bytes / (double)MB) + " MB";
        }
        if (bytes > (double)KB) {
            return df.format(bytes / (double)KB) + " KB";
        }
        return df.format(bytes) + " bytes";
    }

    public static String formatBitratePerSecond(long totalBytes, double durationInSecs) {
        if (durationInSecs > 0.0) {
            double bitrate = (double)(totalBytes * (long)BITS_IN_BYTE) / durationInSecs;
            DecimalFormat df = new DecimalFormat("#.##");
            if (bitrate > (double)GBITS) {
                return df.format(bitrate / (double)GBITS) + " Gbps";
            }
            if (bitrate > (double)MBITS) {
                return df.format(bitrate / (double)MBITS) + " Mbps";
            }
            if (bitrate > (double)KBITS) {
                return df.format(bitrate / (double)KBITS) + " Kbps";
            }
            return df.format(totalBytes) + " bps";
        }
        return "0.0 Kbps";
    }

    public static void jsonPut(JSONObject json, String key, Object value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

