/*
 * Decompiled with CFR 0.152.
 */
package net.i2cat.seg.webrtcat4;

import android.util.Log;
import de.tavendo.autobahn.WebSocket;
import de.tavendo.autobahn.WebSocketConnection;
import de.tavendo.autobahn.WebSocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import net.i2cat.seg.webrtcat4.WebRTCatErrorCode;
import org.appspot.apprtc.util.AsyncHttpURLConnection;
import org.appspot.apprtc.util.LooperExecutor;
import org.json.JSONException;
import org.json.JSONObject;

public class WebRTCatSocketChannelClient {
    private static final String TAG = "WebRTCatSockClient";
    private static final int CLOSE_TIMEOUT = 1000;
    private final WebSocketChannelEvents events;
    private final LooperExecutor executor;
    private WebSocketConnection ws;
    private WebSocketObserver wsObserver;
    private String wsServerUrl;
    private String postServerUrl;
    private String roomID;
    private String clientID;
    private WebSocketConnectionState state;
    private final Object closeEventLock = new Object();
    private boolean closeEvent;
    private final LinkedList<String> wsSendQueue;

    public WebRTCatSocketChannelClient(LooperExecutor executor, WebSocketChannelEvents events) {
        this.executor = executor;
        this.events = events;
        this.roomID = null;
        this.clientID = null;
        this.wsSendQueue = new LinkedList();
        this.state = WebSocketConnectionState.NEW;
    }

    public WebSocketConnectionState getState() {
        return this.state;
    }

    public void connect(String wsUrl, String postUrl) {
        this.checkIfCalledOnValidThread();
        if (this.state != WebSocketConnectionState.NEW) {
            Log.e((String)TAG, (String)"WebSocket is already connected.");
            return;
        }
        this.wsServerUrl = wsUrl;
        this.postServerUrl = postUrl;
        this.closeEvent = false;
        Log.d((String)TAG, (String)("Connecting WebSocket to: " + wsUrl + ". Post URL: " + postUrl));
        this.ws = new WebSocketConnection();
        this.wsObserver = new WebSocketObserver();
        try {
            this.ws.connect(new URI(this.wsServerUrl), (WebSocket.WebSocketConnectionObserver)this.wsObserver);
        }
        catch (URISyntaxException e) {
            this.reportError("URI error: " + e.getMessage(), WebRTCatErrorCode.CANT_CONNECT_TO_SIGNALING_SERVER);
        }
        catch (WebSocketException e) {
            this.reportError("WebSocket connection error: " + e.getMessage(), WebRTCatErrorCode.CANT_CONNECT_TO_SIGNALING_SERVER);
        }
    }

    public void register(String roomID, String clientID) {
        this.checkIfCalledOnValidThread();
        this.roomID = roomID;
        this.clientID = clientID;
        if (this.state != WebSocketConnectionState.CONNECTED) {
            Log.w((String)TAG, (String)("WebSocket register() in state " + (Object)((Object)this.state)));
            return;
        }
        Log.d((String)TAG, (String)("Registering WebSocket for room " + roomID + ". CLientID: " + clientID));
        JSONObject json = new JSONObject();
        try {
            json.put("cmd", (Object)"register");
            json.put("roomid", (Object)roomID);
            json.put("clientid", (Object)clientID);
            Log.d((String)TAG, (String)("C->WSS: " + json.toString()));
            this.ws.sendTextMessage(json.toString());
            this.state = WebSocketConnectionState.REGISTERED;
            for (String sendMessage : this.wsSendQueue) {
                this.send(sendMessage);
            }
            this.wsSendQueue.clear();
            this.events.onWebSocketRegistered();
        }
        catch (JSONException e) {
            this.reportError("WebSocket register JSON error: " + e.getMessage(), WebRTCatErrorCode.CANT_CONNECT_TO_SIGNALING_SERVER);
        }
    }

    public void send(String message) {
        this.checkIfCalledOnValidThread();
        switch (this.state) {
            case NEW: 
            case CONNECTED: {
                Log.d((String)TAG, (String)("WS ACC: " + message));
                this.wsSendQueue.add(message);
                return;
            }
            case ERROR: 
            case CLOSED: {
                Log.e((String)TAG, (String)("WebSocket send() in error or closed state : " + message));
                return;
            }
            case REGISTERED: {
                JSONObject json = new JSONObject();
                try {
                    json.put("cmd", (Object)"send");
                    json.put("msg", (Object)message);
                    message = json.toString();
                    Log.d((String)TAG, (String)("C->WSS: " + message));
                    this.ws.sendTextMessage(message);
                    break;
                }
                catch (JSONException e) {
                    this.reportError("WebSocket send JSON error: " + e.getMessage(), WebRTCatErrorCode.CANT_MESSAGE_ROOM);
                }
            }
        }
    }

    public void post(String message) {
        this.checkIfCalledOnValidThread();
        this.sendWSSMessage("POST", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean waitForComplete) {
        this.checkIfCalledOnValidThread();
        Log.d((String)TAG, (String)("Disonnect WebSocket. State: " + (Object)((Object)this.state)));
        if (this.state == WebSocketConnectionState.REGISTERED) {
            this.send("{\"type\": \"bye\"}");
            this.state = WebSocketConnectionState.CONNECTED;
            this.sendWSSMessage("DELETE", "");
        }
        if (this.state == WebSocketConnectionState.CONNECTED || this.state == WebSocketConnectionState.ERROR) {
            this.ws.disconnect();
            this.state = WebSocketConnectionState.CLOSED;
            if (waitForComplete) {
                Object object = this.closeEventLock;
                synchronized (object) {
                    while (!this.closeEvent) {
                        try {
                            this.closeEventLock.wait(1000L);
                            break;
                        }
                        catch (InterruptedException e) {
                            Log.e((String)TAG, (String)("Wait error: " + e.toString()));
                        }
                    }
                }
            }
        }
        Log.d((String)TAG, (String)"Disonnecting WebSocket done.");
    }

    private void reportError(final String errorMessage, final WebRTCatErrorCode errorCode) {
        Log.e((String)TAG, (String)errorMessage);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatSocketChannelClient.this.state != WebSocketConnectionState.ERROR) {
                    WebRTCatSocketChannelClient.this.state = WebSocketConnectionState.ERROR;
                    WebRTCatSocketChannelClient.this.events.onWebSocketError(errorMessage, errorCode);
                }
            }
        });
    }

    private void sendWSSMessage(final String method, String message) {
        String postUrl = this.postServerUrl + "/" + this.roomID + "/" + this.clientID;
        Log.d((String)TAG, (String)("WS " + method + " : " + postUrl + " : " + message));
        AsyncHttpURLConnection httpConnection = new AsyncHttpURLConnection(method, postUrl, message, new AsyncHttpURLConnection.AsyncHttpEvents(){

            @Override
            public void onHttpError(String errorMessage) {
                WebRTCatSocketChannelClient.this.reportError("WS " + method + " error: " + errorMessage, WebRTCatErrorCode.CANT_CONNECT_TO_SIGNALING_SERVER);
            }

            @Override
            public void onHttpComplete(String response) {
            }
        });
        httpConnection.send();
    }

    private void checkIfCalledOnValidThread() {
        if (!this.executor.checkOnLooperThread()) {
            throw new IllegalStateException("WebSocket method is not called on valid thread");
        }
    }

    private class WebSocketObserver
    implements WebSocket.WebSocketConnectionObserver {
        private WebSocketObserver() {
        }

        public void onOpen() {
            Log.d((String)WebRTCatSocketChannelClient.TAG, (String)("WebSocket connection opened to: " + WebRTCatSocketChannelClient.this.wsServerUrl));
            WebRTCatSocketChannelClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    WebRTCatSocketChannelClient.this.state = WebSocketConnectionState.CONNECTED;
                    WebRTCatSocketChannelClient.this.events.onWebSocketOpen();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(final WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification code, final String reason) {
            Log.d((String)WebRTCatSocketChannelClient.TAG, (String)("WebSocket connection closed. Code: " + code + ". Reason: " + reason + ". State: " + (Object)((Object)WebRTCatSocketChannelClient.this.state)));
            Object object = WebRTCatSocketChannelClient.this.closeEventLock;
            synchronized (object) {
                WebRTCatSocketChannelClient.this.closeEvent = true;
                WebRTCatSocketChannelClient.this.closeEventLock.notify();
            }
            WebRTCatSocketChannelClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (WebRTCatSocketChannelClient.this.state != WebSocketConnectionState.CLOSED) {
                        WebRTCatSocketChannelClient.this.state = WebSocketConnectionState.CLOSED;
                        if (code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT) {
                            WebRTCatSocketChannelClient.this.events.onWebSocketError(reason, WebRTCatErrorCode.CANT_CONNECT_TO_SIGNALING_SERVER);
                        } else if (code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CONNECTION_LOST) {
                            WebRTCatSocketChannelClient.this.events.onWebSocketError(reason, WebRTCatErrorCode.SIGNALING_SERVER_CONNECTION_CLOSED);
                        } else if (code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.INTERNAL_ERROR || code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.PROTOCOL_ERROR || code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.SERVER_ERROR) {
                            WebRTCatSocketChannelClient.this.events.onWebSocketError(reason, WebRTCatErrorCode.SIGNALING_SERVER_CONNECTION_ERROR);
                        } else {
                            WebRTCatSocketChannelClient.this.events.onWebSocketClose();
                        }
                    }
                }
            });
        }

        public void onTextMessage(String payload) {
            Log.d((String)WebRTCatSocketChannelClient.TAG, (String)("WSS->C: " + payload));
            final String message = payload;
            WebRTCatSocketChannelClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)WebRTCatSocketChannelClient.TAG, (String)("WSS->C: " + message + " state: " + (Object)((Object)WebRTCatSocketChannelClient.this.state)));
                    WebRTCatSocketChannelClient.this.events.onWebSocketMessage(message);
                }
            });
        }

        public void onRawTextMessage(byte[] payload) {
        }

        public void onBinaryMessage(byte[] payload) {
        }
    }

    public static interface WebSocketChannelEvents {
        public void onWebSocketOpen();

        public void onWebSocketRegistered();

        public void onWebSocketMessage(String var1);

        public void onWebSocketClose();

        public void onWebSocketError(String var1, WebRTCatErrorCode var2);
    }

    public static enum WebSocketConnectionState {
        NEW,
        CONNECTED,
        REGISTERED,
        CLOSED,
        ERROR;

    }
}

