/*
 * Decompiled with CFR 0.152.
 */
package net.i2cat.seg.webrtcat4;

import android.content.Context;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appspot.apprtc.AppRTCClient;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.DataChannel;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.StatsObserver;
import org.webrtc.StatsReport;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.voiceengine.WebRtcAudioManager;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class WebRTCatPeerConnectionClient {
    public static final String VIDEO_TRACK_ID = "ARDAMSv0";
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    private static final String TAG = "PCRTCClient";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String MAX_VIDEO_WIDTH_CONSTRAINT = "maxWidth";
    private static final String MIN_VIDEO_WIDTH_CONSTRAINT = "minWidth";
    private static final String MAX_VIDEO_HEIGHT_CONSTRAINT = "maxHeight";
    private static final String MIN_VIDEO_HEIGHT_CONSTRAINT = "minHeight";
    private static final String MAX_VIDEO_FPS_CONSTRAINT = "maxFrameRate";
    private static final String MIN_VIDEO_FPS_CONSTRAINT = "minFrameRate";
    private static final String AUDIO_LEVEL_CONTROL_CONSTRAINT = "levelControl";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int HD_VIDEO_WIDTH = 1280;
    private static final int HD_VIDEO_HEIGHT = 720;
    private static final int MAX_VIDEO_WIDTH = 1280;
    private static final int MAX_VIDEO_HEIGHT = 1280;
    private static final int MAX_VIDEO_FPS = 30;
    private static final WebRTCatPeerConnectionClient instance = new WebRTCatPeerConnectionClient();
    private final PCObserver pcObserver = new PCObserver();
    private final SDPObserver sdpObserver = new SDPObserver();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private Context context;
    private PeerConnectionFactory factory;
    private PeerConnection peerConnection;
    PeerConnectionFactory.Options options = null;
    private AudioSource audioSource;
    private VideoSource videoSource;
    private boolean videoCallEnabled;
    private boolean preferIsac;
    private String preferredVideoCodec;
    private boolean videoCapturerStopped;
    private boolean isError;
    private Timer statsTimer;
    private VideoRenderer.Callbacks localRender;
    private VideoRenderer.Callbacks remoteRender;
    private AppRTCClient.SignalingParameters signalingParameters;
    private MediaConstraints pcConstraints;
    private int videoWidth;
    private int videoHeight;
    private int videoFps;
    private MediaConstraints audioConstraints;
    private ParcelFileDescriptor aecDumpFileDescriptor;
    private MediaConstraints sdpMediaConstraints;
    private PeerConnectionParameters peerConnectionParameters;
    private LinkedList<IceCandidate> queuedRemoteCandidates;
    private PeerConnectionEvents events;
    private boolean isInitiator;
    private SessionDescription localSdp;
    private MediaStream mediaStream;
    private int numberOfCameras;
    private CameraVideoCapturer videoCapturer;
    private boolean renderVideo;
    private VideoTrack localVideoTrack;
    private VideoTrack remoteVideoTrack;
    private boolean enableAudio;
    private AudioTrack localAudioTrack;

    private WebRTCatPeerConnectionClient() {
    }

    public static WebRTCatPeerConnectionClient getInstance() {
        return instance;
    }

    public void setPeerConnectionFactoryOptions(PeerConnectionFactory.Options options) {
        this.options = options;
    }

    public void createPeerConnectionFactory(final Context context, PeerConnectionParameters peerConnectionParameters, PeerConnectionEvents events) {
        this.context = null;
        this.peerConnectionParameters = peerConnectionParameters;
        this.events = events;
        this.videoCallEnabled = peerConnectionParameters.videoCallEnabled;
        this.factory = null;
        this.peerConnection = null;
        this.preferIsac = false;
        this.videoCapturerStopped = false;
        this.isError = false;
        this.queuedRemoteCandidates = null;
        this.localSdp = null;
        this.mediaStream = null;
        this.videoCapturer = null;
        this.renderVideo = true;
        this.localVideoTrack = null;
        this.remoteVideoTrack = null;
        this.enableAudio = true;
        this.localAudioTrack = null;
        this.statsTimer = new Timer();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatPeerConnectionClient.this.createPeerConnectionFactoryInternal(context);
            }
        });
    }

    public void createPeerConnection(final EglBase.Context renderEGLContext, VideoRenderer.Callbacks localRender, VideoRenderer.Callbacks remoteRender, AppRTCClient.SignalingParameters signalingParameters) {
        if (this.peerConnectionParameters == null) {
            Log.e((String)TAG, (String)"Creating peer connection without initializing factory.");
            return;
        }
        this.localRender = localRender;
        this.remoteRender = remoteRender;
        this.signalingParameters = signalingParameters;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WebRTCatPeerConnectionClient.this.createMediaConstraintsInternal();
                    WebRTCatPeerConnectionClient.this.createPeerConnectionInternal(renderEGLContext);
                }
                catch (Exception e) {
                    WebRTCatPeerConnectionClient.this.reportError("Failed to create peer connection: " + e.getMessage());
                    throw e;
                }
            }
        });
    }

    public void close() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatPeerConnectionClient.this.closeInternal();
            }
        });
    }

    public boolean isVideoCallEnabled() {
        return this.videoCallEnabled;
    }

    private void createPeerConnectionFactoryInternal(Context context) {
        PeerConnectionFactory.initializeInternalTracer();
        if (this.peerConnectionParameters.tracing) {
            PeerConnectionFactory.startInternalTracingCapture((String)(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "webrtc-trace.txt"));
        }
        Log.d((String)TAG, (String)("Create peer connection factory. Use video: " + this.peerConnectionParameters.videoCallEnabled));
        this.isError = false;
        PeerConnectionFactory.initializeFieldTrials((String)"");
        this.preferredVideoCodec = VIDEO_CODEC_VP8;
        if (this.videoCallEnabled && this.peerConnectionParameters.videoCodec != null) {
            if (this.peerConnectionParameters.videoCodec.equals(VIDEO_CODEC_VP9)) {
                this.preferredVideoCodec = VIDEO_CODEC_VP9;
            } else if (this.peerConnectionParameters.videoCodec.equals(VIDEO_CODEC_H264)) {
                this.preferredVideoCodec = VIDEO_CODEC_H264;
            }
        }
        Log.d((String)TAG, (String)("Pereferred video codec: " + this.preferredVideoCodec));
        boolean bl = this.preferIsac = this.peerConnectionParameters.audioCodec != null && this.peerConnectionParameters.audioCodec.equals(AUDIO_CODEC_ISAC);
        if (!this.peerConnectionParameters.useOpenSLES) {
            Log.d((String)TAG, (String)"Disable OpenSL ES audio even if device supports it");
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)true);
        } else {
            Log.d((String)TAG, (String)"Allow OpenSL ES audio if device supports it");
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInAEC) {
            Log.d((String)TAG, (String)"Disable built-in AEC even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)true);
        } else {
            Log.d((String)TAG, (String)"Enable built-in AEC if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInAGC) {
            Log.d((String)TAG, (String)"Disable built-in AGC even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAutomaticGainControl((boolean)true);
        } else {
            Log.d((String)TAG, (String)"Enable built-in AGC if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAutomaticGainControl((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInNS) {
            Log.d((String)TAG, (String)"Disable built-in NS even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)true);
        } else {
            Log.d((String)TAG, (String)"Enable built-in NS if device supports it");
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)false);
        }
        if (!PeerConnectionFactory.initializeAndroidGlobals((Object)context, (boolean)true, (boolean)true, (boolean)this.peerConnectionParameters.videoCodecHwAcceleration)) {
            this.events.onPeerConnectionError("Failed to initializeAndroidGlobals");
        }
        if (this.options != null) {
            Log.d((String)TAG, (String)("Factory networkIgnoreMask option: " + this.options.networkIgnoreMask));
        }
        this.context = context;
        this.factory = new PeerConnectionFactory(this.options);
        Log.d((String)TAG, (String)"Peer connection factory created.");
    }

    private void createMediaConstraintsInternal() {
        this.pcConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.loopback) {
            this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "false"));
        } else {
            this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
        }
        this.numberOfCameras = CameraEnumerationAndroid.getDeviceCount();
        if (this.numberOfCameras == 0) {
            Log.w((String)TAG, (String)"No camera on device. Switch to audio only call.");
            this.videoCallEnabled = false;
        }
        if (this.videoCallEnabled) {
            this.videoWidth = this.peerConnectionParameters.videoWidth;
            this.videoHeight = this.peerConnectionParameters.videoHeight;
            this.videoFps = this.peerConnectionParameters.videoFps;
            if (this.videoWidth == 0 || this.videoHeight == 0) {
                this.videoWidth = 1280;
                this.videoHeight = 720;
            }
            if (this.videoFps == 0) {
                this.videoFps = 30;
            }
            this.videoWidth = Math.min(this.videoWidth, 1280);
            this.videoHeight = Math.min(this.videoHeight, 1280);
            this.videoFps = Math.min(this.videoFps, 30);
        }
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            Log.d((String)TAG, (String)"Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        if (this.peerConnectionParameters.enableLevelControl) {
            Log.d((String)TAG, (String)"Enabling level control.");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_LEVEL_CONTROL_CONSTRAINT, "true"));
        }
        this.sdpMediaConstraints = new MediaConstraints();
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        if (this.videoCallEnabled || this.peerConnectionParameters.loopback) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
        }
    }

    private void createCapturer(CameraEnumerator enumerator) {
        String[] deviceNames = enumerator.getDeviceNames();
        Logging.d((String)TAG, (String)"Looking for front facing cameras.");
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) continue;
            Logging.d((String)TAG, (String)"Creating front facing camera capturer.");
            this.videoCapturer = enumerator.createCapturer(deviceName, null);
            if (this.videoCapturer == null) continue;
            return;
        }
        Logging.d((String)TAG, (String)"Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) continue;
            Logging.d((String)TAG, (String)"Creating other camera capturer.");
            this.videoCapturer = enumerator.createCapturer(deviceName, null);
            if (this.videoCapturer == null) continue;
            return;
        }
    }

    private void createPeerConnectionInternal(EglBase.Context renderEGLContext) {
        if (this.factory == null || this.isError) {
            Log.e((String)TAG, (String)"Peerconnection factory is not created");
            return;
        }
        Log.d((String)TAG, (String)"Create peer connection.");
        Log.d((String)TAG, (String)("PCConstraints: " + this.pcConstraints.toString()));
        this.queuedRemoteCandidates = new LinkedList();
        if (this.videoCallEnabled) {
            Log.d((String)TAG, (String)("EGLContext: " + renderEGLContext));
            this.factory.setVideoHwAccelerationOptions(renderEGLContext, renderEGLContext);
        }
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.signalingParameters.iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        this.peerConnection = this.factory.createPeerConnection(rtcConfig, this.pcConstraints, (PeerConnection.Observer)this.pcObserver);
        this.isInitiator = false;
        Logging.enableTracing((String)"logcat:", EnumSet.of(Logging.TraceLevel.TRACE_DEFAULT));
        Logging.enableLogToDebugOutput((Logging.Severity)Logging.Severity.LS_INFO);
        if (this.peerConnectionParameters.aecDump) {
            try {
                this.aecDumpFileDescriptor = ParcelFileDescriptor.open((File)new File(Environment.getExternalStorageDirectory().getPath() + File.separator + "Download/audio.aecdump"), (int)0x3C000000);
                this.factory.startAecDump(this.aecDumpFileDescriptor.getFd(), -1);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Can not open aecdump file", (Throwable)e);
            }
        }
        Log.d((String)TAG, (String)"Peer connection created.");
    }

    public void setVideoRenderers(VideoRenderer.Callbacks localRender, VideoRenderer.Callbacks remoteRender) {
        this.localRender = localRender;
        this.remoteRender = remoteRender;
        if (this.remoteVideoTrack != null) {
            this.remoteVideoTrack.addRenderer(new VideoRenderer(remoteRender));
        }
    }

    public void addLocalMediaStream(EglBase.Context renderEGLContext) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatPeerConnectionClient.this.mediaStream = WebRTCatPeerConnectionClient.this.factory.createLocalMediaStream("ARDAMS");
                if (WebRTCatPeerConnectionClient.this.videoCallEnabled) {
                    if (((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.useCamera2) {
                        if (!((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.captureToTexture) {
                            WebRTCatPeerConnectionClient.this.reportError("Camera2 only supports capturing to texture. Either disable Camera2 or enable capturing to texture in the options.");
                            return;
                        }
                        Logging.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Creating capturer using camera2 API.");
                        WebRTCatPeerConnectionClient.this.createCapturer((CameraEnumerator)new Camera2Enumerator(WebRTCatPeerConnectionClient.this.context));
                    } else {
                        Logging.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Creating capturer using camera1 API.");
                        WebRTCatPeerConnectionClient.this.createCapturer((CameraEnumerator)new Camera1Enumerator(((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.captureToTexture));
                    }
                    if (WebRTCatPeerConnectionClient.this.videoCapturer == null) {
                        WebRTCatPeerConnectionClient.this.reportError("Failed to open camera");
                        return;
                    }
                    WebRTCatPeerConnectionClient.this.mediaStream.addTrack(WebRTCatPeerConnectionClient.this.createVideoTrack((VideoCapturer)WebRTCatPeerConnectionClient.this.videoCapturer));
                }
                WebRTCatPeerConnectionClient.this.mediaStream.addTrack(WebRTCatPeerConnectionClient.this.createAudioTrack());
                WebRTCatPeerConnectionClient.this.peerConnection.addStream(WebRTCatPeerConnectionClient.this.mediaStream);
            }
        });
    }

    private void closeInternal() {
        if (this.factory != null && this.peerConnectionParameters.aecDump) {
            this.factory.stopAecDump();
        }
        Log.d((String)TAG, (String)"Closing peer connection.");
        this.statsTimer.cancel();
        if (this.peerConnection != null) {
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        Log.d((String)TAG, (String)"Closing audio source.");
        if (this.audioSource != null) {
            this.audioSource.dispose();
            this.audioSource = null;
        }
        Log.d((String)TAG, (String)"Stopping capture.");
        if (this.videoCapturer != null) {
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.videoCapturer.dispose();
            this.videoCapturer = null;
        }
        Log.d((String)TAG, (String)"Closing video source.");
        if (this.videoSource != null) {
            this.videoSource.dispose();
            this.videoSource = null;
        }
        Log.d((String)TAG, (String)"Closing peer connection factory.");
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        this.options = null;
        Log.d((String)TAG, (String)"Closing peer connection done.");
        this.events.onPeerConnectionClosed();
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
    }

    public boolean isHDVideo() {
        if (!this.videoCallEnabled) {
            return false;
        }
        return this.videoWidth * this.videoHeight >= 921600;
    }

    private void getStats() {
        if (this.peerConnection == null || this.isError) {
            return;
        }
        boolean success = this.peerConnection.getStats(new StatsObserver(){

            public void onComplete(StatsReport[] reports) {
                WebRTCatPeerConnectionClient.this.events.onPeerConnectionStatsReady(reports);
            }
        }, null);
        if (!success) {
            Log.e((String)TAG, (String)"getStats() returns false!");
        }
    }

    public void enableStatsEvents(boolean enable, int periodMs) {
        if (enable) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                WebRTCatPeerConnectionClient.this.getStats();
                            }
                        });
                    }
                }, 0L, (long)periodMs);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Can not schedule statistics timer", (Throwable)e);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public void setAudioEnabled(final boolean enable) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatPeerConnectionClient.this.enableAudio = enable;
                if (WebRTCatPeerConnectionClient.this.localAudioTrack != null) {
                    WebRTCatPeerConnectionClient.this.localAudioTrack.setEnabled(WebRTCatPeerConnectionClient.this.enableAudio);
                }
            }
        });
    }

    public void setVideoEnabled(final boolean enable) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatPeerConnectionClient.this.renderVideo = enable;
                if (WebRTCatPeerConnectionClient.this.localVideoTrack != null) {
                    WebRTCatPeerConnectionClient.this.localVideoTrack.setEnabled(WebRTCatPeerConnectionClient.this.renderVideo);
                }
                if (WebRTCatPeerConnectionClient.this.remoteVideoTrack != null) {
                    WebRTCatPeerConnectionClient.this.remoteVideoTrack.setEnabled(WebRTCatPeerConnectionClient.this.renderVideo);
                }
            }
        });
    }

    public void createOffer() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatPeerConnectionClient.this.peerConnection != null && !WebRTCatPeerConnectionClient.this.isError) {
                    Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"PC Create OFFER");
                    WebRTCatPeerConnectionClient.this.isInitiator = true;
                    WebRTCatPeerConnectionClient.this.peerConnection.createOffer((SdpObserver)WebRTCatPeerConnectionClient.this.sdpObserver, WebRTCatPeerConnectionClient.this.sdpMediaConstraints);
                }
            }
        });
    }

    public void createAnswer() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatPeerConnectionClient.this.peerConnection != null && !WebRTCatPeerConnectionClient.this.isError) {
                    Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"PC create ANSWER");
                    WebRTCatPeerConnectionClient.this.isInitiator = false;
                    WebRTCatPeerConnectionClient.this.peerConnection.createAnswer((SdpObserver)WebRTCatPeerConnectionClient.this.sdpObserver, WebRTCatPeerConnectionClient.this.sdpMediaConstraints);
                }
            }
        });
    }

    public void addRemoteIceCandidate(final IceCandidate candidate) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatPeerConnectionClient.this.peerConnection != null && !WebRTCatPeerConnectionClient.this.isError) {
                    if (WebRTCatPeerConnectionClient.this.queuedRemoteCandidates != null) {
                        WebRTCatPeerConnectionClient.this.queuedRemoteCandidates.add(candidate);
                    } else {
                        WebRTCatPeerConnectionClient.this.peerConnection.addIceCandidate(candidate);
                    }
                }
            }
        });
    }

    public void removeRemoteIceCandidates(final IceCandidate[] candidates) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatPeerConnectionClient.this.peerConnection == null || WebRTCatPeerConnectionClient.this.isError) {
                    return;
                }
                WebRTCatPeerConnectionClient.this.drainCandidates();
                WebRTCatPeerConnectionClient.this.peerConnection.removeIceCandidates(candidates);
            }
        });
    }

    public void setRemoteDescription(final SessionDescription sdp) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatPeerConnectionClient.this.peerConnection == null || WebRTCatPeerConnectionClient.this.isError) {
                    return;
                }
                String sdpDescription = sdp.description;
                if (WebRTCatPeerConnectionClient.this.preferIsac) {
                    sdpDescription = WebRTCatPeerConnectionClient.preferCodec(sdpDescription, WebRTCatPeerConnectionClient.AUDIO_CODEC_ISAC, true);
                }
                if (WebRTCatPeerConnectionClient.this.videoCallEnabled) {
                    sdpDescription = WebRTCatPeerConnectionClient.preferCodec(sdpDescription, WebRTCatPeerConnectionClient.this.preferredVideoCodec, false);
                }
                if (WebRTCatPeerConnectionClient.this.videoCallEnabled && ((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.videoStartBitrate > 0) {
                    sdpDescription = WebRTCatPeerConnectionClient.setStartBitrate(WebRTCatPeerConnectionClient.VIDEO_CODEC_VP8, true, sdpDescription, ((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.videoStartBitrate);
                    sdpDescription = WebRTCatPeerConnectionClient.setStartBitrate(WebRTCatPeerConnectionClient.VIDEO_CODEC_VP9, true, sdpDescription, ((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.videoStartBitrate);
                    sdpDescription = WebRTCatPeerConnectionClient.setStartBitrate(WebRTCatPeerConnectionClient.VIDEO_CODEC_H264, true, sdpDescription, ((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.videoStartBitrate);
                }
                if (((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.audioStartBitrate > 0) {
                    sdpDescription = WebRTCatPeerConnectionClient.setStartBitrate(WebRTCatPeerConnectionClient.AUDIO_CODEC_OPUS, false, sdpDescription, ((WebRTCatPeerConnectionClient)WebRTCatPeerConnectionClient.this).peerConnectionParameters.audioStartBitrate);
                }
                Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Set remote SDP.");
                SessionDescription sdpRemote = new SessionDescription(sdp.type, sdpDescription);
                WebRTCatPeerConnectionClient.this.peerConnection.setRemoteDescription((SdpObserver)WebRTCatPeerConnectionClient.this.sdpObserver, sdpRemote);
            }
        });
    }

    public void stopVideoSource() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatPeerConnectionClient.this.videoCapturer != null && !WebRTCatPeerConnectionClient.this.videoCapturerStopped) {
                    Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Stop video source.");
                    try {
                        WebRTCatPeerConnectionClient.this.videoCapturer.stopCapture();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    WebRTCatPeerConnectionClient.this.videoCapturerStopped = true;
                }
            }
        });
    }

    public void startVideoSource() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatPeerConnectionClient.this.videoCapturer != null && WebRTCatPeerConnectionClient.this.videoCapturerStopped) {
                    Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Restart video source.");
                    WebRTCatPeerConnectionClient.this.videoCapturer.startCapture(WebRTCatPeerConnectionClient.this.videoWidth, WebRTCatPeerConnectionClient.this.videoHeight, WebRTCatPeerConnectionClient.this.videoFps);
                    WebRTCatPeerConnectionClient.this.videoCapturerStopped = false;
                }
            }
        });
    }

    private void reportError(final String errorMessage) {
        Log.e((String)TAG, (String)("Peerconnection error: " + errorMessage));
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!WebRTCatPeerConnectionClient.this.isError) {
                    WebRTCatPeerConnectionClient.this.events.onPeerConnectionError(errorMessage);
                    WebRTCatPeerConnectionClient.this.isError = true;
                }
            }
        });
    }

    private AudioTrack createAudioTrack() {
        this.audioSource = this.factory.createAudioSource(this.audioConstraints);
        this.localAudioTrack = this.factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
        this.localAudioTrack.setEnabled(this.enableAudio);
        return this.localAudioTrack;
    }

    private VideoTrack createVideoTrack(VideoCapturer capturer) {
        this.videoSource = this.factory.createVideoSource(capturer);
        capturer.startCapture(this.videoWidth, this.videoHeight, this.videoFps);
        this.localVideoTrack = this.factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
        this.localVideoTrack.setEnabled(this.renderVideo);
        this.localVideoTrack.addRenderer(new VideoRenderer(this.localRender));
        return this.localVideoTrack;
    }

    private static String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdpDescription.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            Log.w((String)TAG, (String)("No rtpmap for " + codec + " codec"));
            return sdpDescription;
        }
        Log.d((String)TAG, (String)("Found " + codec + " rtpmap " + codecRtpMap + " at " + lines[rtpmapLineIndex]));
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            Log.d((String)TAG, (String)("Found " + codec + " " + lines[i]));
            if (isVideoCodec) {
                int n = i;
                lines[n] = lines[n] + "; x-google-start-bitrate=" + bitrateKbps;
            } else {
                int n = i;
                lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            }
            Log.d((String)TAG, (String)("Update remote SDP line: " + lines[i]));
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            Log.d((String)TAG, (String)("Add remote SDP line: " + bitrateSet));
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = -1;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        String mediaDescription = "m=video ";
        if (isAudio) {
            mediaDescription = "m=audio ";
        }
        for (int i = 0; i < lines.length && (mLineIndex == -1 || codecRtpMap == null); ++i) {
            if (lines[i].startsWith(mediaDescription)) {
                mLineIndex = i;
                continue;
            }
            Matcher codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
        }
        if (mLineIndex == -1) {
            Log.w((String)TAG, (String)("No " + mediaDescription + " line, so can't prefer " + codec));
            return sdpDescription;
        }
        if (codecRtpMap == null) {
            Log.w((String)TAG, (String)("No rtpmap for " + codec));
            return sdpDescription;
        }
        Log.d((String)TAG, (String)("Found " + codec + " rtpmap " + codecRtpMap + ", prefer at " + lines[mLineIndex]));
        String[] origMLineParts = lines[mLineIndex].split(" ");
        if (origMLineParts.length > 3) {
            StringBuilder newMLine = new StringBuilder();
            int origPartIndex = 0;
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(codecRtpMap);
            while (origPartIndex < origMLineParts.length) {
                if (!origMLineParts[origPartIndex].equals(codecRtpMap)) {
                    newMLine.append(" ").append(origMLineParts[origPartIndex]);
                }
                ++origPartIndex;
            }
            lines[mLineIndex] = newMLine.toString();
            Log.d((String)TAG, (String)("Change media description: " + lines[mLineIndex]));
        } else {
            Log.e((String)TAG, (String)("Wrong SDP media description format: " + lines[mLineIndex]));
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (String line : lines) {
            newSdpDescription.append(line).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private void drainCandidates() {
        if (this.queuedRemoteCandidates != null) {
            Log.d((String)TAG, (String)("Add " + this.queuedRemoteCandidates.size() + " remote candidates"));
            for (IceCandidate candidate : this.queuedRemoteCandidates) {
                this.peerConnection.addIceCandidate(candidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    private void switchCameraInternal() {
        if (!this.videoCallEnabled || this.numberOfCameras < 2 || this.isError || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to switch camera. Video: " + this.videoCallEnabled + ". Error : " + this.isError + ". Number of cameras: " + this.numberOfCameras));
            return;
        }
        Log.d((String)TAG, (String)"Switch camera");
        this.videoCapturer.switchCamera(null);
    }

    public void switchCamera() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatPeerConnectionClient.this.switchCameraInternal();
            }
        });
    }

    public void changeCaptureFormat(final int width, final int height, final int framerate) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatPeerConnectionClient.this.changeCaptureFormatInternal(width, height, framerate);
            }
        });
    }

    private void changeCaptureFormatInternal(int width, int height, int framerate) {
        if (!this.videoCallEnabled || this.isError || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Video: " + this.videoCallEnabled + ". Error : " + this.isError));
            return;
        }
        Log.d((String)TAG, (String)("changeCaptureFormat: " + width + "x" + height + "@" + framerate));
        this.videoCapturer.onOutputFormatRequest(width, height, framerate);
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        public void onCreateSuccess(SessionDescription origSdp) {
            if (WebRTCatPeerConnectionClient.this.localSdp != null) {
                WebRTCatPeerConnectionClient.this.reportError("Multiple SDP create.");
                return;
            }
            String sdpDescription = origSdp.description;
            if (WebRTCatPeerConnectionClient.this.preferIsac) {
                sdpDescription = WebRTCatPeerConnectionClient.preferCodec(sdpDescription, WebRTCatPeerConnectionClient.AUDIO_CODEC_ISAC, true);
            }
            if (WebRTCatPeerConnectionClient.this.videoCallEnabled) {
                sdpDescription = WebRTCatPeerConnectionClient.preferCodec(sdpDescription, WebRTCatPeerConnectionClient.this.preferredVideoCodec, false);
            }
            final SessionDescription sdp = new SessionDescription(origSdp.type, sdpDescription);
            WebRTCatPeerConnectionClient.this.localSdp = sdp;
            WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (WebRTCatPeerConnectionClient.this.peerConnection != null && !WebRTCatPeerConnectionClient.this.isError) {
                        Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)("Set local SDP from " + sdp.type));
                        WebRTCatPeerConnectionClient.this.peerConnection.setLocalDescription((SdpObserver)WebRTCatPeerConnectionClient.this.sdpObserver, sdp);
                    }
                }
            });
        }

        public void onSetSuccess() {
            WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (WebRTCatPeerConnectionClient.this.peerConnection == null || WebRTCatPeerConnectionClient.this.isError) {
                        return;
                    }
                    if (WebRTCatPeerConnectionClient.this.isInitiator) {
                        if (WebRTCatPeerConnectionClient.this.peerConnection.getRemoteDescription() == null) {
                            Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Local SDP set succesfully");
                            WebRTCatPeerConnectionClient.this.events.onLocalDescription(WebRTCatPeerConnectionClient.this.localSdp);
                        } else {
                            Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Remote SDP set succesfully");
                            WebRTCatPeerConnectionClient.this.drainCandidates();
                        }
                    } else if (WebRTCatPeerConnectionClient.this.peerConnection.getLocalDescription() != null) {
                        Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Local SDP set succesfully");
                        WebRTCatPeerConnectionClient.this.events.onLocalDescription(WebRTCatPeerConnectionClient.this.localSdp);
                        WebRTCatPeerConnectionClient.this.drainCandidates();
                    } else {
                        Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)"Remote SDP set succesfully");
                    }
                }
            });
        }

        public void onCreateFailure(String error) {
            WebRTCatPeerConnectionClient.this.reportError("createSDP error: " + error);
        }

        public void onSetFailure(String error) {
            WebRTCatPeerConnectionClient.this.reportError("setSDP error: " + error);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        public void onIceCandidate(final IceCandidate candidate) {
            WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    WebRTCatPeerConnectionClient.this.events.onIceCandidate(candidate);
                }
            });
        }

        public void onIceCandidatesRemoved(final IceCandidate[] candidates) {
            WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    WebRTCatPeerConnectionClient.this.events.onIceCandidatesRemoved(candidates);
                }
            });
        }

        public void onSignalingChange(PeerConnection.SignalingState newState) {
            Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)("SignalingState: " + newState));
        }

        public void onIceConnectionChange(final PeerConnection.IceConnectionState newState) {
            WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)("IceConnectionState: " + newState));
                    if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                        WebRTCatPeerConnectionClient.this.events.onIceConnected();
                    } else if (newState == PeerConnection.IceConnectionState.DISCONNECTED) {
                        WebRTCatPeerConnectionClient.this.events.onIceDisconnected();
                    } else if (newState == PeerConnection.IceConnectionState.FAILED) {
                        WebRTCatPeerConnectionClient.this.events.onIceFailed();
                    }
                }
            });
        }

        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)("IceGatheringState: " + newState));
        }

        public void onIceConnectionReceivingChange(boolean receiving) {
            Log.d((String)WebRTCatPeerConnectionClient.TAG, (String)("IceConnectionReceiving changed to " + receiving));
        }

        public void onAddStream(final MediaStream stream) {
            WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (WebRTCatPeerConnectionClient.this.peerConnection == null || WebRTCatPeerConnectionClient.this.isError) {
                        return;
                    }
                    if (stream.audioTracks.size() > 1 || stream.videoTracks.size() > 1) {
                        WebRTCatPeerConnectionClient.this.reportError("Weird-looking stream: " + stream);
                        return;
                    }
                    if (stream.videoTracks.size() == 1) {
                        WebRTCatPeerConnectionClient.this.remoteVideoTrack = (VideoTrack)stream.videoTracks.get(0);
                        WebRTCatPeerConnectionClient.this.remoteVideoTrack.setEnabled(WebRTCatPeerConnectionClient.this.renderVideo);
                        if (WebRTCatPeerConnectionClient.this.remoteRender != null) {
                            WebRTCatPeerConnectionClient.this.remoteVideoTrack.addRenderer(new VideoRenderer(WebRTCatPeerConnectionClient.this.remoteRender));
                        }
                    }
                }
            });
        }

        public void onRemoveStream(MediaStream stream) {
            WebRTCatPeerConnectionClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    WebRTCatPeerConnectionClient.this.remoteVideoTrack = null;
                }
            });
        }

        public void onDataChannel(DataChannel dc) {
            WebRTCatPeerConnectionClient.this.reportError("AppRTC doesn't use data channels, but got: " + dc.label() + " anyway!");
        }

        public void onRenegotiationNeeded() {
        }
    }

    public static interface PeerConnectionEvents {
        public void onLocalDescription(SessionDescription var1);

        public void onIceCandidate(IceCandidate var1);

        public void onIceCandidatesRemoved(IceCandidate[] var1);

        public void onIceConnected();

        public void onIceDisconnected();

        public void onIceFailed();

        public void onPeerConnectionClosed();

        public void onPeerConnectionStatsReady(StatsReport[] var1);

        public void onPeerConnectionError(String var1);
    }

    public static class PeerConnectionParameters {
        public final boolean videoCallEnabled;
        public final boolean loopback;
        public final boolean tracing;
        public final boolean useCamera2;
        public final int videoWidth;
        public final int videoHeight;
        public final int videoFps;
        public final int videoStartBitrate;
        public final String videoCodec;
        public final boolean videoCodecHwAcceleration;
        public final boolean captureToTexture;
        public final int audioStartBitrate;
        public final String audioCodec;
        public final boolean noAudioProcessing;
        public final boolean aecDump;
        public final boolean useOpenSLES;
        public final boolean disableBuiltInAEC;
        public final boolean disableBuiltInAGC;
        public final boolean disableBuiltInNS;
        public final boolean enableLevelControl;

        public PeerConnectionParameters(boolean videoCallEnabled, boolean loopback, boolean tracing, boolean useCamera2, int videoWidth, int videoHeight, int videoFps, int videoStartBitrate, String videoCodec, boolean videoCodecHwAcceleration, boolean captureToTexture, int audioStartBitrate, String audioCodec, boolean noAudioProcessing, boolean aecDump, boolean useOpenSLES, boolean disableBuiltInAEC, boolean disableBuiltInAGC, boolean disableBuiltInNS, boolean enableLevelControl) {
            this.videoCallEnabled = videoCallEnabled;
            this.loopback = loopback;
            this.tracing = tracing;
            this.useCamera2 = useCamera2;
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.videoFps = videoFps;
            this.videoStartBitrate = videoStartBitrate;
            this.videoCodec = videoCodec;
            this.videoCodecHwAcceleration = videoCodecHwAcceleration;
            this.captureToTexture = captureToTexture;
            this.audioStartBitrate = audioStartBitrate;
            this.audioCodec = audioCodec;
            this.noAudioProcessing = noAudioProcessing;
            this.aecDump = aecDump;
            this.useOpenSLES = useOpenSLES;
            this.disableBuiltInAEC = disableBuiltInAEC;
            this.disableBuiltInAGC = disableBuiltInAGC;
            this.disableBuiltInNS = disableBuiltInNS;
            this.enableLevelControl = enableLevelControl;
        }
    }
}

