/*
 * Decompiled with CFR 0.152.
 */
package net.i2cat.seg.webrtcat4;

import android.util.Log;
import net.i2cat.seg.webrtcat4.WebRTCat;
import net.i2cat.seg.webrtcat4.WebRTCatErrorCode;
import net.i2cat.seg.webrtcat4.WebRTCatSocketChannelClient;
import net.i2cat.seg.webrtcat4.WebRTUtils;
import net.i2cat.seg.webrtcat4.stats.WebRTStats;
import org.appspot.apprtc.AppRTCClient;
import org.appspot.apprtc.RoomParametersFetcher;
import org.appspot.apprtc.util.AsyncHttpURLConnection;
import org.appspot.apprtc.util.LooperExecutor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;

public class WebRTCatClient
implements AppRTCClient,
WebRTCatSocketChannelClient.WebSocketChannelEvents {
    private static final String TAG = "WebRTCatClient";
    private static final String ROOM_JOIN = "join";
    private static final String ROOM_MESSAGE = "message";
    private static final String ROOM_LEAVE = "leave";
    private final LooperExecutor executor;
    private boolean initiator;
    private SignalingEvents events;
    private WebRTCatSocketChannelClient wsClient;
    private ConnectionState roomState;
    private AppRTCClient.RoomConnectionParameters connectionParameters;
    private String messageUrl;
    private String leaveUrl;
    private AppRTCClient.SignalingParameters signalingParameters;
    private String clientName;
    private boolean isConnectedToRoom;
    private WebRTCat.DisconnectReason disconnectReason;
    private WebRTStats lastStats;

    public WebRTCatClient(SignalingEvents events, LooperExecutor executor, String clientName) {
        this.events = events;
        this.executor = executor;
        this.clientName = clientName;
        this.roomState = ConnectionState.NEW;
        executor.requestStart();
    }

    @Override
    public void connectToRoom(AppRTCClient.RoomConnectionParameters connectionParameters) {
        this.connectionParameters = connectionParameters;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatClient.this.connectToRoomInternal();
            }
        });
    }

    @Override
    public void disconnectFromRoom() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WebRTCatClient.this.disconnectFromRoomInternal();
            }
        });
        this.executor.requestStop();
    }

    public void setDisconnectReason(WebRTCat.DisconnectReason reason) {
        this.disconnectReason = reason;
    }

    public void setLastStats(WebRTStats stats) {
        this.lastStats = stats;
    }

    private void connectToRoomInternal() {
        String connectionUrl = this.getConnectionUrl(this.connectionParameters);
        Log.d((String)TAG, (String)("Connect to room: " + connectionUrl));
        this.roomState = ConnectionState.NEW;
        this.wsClient = new WebRTCatSocketChannelClient(this.executor, this);
        RoomParametersFetcher.RoomParametersFetcherEvents callbacks = new RoomParametersFetcher.RoomParametersFetcherEvents(){

            @Override
            public void onSignalingParametersReady(final AppRTCClient.SignalingParameters params) {
                WebRTCatClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        WebRTCatClient.this.signalingParametersReady(params);
                    }
                });
            }

            @Override
            public void onSignalingParametersError(String description) {
                WebRTCatClient.this.reportError(description, WebRTCatErrorCode.CANT_JOIN_ROOM);
            }
        };
        new RoomParametersFetcher(connectionUrl, null, callbacks).makeRequest();
    }

    private void disconnectFromRoomInternal() {
        Log.d((String)TAG, (String)("Disconnect. Room state: " + (Object)((Object)this.roomState)));
        if (this.isConnectedToRoom) {
            Log.d((String)TAG, (String)"Closing room.");
            JSONObject json = new JSONObject();
            WebRTUtils.jsonPut(json, "disconnectReason", this.disconnectReason != null ? this.disconnectReason.toString() : "");
            if (this.lastStats != null) {
                WebRTUtils.jsonPut(json, "clientStats", this.lastStats.toJSON());
            }
            this.sendPostMessage(MessageType.LEAVE, this.leaveUrl, json.toString());
        }
        this.roomState = ConnectionState.CLOSED;
        if (this.wsClient != null) {
            this.wsClient.disconnect(true);
        }
    }

    private String getConnectionUrl(AppRTCClient.RoomConnectionParameters connectionParameters) {
        return connectionParameters.roomUrl + "/" + ROOM_JOIN + "/" + connectionParameters.roomId;
    }

    private String getMessageUrl(AppRTCClient.RoomConnectionParameters connectionParameters, AppRTCClient.SignalingParameters signalingParameters) {
        return connectionParameters.roomUrl + "/" + ROOM_MESSAGE + "/" + connectionParameters.roomId + "/" + signalingParameters.clientId;
    }

    private String getLeaveUrl(AppRTCClient.RoomConnectionParameters connectionParameters, AppRTCClient.SignalingParameters signalingParameters) {
        String url = connectionParameters.roomUrl + "/" + ROOM_LEAVE + "/" + connectionParameters.roomId + "/" + signalingParameters.clientId;
        if (this.clientName != null) {
            url = url + "/" + this.clientName;
        }
        return url;
    }

    private void signalingParametersReady(AppRTCClient.SignalingParameters signalingParameters) {
        Log.d((String)TAG, (String)"Room connection completed.");
        if (this.connectionParameters.loopback && (!signalingParameters.initiator || signalingParameters.offerSdp != null)) {
            this.reportError("Loopback room is busy.", WebRTCatErrorCode.GENERAL_ERROR);
            return;
        }
        if (!this.connectionParameters.loopback && !signalingParameters.initiator && signalingParameters.offerSdp == null) {
            Log.w((String)TAG, (String)"No offer SDP in room response.");
        }
        this.initiator = signalingParameters.initiator;
        this.messageUrl = this.getMessageUrl(this.connectionParameters, signalingParameters);
        this.leaveUrl = this.getLeaveUrl(this.connectionParameters, signalingParameters);
        this.signalingParameters = signalingParameters;
        Log.d((String)TAG, (String)("Message URL: " + this.messageUrl));
        Log.d((String)TAG, (String)("Leave URL: " + this.leaveUrl));
        this.roomState = ConnectionState.CONNECTED;
        this.isConnectedToRoom = true;
        this.wsClient.connect(signalingParameters.wssUrl, signalingParameters.wssPostUrl);
    }

    @Override
    public void sendOfferSdp(SessionDescription sdp) {
        this.sendOfferSdp(sdp, null);
    }

    public void sendOfferSdp(final SessionDescription sdp, final String destClientName) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatClient.this.roomState != ConnectionState.CONNECTED) {
                    WebRTCatClient.this.reportError("Sending offer SDP in non connected state.", WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
                    return;
                }
                JSONObject json = new JSONObject();
                WebRTUtils.jsonPut(json, "sdp", sdp.description);
                WebRTUtils.jsonPut(json, "type", "offer");
                if (destClientName != null) {
                    WebRTUtils.jsonPut(json, "sourceClientName", WebRTCatClient.this.clientName);
                    WebRTUtils.jsonPut(json, "destClientName", destClientName);
                }
                WebRTCatClient.this.sendPostMessage(MessageType.MESSAGE, WebRTCatClient.this.messageUrl, json.toString());
                if (((WebRTCatClient)WebRTCatClient.this).connectionParameters.loopback) {
                    SessionDescription sdpAnswer = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)"answer"), sdp.description);
                    WebRTCatClient.this.events.onRemoteDescription(sdpAnswer);
                }
            }
        });
    }

    @Override
    public void sendAnswerSdp(final SessionDescription sdp) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((WebRTCatClient)WebRTCatClient.this).connectionParameters.loopback) {
                    Log.e((String)WebRTCatClient.TAG, (String)"Sending answer in loopback mode.");
                    return;
                }
                JSONObject json = new JSONObject();
                WebRTUtils.jsonPut(json, "sdp", sdp.description);
                WebRTUtils.jsonPut(json, "type", "answer");
                WebRTCatClient.this.wsClient.send(json.toString());
                json = new JSONObject();
                WebRTUtils.jsonPut(json, "type", "system:answer");
                WebRTUtils.jsonPut(json, "sourceClientName", WebRTCatClient.this.clientName);
                WebRTCatClient.this.sendPostMessage(MessageType.MESSAGE, WebRTCatClient.this.messageUrl, json.toString());
            }
        });
    }

    @Override
    public void sendLocalIceCandidate(final IceCandidate candidate) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                WebRTUtils.jsonPut(json, "type", "candidate");
                WebRTUtils.jsonPut(json, "label", candidate.sdpMLineIndex);
                WebRTUtils.jsonPut(json, "id", candidate.sdpMid);
                WebRTUtils.jsonPut(json, "candidate", candidate.sdp);
                if (WebRTCatClient.this.initiator) {
                    if (WebRTCatClient.this.roomState != ConnectionState.CONNECTED) {
                        WebRTCatClient.this.reportError("Sending ICE candidate in non connected state.", WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
                        return;
                    }
                    WebRTCatClient.this.sendPostMessage(MessageType.MESSAGE, WebRTCatClient.this.messageUrl, json.toString());
                    if (((WebRTCatClient)WebRTCatClient.this).connectionParameters.loopback) {
                        WebRTCatClient.this.events.onRemoteIceCandidate(candidate);
                    }
                } else {
                    WebRTCatClient.this.wsClient.send(json.toString());
                }
            }
        });
    }

    @Override
    public void sendLocalIceCandidateRemovals(final IceCandidate[] candidates) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                WebRTUtils.jsonPut(json, "type", "remove-candidates");
                JSONArray jsonArray = new JSONArray();
                for (IceCandidate candidate : candidates) {
                    jsonArray.put((Object)WebRTCatClient.this.toJsonCandidate(candidate));
                }
                WebRTUtils.jsonPut(json, "candidates", jsonArray);
                if (WebRTCatClient.this.initiator) {
                    if (WebRTCatClient.this.roomState != ConnectionState.CONNECTED) {
                        WebRTCatClient.this.reportError("Sending ICE candidate removals in non connected state.", WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
                        return;
                    }
                    WebRTCatClient.this.sendPostMessage(MessageType.MESSAGE, WebRTCatClient.this.messageUrl, json.toString());
                    if (((WebRTCatClient)WebRTCatClient.this).connectionParameters.loopback) {
                        WebRTCatClient.this.events.onRemoteIceCandidatesRemoved(candidates);
                    }
                } else {
                    WebRTCatClient.this.wsClient.send(json.toString());
                }
            }
        });
    }

    @Override
    public void onWebSocketOpen() {
        this.wsClient.register(this.connectionParameters.roomId, this.signalingParameters.clientId);
    }

    @Override
    public void onWebSocketRegistered() {
        this.events.onConnectedToRoom(this.signalingParameters);
    }

    @Override
    public void onWebSocketMessage(String msg) {
        if (this.wsClient.getState() != WebRTCatSocketChannelClient.WebSocketConnectionState.REGISTERED) {
            Log.e((String)TAG, (String)"Got WebSocket message in non registered state.");
            return;
        }
        try {
            JSONObject json = new JSONObject(msg);
            String msgText = json.getString("msg");
            String errorText = json.optString("error");
            if (msgText.length() > 0) {
                json = new JSONObject(msgText);
                String type = json.optString("type");
                if (type.equals("candidate")) {
                    this.events.onRemoteIceCandidate(this.toJavaCandidate(json));
                } else if (type.equals("remove-candidates")) {
                    JSONArray candidateArray = json.getJSONArray("candidates");
                    IceCandidate[] candidates = new IceCandidate[candidateArray.length()];
                    for (int i = 0; i < candidateArray.length(); ++i) {
                        candidates[i] = this.toJavaCandidate(candidateArray.getJSONObject(i));
                    }
                    this.events.onRemoteIceCandidatesRemoved(candidates);
                } else if (type.equals("answer")) {
                    if (this.initiator) {
                        SessionDescription sdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), json.getString("sdp"));
                        this.events.onRemoteDescription(sdp);
                    } else {
                        this.reportError("Received answer for call initiator: " + msg, WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
                    }
                } else if (type.equals("offer")) {
                    if (!this.initiator) {
                        SessionDescription sdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), json.getString("sdp"));
                        this.events.onRemoteDescription(sdp);
                    } else {
                        this.reportError("Received offer for call receiver: " + msg, WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
                    }
                } else if (type.equals("bye")) {
                    this.events.onChannelClose();
                } else {
                    this.reportError("Unexpected WebSocket message: " + msg, WebRTCatErrorCode.UNKNOWN_SIGNALING_SERVER_MESSAGE);
                }
            } else if (errorText != null && errorText.length() > 0) {
                this.reportError("WebSocket error message: " + errorText, WebRTCatErrorCode.SIGNALING_SERVER_REPORTED_ERROR);
            } else {
                this.reportError("Unexpected WebSocket message: " + msg, WebRTCatErrorCode.UNKNOWN_SIGNALING_SERVER_MESSAGE);
            }
        }
        catch (JSONException e) {
            this.reportError("WebSocket message JSON parsing error: " + e.toString(), WebRTCatErrorCode.UNKNOWN_SIGNALING_SERVER_MESSAGE);
        }
    }

    @Override
    public void onWebSocketClose() {
        this.events.onChannelClose();
    }

    @Override
    public void onWebSocketError(String description, WebRTCatErrorCode errorCode) {
        this.reportError("WebSocket error: " + description, errorCode);
    }

    private void reportError(final String errorMessage, final WebRTCatErrorCode errorCode) {
        Log.e((String)TAG, (String)errorMessage);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCatClient.this.roomState != ConnectionState.ERROR) {
                    WebRTCatClient.this.roomState = ConnectionState.ERROR;
                    WebRTCatClient.this.events.onChannelError(errorMessage, errorCode);
                }
            }
        });
    }

    private void sendPostMessage(final MessageType messageType, String url, String message) {
        String logInfo = url;
        if (message != null) {
            logInfo = logInfo + ". Message: " + message;
        }
        Log.d((String)TAG, (String)("C->RoomServer: " + logInfo));
        AsyncHttpURLConnection httpConnection = new AsyncHttpURLConnection("POST", url, message, new AsyncHttpURLConnection.AsyncHttpEvents(){

            @Override
            public void onHttpError(String errorMessage) {
                WebRTCatClient.this.reportError("RoomServer POST error: " + errorMessage, messageType == MessageType.MESSAGE ? WebRTCatErrorCode.CANT_MESSAGE_ROOM : WebRTCatErrorCode.GENERAL_ERROR);
            }

            @Override
            public void onHttpComplete(String response) {
                if (messageType == MessageType.MESSAGE) {
                    try {
                        JSONObject roomJson = new JSONObject(response);
                        String result = roomJson.getString("result");
                        if (!result.equals("SUCCESS")) {
                            WebRTCatClient.this.reportError(result, WebRTCatErrorCode.CANT_MESSAGE_ROOM);
                        }
                    }
                    catch (JSONException e) {
                        WebRTCatClient.this.reportError("RoomServer POST JSON error: " + e.toString(), WebRTCatErrorCode.CANT_MESSAGE_ROOM);
                    }
                }
            }
        });
        httpConnection.send();
    }

    private JSONObject toJsonCandidate(IceCandidate candidate) {
        JSONObject json = new JSONObject();
        WebRTUtils.jsonPut(json, "label", candidate.sdpMLineIndex);
        WebRTUtils.jsonPut(json, "id", candidate.sdpMid);
        WebRTUtils.jsonPut(json, "candidate", candidate.sdp);
        return json;
    }

    IceCandidate toJavaCandidate(JSONObject json) throws JSONException {
        return new IceCandidate(json.getString("id"), json.getInt("label"), json.getString("candidate"));
    }

    static interface SignalingEvents
    extends AppRTCClient.SignalingEvents {
        public void onChannelError(String var1, WebRTCatErrorCode var2);
    }

    private static enum MessageType {
        MESSAGE,
        LEAVE;

    }

    private static enum ConnectionState {
        NEW,
        CONNECTED,
        CLOSED,
        ERROR;

    }
}

