/*
 * Decompiled with CFR 0.152.
 */
package net.i2cat.seg.webrtcat4;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.util.Log;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.i2cat.seg.webrtcat4.WebRTCatClient;
import net.i2cat.seg.webrtcat4.WebRTCatErrorCode;
import net.i2cat.seg.webrtcat4.WebRTCatParams;
import net.i2cat.seg.webrtcat4.WebRTCatPeerConnectionClient;
import net.i2cat.seg.webrtcat4.stats.WebRTCAudioStats;
import net.i2cat.seg.webrtcat4.stats.WebRTCMediaStats;
import net.i2cat.seg.webrtcat4.stats.WebRTCVideoStats;
import net.i2cat.seg.webrtcat4.stats.WebRTStats;
import org.appspot.apprtc.AppRTCAudioManager;
import org.appspot.apprtc.AppRTCClient;
import org.appspot.apprtc.PercentFrameLayout;
import org.appspot.apprtc.util.LooperExecutor;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.RendererCommon;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;
import org.webrtc.SurfaceViewRenderer;
import org.webrtc.VideoRenderer;

public class WebRTCat {
    private static final String TAG = "WebRTCat";
    private static final int STAT_CALLBACK_PERIOD = 1000;
    private static final int LOCAL_X_CONNECTING = 0;
    private static final int LOCAL_Y_CONNECTING = 0;
    private static final int LOCAL_WIDTH_CONNECTING = 100;
    private static final int LOCAL_HEIGHT_CONNECTING = 100;
    private static final int LOCAL_X_CONNECTED = 72;
    private static final int LOCAL_Y_CONNECTED = 72;
    private static final int LOCAL_WIDTH_CONNECTED = 25;
    private static final int LOCAL_HEIGHT_CONNECTED = 25;
    private static final int REMOTE_X = 0;
    private static final int REMOTE_Y = 0;
    private static final int REMOTE_WIDTH = 100;
    private static final int REMOTE_HEIGHT = 100;
    private Activity owningActivity;
    private WebRTCatPeerConnectionClient peerConnectionClient = null;
    private AppRTCClient appRtcClient;
    private AppRTCClient.SignalingParameters signalingParameters;
    private AppRTCAudioManager audioManager = null;
    private EglBase rootEglBase;
    private SurfaceViewRenderer localRender;
    private SurfaceViewRenderer remoteRender;
    private PercentFrameLayout localRenderLayout;
    private PercentFrameLayout remoteRenderLayout;
    private AppRTCClient.RoomConnectionParameters roomConnectionParameters;
    private boolean iceConnected;
    private boolean isError;
    private long callStartedTimeMs = 0L;
    private WebRTCatState webrtcatState;
    private String username;
    private String destClientName;
    private boolean isAudioEnabled = true;
    private Executor cleanupExecutor = Executors.newSingleThreadScheduledExecutor();
    private Long lastCallStartTime;
    private WebRTStats lastStats;
    private boolean wasConnected;
    private WebRTCatCallbacks callbacks;

    public WebRTCat(Activity owningActivity, WebRTCatCallbacks callbacks) {
        this.owningActivity = owningActivity;
        this.callbacks = callbacks;
        this.webrtcatState = WebRTCatState.DISCONNECTED;
    }

    public void muteVideo() {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.stopVideoSource();
        }
    }

    public void unmuteVideo() {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.startVideoSource();
        }
    }

    public boolean toggleAudioMute() {
        if (this.peerConnectionClient != null) {
            this.isAudioEnabled = !this.isAudioEnabled;
            this.peerConnectionClient.setAudioEnabled(this.isAudioEnabled);
        }
        return this.isAudioEnabled;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Deprecated
    public void connect(Uri roomUri, String roomId, WebRTCatPeerConnectionClient.PeerConnectionParameters peerConnectionParameters) {
        WebRTCatParams params = new WebRTCatParams(roomUri.toString(), roomId);
        params.setAudioCodec(peerConnectionParameters.audioCodec);
        params.setAudioStartingBitrate(peerConnectionParameters.audioStartBitrate);
        params.setVideoCodec(peerConnectionParameters.videoCodec);
        params.setVideoFps(peerConnectionParameters.videoFps);
        params.setVideoHeight(peerConnectionParameters.videoHeight);
        params.setVideoWidth(peerConnectionParameters.videoWidth);
        params.setVideoStartingBitrate(peerConnectionParameters.videoStartBitrate);
        this.connect(params);
    }

    public void connect(WebRTCatParams webrtcatParams) {
        if (this.getState() != WebRTCatState.DISCONNECTED) {
            Log.e((String)TAG, (String)("This method can only be called in state " + (Object)((Object)WebRTCatState.DISCONNECTED) + " (current state is " + (Object)((Object)this.getState()) + ")"));
            this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
        }
        this.iceConnected = false;
        this.signalingParameters = null;
        this.rootEglBase = EglBase.create();
        this.audioManager = AppRTCAudioManager.create((Context)this.owningActivity, new Runnable(){

            @Override
            public void run() {
            }
        });
        Log.d((String)TAG, (String)"Initializing the audio manager...");
        this.audioManager.init();
        this.appRtcClient = new WebRTCatClient(new SignallingEventHandler(), new LooperExecutor(), this.username);
        this.roomConnectionParameters = new AppRTCClient.RoomConnectionParameters(webrtcatParams.getRoomServerUri(), webrtcatParams.getRoomName(), false);
        this.peerConnectionClient = WebRTCatPeerConnectionClient.getInstance();
        this.peerConnectionClient.createPeerConnectionFactory((Context)this.owningActivity, webrtcatParams.getPCParameters(), new PeerConnectionEventHandler());
        this.isAudioEnabled = true;
        this.callStartedTimeMs = System.currentTimeMillis();
        this.appRtcClient.connectToRoom(this.roomConnectionParameters);
    }

    public void disconnect(final DisconnectReason reason) {
        this.cleanupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    long t = System.currentTimeMillis();
                    Log.d((String)WebRTCat.TAG, (String)"Begin async disconnect");
                    if (WebRTCat.this.appRtcClient != null) {
                        ((WebRTCatClient)WebRTCat.this.appRtcClient).setDisconnectReason(reason);
                        ((WebRTCatClient)WebRTCat.this.appRtcClient).setLastStats(WebRTCat.this.lastStats);
                        WebRTCat.this.appRtcClient.disconnectFromRoom();
                        WebRTCat.this.appRtcClient = null;
                    }
                    Log.d((String)WebRTCat.TAG, (String)("appRtcClient.disconnectFromRoom(): " + (System.currentTimeMillis() - t)));
                    if (WebRTCat.this.peerConnectionClient != null) {
                        WebRTCat.this.peerConnectionClient.close();
                        WebRTCat.this.peerConnectionClient = null;
                    }
                    Log.d((String)WebRTCat.TAG, (String)("peerConnectionClient.close(): " + (System.currentTimeMillis() - t)));
                    if (WebRTCat.this.localRender != null) {
                        WebRTCat.this.localRender.release();
                        WebRTCat.this.localRender = null;
                    }
                    Log.d((String)WebRTCat.TAG, (String)("localRender.release(): " + (System.currentTimeMillis() - t)));
                    if (WebRTCat.this.remoteRender != null) {
                        WebRTCat.this.remoteRender.release();
                        WebRTCat.this.remoteRender = null;
                    }
                    Log.d((String)WebRTCat.TAG, (String)("remoteRender.release(): " + (System.currentTimeMillis() - t)));
                    if (WebRTCat.this.audioManager != null) {
                        WebRTCat.this.audioManager.close();
                        WebRTCat.this.audioManager = null;
                    }
                    Log.d((String)WebRTCat.TAG, (String)("audioManager.close(): " + (System.currentTimeMillis() - t)));
                    if (WebRTCat.this.rootEglBase != null) {
                        WebRTCat.this.rootEglBase.release();
                        WebRTCat.this.rootEglBase = null;
                    }
                    Log.d((String)WebRTCat.TAG, (String)("rootEglBase.release(): " + (System.currentTimeMillis() - t)));
                }
                catch (Exception e) {
                    Log.e((String)WebRTCat.TAG, (String)"Exception on disconnect(): ", (Throwable)e);
                }
            }
        });
        this.transitionState(WebRTCatState.DISCONNECTED);
    }

    public void hangup() {
        this.disconnect(DisconnectReason.HANGUP);
        this.isAudioEnabled = true;
        this.callbacks.onHangup();
    }

    public void switchCamera() {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.switchCamera();
        }
    }

    public void setViews(SurfaceViewRenderer localRender, SurfaceViewRenderer remoteRender, PercentFrameLayout localRenderLayout, PercentFrameLayout remoteRenderLayout) {
        if (this.getState() == WebRTCatState.DISCONNECTED) {
            if (!this.wasConnected()) {
                Log.e((String)TAG, (String)("This method can not be called in state " + (Object)((Object)WebRTCatState.DISCONNECTED)));
                this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
            }
            return;
        }
        if (this.peerConnectionClient == null || this.rootEglBase == null) {
            if (!this.wasConnected()) {
                Log.e((String)TAG, (String)"Can't set views with uninitialized PeerConnectionClient and/or EglBase");
                this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
            }
            return;
        }
        this.localRender = localRender;
        this.remoteRender = remoteRender;
        this.localRenderLayout = localRenderLayout;
        this.remoteRenderLayout = remoteRenderLayout;
        localRender.init(this.rootEglBase.getEglBaseContext(), null);
        remoteRender.init(this.rootEglBase.getEglBaseContext(), null);
        this.peerConnectionClient.setVideoRenderers((VideoRenderer.Callbacks)localRender, (VideoRenderer.Callbacks)remoteRender);
        this.owningActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebRTCat.this.updateVideoView();
            }
        });
    }

    public void call(String destClientName) {
        if (this.getState() != WebRTCatState.READY) {
            if (!this.wasConnected()) {
                Log.e((String)TAG, (String)("This method can only be called in state " + (Object)((Object)WebRTCatState.READY) + " (current state is " + (Object)((Object)this.getState()) + ")"));
                this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
            }
            return;
        }
        if (this.peerConnectionClient == null) {
            if (!this.wasConnected()) {
                Log.e((String)TAG, (String)"Can't set views with uninitialized PeerConnectionClient");
                this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
            }
            return;
        }
        this.destClientName = destClientName;
        this.peerConnectionClient.addLocalMediaStream(this.rootEglBase.getEglBaseContext());
        Log.i((String)TAG, (String)"Creating OFFER...");
        this.peerConnectionClient.createOffer();
        this.transitionState(WebRTCatState.CALLING);
    }

    public void acceptCall() {
        if (this.getState() != WebRTCatState.IN_CALL_OFFER) {
            if (!this.wasConnected()) {
                Log.e((String)TAG, (String)("This method can only be called in state " + (Object)((Object)WebRTCatState.IN_CALL_OFFER) + " (current state is " + (Object)((Object)this.getState()) + ")"));
                this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
            }
            return;
        }
        if (this.peerConnectionClient == null) {
            if (!this.wasConnected()) {
                Log.e((String)TAG, (String)"Can't set views with uninitialized PeerConnectionClient");
                this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
            }
            return;
        }
        this.peerConnectionClient.addLocalMediaStream(this.rootEglBase.getEglBaseContext());
        Log.i((String)TAG, (String)"Creating ANSWER...");
        this.peerConnectionClient.createAnswer();
    }

    public void rejectCall() {
        if (this.getState() != WebRTCatState.IN_CALL_OFFER) {
            if (!this.wasConnected()) {
                Log.e((String)TAG, (String)("This method can only be called in state " + (Object)((Object)WebRTCatState.IN_CALL_OFFER) + " (current state is " + (Object)((Object)this.getState()) + ")"));
                this.callbacks.onError(WebRTCatErrorCode.INTERNAL_STATE_MACHINE_ERROR);
            }
            return;
        }
        this.disconnect(DisconnectReason.CALL_REJECT);
    }

    public WebRTStats getLastStats() {
        return this.lastStats;
    }

    public synchronized WebRTCatState getState() {
        return this.webrtcatState;
    }

    private synchronized void transitionState(WebRTCatState newState) {
        Log.i((String)TAG, (String)("WebRTCat state: " + (Object)((Object)this.webrtcatState) + " -> " + (Object)((Object)newState)));
        this.webrtcatState = newState;
        if (newState == WebRTCatState.READY) {
            this.wasConnected = true;
        }
    }

    private synchronized boolean wasConnected() {
        return this.wasConnected;
    }

    private void updateVideoView() {
        if (this.remoteRender != null && this.remoteRenderLayout != null) {
            this.remoteRenderLayout.setPosition(0, 0, 100, 100);
            this.remoteRender.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            this.remoteRender.setMirror(false);
        }
        if (this.localRender != null && this.localRenderLayout != null) {
            if (this.iceConnected) {
                this.localRenderLayout.setPosition(72, 72, 25, 25);
                this.localRender.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            } else {
                this.localRenderLayout.setPosition(0, 0, 100, 100);
                this.localRender.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            }
            this.localRender.setMirror(true);
        }
        if (this.localRender != null && this.remoteRender != null) {
            this.localRender.requestLayout();
            this.remoteRender.requestLayout();
        }
    }

    private void callConnected() {
        this.owningActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebRTCat.this.transitionState(WebRTCatState.IN_CALL);
                long delta = System.currentTimeMillis() - WebRTCat.this.callStartedTimeMs;
                Log.i((String)WebRTCat.TAG, (String)("Call connected: delay=" + delta + "ms"));
                if (WebRTCat.this.peerConnectionClient == null || WebRTCat.this.isError) {
                    Log.w((String)WebRTCat.TAG, (String)"Call is connected in closed or error state");
                    return;
                }
                WebRTCat.this.updateVideoView();
                WebRTCat.this.peerConnectionClient.enableStatsEvents(true, 1000);
                WebRTCat.this.lastCallStartTime = System.currentTimeMillis();
                WebRTCat.this.callbacks.onCallConnected();
            }
        });
    }

    private void reportError(String description, WebRTCatErrorCode errorCode) {
        this.isError = true;
        Log.e((String)TAG, (String)description);
        this.callbacks.onError(errorCode);
    }

    private class PeerConnectionEventHandler
    implements WebRTCatPeerConnectionClient.PeerConnectionEvents {
        private PeerConnectionEventHandler() {
        }

        @Override
        public void onLocalDescription(SessionDescription sdp) {
            long delta = System.currentTimeMillis() - WebRTCat.this.callStartedTimeMs;
            if (WebRTCat.this.appRtcClient != null) {
                Log.i((String)WebRTCat.TAG, (String)("Sending " + sdp.type + ", delay=" + delta + "ms"));
                if (((WebRTCat)WebRTCat.this).signalingParameters.initiator) {
                    ((WebRTCatClient)WebRTCat.this.appRtcClient).sendOfferSdp(sdp, WebRTCat.this.destClientName);
                } else {
                    WebRTCat.this.appRtcClient.sendAnswerSdp(sdp);
                }
            }
        }

        @Override
        public void onIceCandidate(IceCandidate candidate) {
            if (WebRTCat.this.appRtcClient != null) {
                Log.i((String)WebRTCat.TAG, (String)("Sending LOCAL ICE candidate: " + candidate));
                WebRTCat.this.appRtcClient.sendLocalIceCandidate(candidate);
            }
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            if (WebRTCat.this.appRtcClient != null) {
                WebRTCat.this.appRtcClient.sendLocalIceCandidateRemovals(candidates);
            }
        }

        @Override
        public void onIceConnected() {
            long delta = System.currentTimeMillis() - WebRTCat.this.callStartedTimeMs;
            Log.i((String)WebRTCat.TAG, (String)("ICE connected, delay=" + delta + "ms"));
            WebRTCat.this.iceConnected = true;
            WebRTCat.this.callConnected();
        }

        @Override
        public void onIceFailed() {
            WebRTCat.this.reportError("ICE connection failed", WebRTCatErrorCode.ICE_CONNECTION_FAILED);
        }

        @Override
        public void onIceDisconnected() {
            Log.i((String)WebRTCat.TAG, (String)"ICE disconnected");
            WebRTCat.this.iceConnected = false;
            WebRTCat.this.disconnect(DisconnectReason.ICE_DISCONNECT);
            WebRTCat.this.callbacks.onError(WebRTCatErrorCode.ICE_CONNECTION_FAILED);
        }

        @Override
        public void onPeerConnectionClosed() {
        }

        @Override
        public void onPeerConnectionStatsReady(StatsReport[] reports) {
            WebRTStats stats = new WebRTStats();
            stats.setCallStartTime(WebRTCat.this.lastCallStartTime);
            for (StatsReport report : reports) {
                Log.i((String)WebRTCat.TAG, (String)("*** STAT_REPORT: " + report.toString()));
                if ("googCandidatePair".equals(report.type)) {
                    if (!this.getBooleanStatsReportValue(report.values, "googActiveConnection").booleanValue()) continue;
                    stats.setLocalConnectionType(this.translateCandidateType(this.getStatsReportValue(report.values, "googLocalCandidateType")));
                    stats.setLocalAddress(this.getStatsReportValue(report.values, "googLocalAddress"));
                    stats.setRemoteConnectionType(this.translateCandidateType(this.getStatsReportValue(report.values, "googRemoteCandidateType")));
                    stats.setRemoteAddress(this.getStatsReportValue(report.values, "googRemoteAddress"));
                    stats.setTransportType(this.getStatsReportValue(report.values, "googTransportType"));
                    continue;
                }
                if (!"ssrc".equals(report.type)) continue;
                String codec = this.getStatsReportValue(report.values, "googCodecName");
                Long bytesSent = this.getLongStatsReportValue(report.values, "bytesSent");
                Long bytesReceived = this.getLongStatsReportValue(report.values, "bytesReceived");
                Long packetsLost = this.getLongStatsReportValue(report.values, "packetsLost");
                Long packetsSent = this.getLongStatsReportValue(report.values, "packetsSent");
                Long packetsRecvd = this.getLongStatsReportValue(report.values, "packetsReceived");
                if ("audio".equals(this.getStatsReportValue(report.values, "mediaType"))) {
                    WebRTCAudioStats audioStats = null;
                    if (bytesSent != null) {
                        audioStats = new WebRTCAudioStats(WebRTCMediaStats.MediaDirection.OUTGOING);
                        audioStats.setBytes(bytesSent);
                        audioStats.setPacketsLost(packetsLost);
                        audioStats.setPacketsSentRecvd(packetsSent);
                        stats.setOutAudioStats(audioStats);
                    } else if (bytesReceived != null) {
                        audioStats = new WebRTCAudioStats(WebRTCMediaStats.MediaDirection.INCOMING);
                        audioStats.setBytes(bytesReceived);
                        audioStats.setPacketsLost(packetsLost);
                        audioStats.setPacketsSentRecvd(packetsRecvd);
                        stats.setInAudioStats(audioStats);
                    }
                    if (audioStats == null) continue;
                    audioStats.setCodec(codec);
                    continue;
                }
                WebRTCVideoStats videoStats = null;
                if (bytesSent != null) {
                    videoStats = new WebRTCVideoStats(WebRTCMediaStats.MediaDirection.OUTGOING);
                    videoStats.setBytes(bytesSent);
                    videoStats.setPacketsLost(packetsLost);
                    videoStats.setPacketsSentRecvd(packetsSent);
                    videoStats.setFrameHeight(this.getIntegerStatsReportValue(report.values, "googFrameHeightSent"));
                    videoStats.setFrameWidth(this.getIntegerStatsReportValue(report.values, "googFrameWidthSent"));
                    videoStats.setFrameRate(this.getIntegerStatsReportValue(report.values, "googFrameRateSent"));
                    stats.setOutVideoStats(videoStats);
                } else if (bytesReceived != null) {
                    videoStats = new WebRTCVideoStats(WebRTCMediaStats.MediaDirection.INCOMING);
                    videoStats.setBytes(bytesReceived);
                    videoStats.setPacketsLost(packetsLost);
                    videoStats.setPacketsSentRecvd(packetsRecvd);
                    videoStats.setFrameHeight(this.getIntegerStatsReportValue(report.values, "googFrameHeightReceived"));
                    videoStats.setFrameWidth(this.getIntegerStatsReportValue(report.values, "googFrameWidthReceived"));
                    videoStats.setFrameRate(this.getIntegerStatsReportValue(report.values, "googFrameRateReceived"));
                    stats.setInVideoStats(videoStats);
                }
                if (videoStats == null) continue;
                videoStats.setCodec(codec);
            }
            WebRTCat.this.lastStats = stats;
            WebRTCat.this.callbacks.onStats(stats);
        }

        @Override
        public void onPeerConnectionError(String description) {
            WebRTCat.this.reportError(description, WebRTCatErrorCode.GENERAL_ERROR);
        }

        private String translateCandidateType(String googCandidateType) {
            switch (googCandidateType) {
                case "local": {
                    return "host";
                }
                case "stun": {
                    return "srflx";
                }
            }
            return googCandidateType;
        }

        private Integer getIntegerStatsReportValue(StatsReport.Value[] values, String name) {
            String value = this.getStatsReportValue(values, name);
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Long getLongStatsReportValue(StatsReport.Value[] values, String name) {
            String value = this.getStatsReportValue(values, name);
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Boolean getBooleanStatsReportValue(StatsReport.Value[] values, String name) {
            return "true".equals(this.getStatsReportValue(values, name));
        }

        private String getStatsReportValue(StatsReport.Value[] values, String name) {
            for (StatsReport.Value v : values) {
                if (!name.equals(v.name)) continue;
                return v.value;
            }
            return null;
        }
    }

    private class SignallingEventHandler
    implements WebRTCatClient.SignalingEvents {
        private SignallingEventHandler() {
        }

        @Override
        public void onConnectedToRoom(AppRTCClient.SignalingParameters params) {
            WebRTCat.this.transitionState(WebRTCatState.READY);
            long delta = System.currentTimeMillis() - WebRTCat.this.callStartedTimeMs;
            WebRTCat.this.signalingParameters = params;
            Log.i((String)WebRTCat.TAG, (String)("Creating peer connection, delay=" + delta + "ms"));
            WebRTCat.this.peerConnectionClient.createPeerConnection(WebRTCat.this.rootEglBase.getEglBaseContext(), null, null, WebRTCat.this.signalingParameters);
            if (WebRTCat.this.callbacks.onRoomConnected(((WebRTCat)WebRTCat.this).roomConnectionParameters.roomId, ((WebRTCat)WebRTCat.this).signalingParameters.initiator) && !((WebRTCat)WebRTCat.this).signalingParameters.initiator) {
                if (params.iceCandidates != null) {
                    for (IceCandidate iceCandidate : params.iceCandidates) {
                        Log.i((String)WebRTCat.TAG, (String)("Adding REMOTE ICE candidate: " + iceCandidate));
                        WebRTCat.this.peerConnectionClient.addRemoteIceCandidate(iceCandidate);
                    }
                }
                if (params.offerSdp != null) {
                    WebRTCat.this.peerConnectionClient.setRemoteDescription(params.offerSdp);
                    WebRTCat.this.transitionState(WebRTCatState.IN_CALL_OFFER);
                    WebRTCat.this.callbacks.onIncomingCall();
                }
            }
        }

        @Override
        public void onRemoteDescription(SessionDescription sdp) {
            long delta = System.currentTimeMillis() - WebRTCat.this.callStartedTimeMs;
            if (WebRTCat.this.peerConnectionClient == null) {
                Log.e((String)WebRTCat.TAG, (String)"Received remote SDP for non-initilized peer connection.");
                return;
            }
            Log.i((String)WebRTCat.TAG, (String)("Received remote " + sdp.type + ", delay=" + delta + "ms"));
            WebRTCat.this.peerConnectionClient.setRemoteDescription(sdp);
            if (!((WebRTCat)WebRTCat.this).signalingParameters.initiator) {
                WebRTCat.this.transitionState(WebRTCatState.IN_CALL_OFFER);
                WebRTCat.this.callbacks.onIncomingCall();
            }
        }

        @Override
        public void onRemoteIceCandidate(IceCandidate candidate) {
            if (WebRTCat.this.peerConnectionClient == null) {
                Log.e((String)WebRTCat.TAG, (String)"Received ICE candidate for non-initilized peer connection.");
                return;
            }
            Log.i((String)WebRTCat.TAG, (String)("Adding REMOTE ICE candidate: " + candidate));
            WebRTCat.this.peerConnectionClient.addRemoteIceCandidate(candidate);
        }

        @Override
        public void onRemoteIceCandidatesRemoved(IceCandidate[] candidates) {
            if (WebRTCat.this.peerConnectionClient == null) {
                Log.e((String)WebRTCat.TAG, (String)"Received ICE candidate removals for a non-initialized peer connection.");
                return;
            }
            WebRTCat.this.peerConnectionClient.removeRemoteIceCandidates(candidates);
        }

        @Override
        public void onChannelClose() {
            Log.i((String)WebRTCat.TAG, (String)"Received remote hangup");
            WebRTCatState prevState = WebRTCat.this.getState();
            WebRTCat.this.disconnect(DisconnectReason.HANGUP);
            if (prevState == WebRTCatState.CALLING) {
                WebRTCat.this.callbacks.onCallOfferFailed();
            } else if (prevState == WebRTCatState.IN_CALL_OFFER) {
                WebRTCat.this.callbacks.onIncomingCallCancelled();
            } else {
                WebRTCat.this.callbacks.onHangup();
            }
        }

        @Override
        public void onChannelError(String description) {
            this.onChannelError(description, WebRTCatErrorCode.GENERAL_ERROR);
        }

        @Override
        public void onChannelError(String description, WebRTCatErrorCode errorCode) {
            WebRTCatState prevState = WebRTCat.this.getState();
            WebRTCat.this.disconnect(DisconnectReason.CHANNEL_ERROR);
            if (prevState == WebRTCatState.CALLING && description.contains("RESPONSE_CALLEE_BUSY")) {
                WebRTCat.this.callbacks.onCallOfferFailed();
            } else {
                WebRTCat.this.reportError(description, errorCode);
            }
        }
    }

    public static interface WebRTCatCallbacks {
        public boolean onRoomConnected(String var1, boolean var2);

        public void onIncomingCall();

        public void onIncomingCallCancelled();

        public void onCallConnected();

        public void onCallOfferFailed();

        public void onHangup();

        public void onStats(WebRTStats var1);

        public void onError(WebRTCatErrorCode var1);
    }

    public static enum DisconnectReason {
        HANGUP,
        CLIENT_SHUTDOWN,
        ICE_DISCONNECT,
        CHANNEL_ERROR,
        CALL_REJECT;

    }

    public static enum WebRTCatState {
        DISCONNECTED,
        READY,
        CALLING,
        IN_CALL_OFFER,
        IN_CALL;

    }
}

