/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Tag;
import java.util.Iterator;
import java.util.NoSuchElementException;

class NodeIterator
implements Iterator {
    private final Segment segment;
    private int pos;
    private Tag nextTag;

    public NodeIterator(Segment segment) {
        this.segment = segment;
        if (segment == segment.source) {
            segment.source.fullSequentialParse();
        }
        this.pos = segment.getBegin();
        this.nextTag = segment.source.findNextTag(this.pos);
        if (this.nextTag != null && this.nextTag.getBegin() >= segment.getEnd()) {
            this.nextTag = null;
        }
    }

    public boolean hasNext() {
        return this.pos < this.segment.getEnd() || this.nextTag != null;
    }

    public Segment getNextSegment() {
        int oldPos = this.pos;
        if (this.nextTag != null) {
            if (oldPos < this.nextTag.getBegin()) {
                this.pos = this.nextTag.getBegin();
                return new Segment(this.segment.getSource(), oldPos, this.pos);
            }
            Tag tag = this.nextTag;
            this.nextTag = this.nextTag.findNextTag();
            if (this.nextTag != null && this.nextTag.getBegin() >= this.segment.getEnd()) {
                this.nextTag = null;
            }
            if (this.pos < tag.getEnd()) {
                this.pos = tag.getEnd();
            }
            return tag;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.pos = this.segment.getEnd();
        return new Segment(this.segment.getSource(), oldPos, this.pos);
    }

    public void skipToPos(int pos) {
        if (pos < this.pos) {
            return;
        }
        this.pos = pos;
        this.nextTag = this.segment.source.findNextTag(pos);
    }

    public Object next() {
        return this.getNextSegment();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

