/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagTypeNormal;
import au.id.jericho.lib.html.EndTagTypeUnregistered;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.TagType;

public abstract class EndTagType
extends TagType {
    static final String START_DELIMITER_PREFIX = "</";
    public static final EndTagType UNREGISTERED = EndTagTypeUnregistered.INSTANCE;
    public static final EndTagType NORMAL = EndTagTypeNormal.INSTANCE;

    protected EndTagType(String description, String startDelimiter, String closingDelimiter, boolean isServerTag) {
        super(description, startDelimiter.toLowerCase(), closingDelimiter, isServerTag, START_DELIMITER_PREFIX);
        if (!this.getStartDelimiter().startsWith(START_DELIMITER_PREFIX)) {
            throw new IllegalArgumentException("startDelimiter of an end tag must start with \"</\"");
        }
    }

    public StartTagType getCorrespondingStartTagType() {
        return null;
    }

    public String generateHTML(String startTagName) {
        return this.getStartDelimiter() + startTagName + this.getClosingDelimiter();
    }

    protected final EndTag constructEndTag(Source source, int begin, int end, String name) {
        return new EndTag(source, begin, end, this, name);
    }
}

