/*
 * Decompiled with CFR 0.152.
 */
package net.grobas.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import net.grobas.shapes.PolygonShape;
import net.grobas.shapes.PolygonShapeSpec;
import net.grobas.shapes.RegularPolygonShape;
import net.grobas.view.R;

public class PolygonImageView
extends ImageView {
    private Paint mPaint;
    private Paint mBorderPaint;
    private Path mPath;
    private PolygonShape mPolygonShape;
    private PolygonShapeSpec mPolygonShapeSpec = new PolygonShapeSpec();
    private int canvasWidth;
    private int canvasHeight;

    public PolygonImageView(Context context) {
        this(context, null);
    }

    public PolygonImageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.polygonImageViewStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolygonImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PolygonImageView, defStyle, 0);
        try {
            this.mPolygonShapeSpec.setRotation(attributes.getFloat(R.styleable.PolygonImageView_poly_rotation_angle, 0.0f));
            this.mPolygonShapeSpec.setNumVertex(attributes.getInteger(R.styleable.PolygonImageView_poly_vertices, 6));
            this.mPolygonShapeSpec.setCornerRadius(attributes.getFloat(R.styleable.PolygonImageView_poly_corner_radius, 0.0f));
            this.mPolygonShapeSpec.setHasShadow(attributes.getBoolean(R.styleable.PolygonImageView_poly_shadow, false));
            this.mPolygonShapeSpec.setShadowColor(attributes.getColor(R.styleable.PolygonImageView_poly_shadow_color, -16777216));
            this.mPolygonShapeSpec.setHasBorder(attributes.getBoolean(R.styleable.PolygonImageView_poly_border, false));
            this.mPolygonShapeSpec.setBorderColor(attributes.getColor(R.styleable.PolygonImageView_poly_border_color, -1));
            this.mPolygonShapeSpec.setBorderWidth(attributes.getDimension(R.styleable.PolygonImageView_poly_border_width, 4.0f));
        }
        finally {
            attributes.recycle();
        }
        this.init();
    }

    @SuppressLint(value={"NewApi"})
    private void init() {
        this.mPaint = new Paint(1);
        this.mPaint.setPathEffect((PathEffect)new CornerPathEffect(this.mPolygonShapeSpec.getCornerRadius()));
        this.mBorderPaint = new Paint(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setPathEffect((PathEffect)new CornerPathEffect(this.mPolygonShapeSpec.getCornerRadius()));
        if (this.mPolygonShapeSpec.hasBorder()) {
            this.mBorderPaint.setColor(this.mPolygonShapeSpec.getBorderColor());
            this.mBorderPaint.setStrokeWidth(this.mPolygonShapeSpec.getBorderWidth());
        }
        if (this.mPolygonShapeSpec.hasShadow()) {
            this.mBorderPaint.setShadowLayer(this.mPolygonShapeSpec.getShadowRadius(), this.mPolygonShapeSpec.getShadowXOffset(), this.mPolygonShapeSpec.getShadowYOffset(), this.mPolygonShapeSpec.getShadowColor());
        }
        if (Build.VERSION.SDK_INT > 13) {
            this.setLayerType(1, null);
        }
        this.mPolygonShape = new RegularPolygonShape();
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.canvasWidth = w;
        this.canvasHeight = h;
        this.updatePolygonSize();
        if (Math.min(this.canvasWidth, this.canvasHeight) != Math.min(oldW, oldH)) {
            this.refreshImage();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureWidth(widthMeasureSpec);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureWidth(int measureSpecWidth) {
        return this.measure(measureSpecWidth);
    }

    private int measureHeight(int measureSpecHeight) {
        return this.measure(measureSpecHeight) + 2;
    }

    private int measure(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 || specMode == Integer.MIN_VALUE ? specSize : Math.min(this.canvasWidth, this.canvasHeight);
        return result;
    }

    protected void onDraw(@NonNull Canvas canvas) {
        if (this.getDrawable() == null || this.getDrawable().getIntrinsicWidth() == 0 || this.getDrawable().getIntrinsicHeight() == 0) {
            return;
        }
        switch (this.mPolygonShapeSpec.getNumVertex()) {
            case 0: {
                if (this.mPolygonShapeSpec.hasShadow() || this.mPolygonShapeSpec.hasBorder()) {
                    canvas.drawCircle(this.mPolygonShapeSpec.getCenterX(), this.mPolygonShapeSpec.getCenterY(), this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mBorderPaint);
                }
                canvas.drawCircle(this.mPolygonShapeSpec.getCenterX(), this.mPolygonShapeSpec.getCenterY(), this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPaint);
                break;
            }
            case 1: {
                super.onDraw(canvas);
                break;
            }
            case 2: {
                if (this.mPolygonShapeSpec.hasShadow() || this.mPolygonShapeSpec.hasBorder()) {
                    canvas.drawRect(this.mPolygonShapeSpec.getCenterX() - this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPolygonShapeSpec.getCenterY() - this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPolygonShapeSpec.getCenterX() + this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPolygonShapeSpec.getCenterY() + this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mBorderPaint);
                }
                canvas.drawRect(this.mPolygonShapeSpec.getCenterX() - this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPolygonShapeSpec.getCenterY() - this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPolygonShapeSpec.getCenterX() + this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPolygonShapeSpec.getCenterY() + this.mPolygonShapeSpec.getDiameter() / 2.0f, this.mPaint);
                break;
            }
            default: {
                if (this.mPolygonShapeSpec.hasShadow() || this.mPolygonShapeSpec.hasBorder()) {
                    canvas.drawPath(this.mPath, this.mBorderPaint);
                }
                canvas.drawPath(this.mPath, this.mPaint);
            }
        }
    }

    @TargetApi(value=17)
    public void setPaddingRelative(int start, int top, int end, int bottom) {
        super.setPaddingRelative(start, top, end, bottom);
        this.updatePolygonSize();
        this.invalidate();
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.updatePolygonSize(left, top, right, bottom);
        this.invalidate(left, top, right, bottom);
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.refreshImage();
        this.invalidate();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.refreshImage();
        this.invalidate();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.refreshImage();
        this.invalidate();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.refreshImage();
        this.invalidate();
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
        this.invalidate();
    }

    public void setColorFilterWithBorder(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
        this.mBorderPaint.setColorFilter(cf);
        this.invalidate();
    }

    private void refreshImage() {
        Bitmap image = PolygonImageView.drawableToBitmap(this.getDrawable());
        int canvasSize = Math.min(this.canvasWidth, this.canvasHeight);
        if (canvasSize > 0 && image != null) {
            BitmapShader shader = new BitmapShader(ThumbnailUtils.extractThumbnail((Bitmap)image, (int)canvasSize, (int)canvasSize), Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mPaint.setShader((Shader)shader);
        }
    }

    private void rebuildPolygon() {
        float borderNeeded = this.mPolygonShapeSpec.hasBorder() ? this.mPolygonShapeSpec.getBorderWidth() : 0.0f;
        float shadowNeeded = this.mPolygonShapeSpec.hasShadow() ? this.mPolygonShapeSpec.getShadowRadius() : 0.0f;
        this.mPolygonShapeSpec.setCenterX(this.mPolygonShapeSpec.getDiameter() / 2.0f + (float)(this.getPaddingLeft() + this.getPaddingRight()) / 2.0f + borderNeeded + shadowNeeded);
        this.mPolygonShapeSpec.setCenterY(this.mPolygonShapeSpec.getDiameter() / 2.0f + (float)(this.getPaddingTop() + this.getPaddingBottom()) / 2.0f + borderNeeded + shadowNeeded);
        if (this.mPolygonShapeSpec.getNumVertex() < 3) {
            return;
        }
        this.mPath = this.mPolygonShape.getPolygonPath(this.mPolygonShapeSpec);
    }

    private void updatePolygonSize() {
        this.updatePolygonSize(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
    }

    private void updatePolygonSize(int l, int t, int r, int b) {
        float yPadding;
        float shadowPadding;
        if (this.mPolygonShapeSpec == null) {
            return;
        }
        float borderPadding = this.mPolygonShapeSpec.hasBorder() ? this.mPolygonShapeSpec.getBorderWidth() : 0.0f;
        float xPadding = (float)(l + r) + borderPadding * 2.0f + (shadowPadding = this.mPolygonShapeSpec.hasShadow() ? this.mPolygonShapeSpec.getShadowRadius() : 0.0f) * 2.0f;
        float diameter = Math.min((float)this.canvasWidth - xPadding, (float)this.canvasHeight - (yPadding = (float)(t + b) + borderPadding * 2.0f + shadowPadding * 2.0f));
        if (diameter != this.mPolygonShapeSpec.getDiameter()) {
            this.mPolygonShapeSpec.setDiameter(diameter);
            this.rebuildPolygon();
        }
    }

    public void setPolygonShape(PolygonShape polygonShape) {
        this.mPolygonShape = polygonShape;
        this.rebuildPolygon();
        this.invalidate();
    }

    public PolygonShape getPolygonShape() {
        return this.mPolygonShape;
    }

    public PolygonShapeSpec getPolygonShapeSpec() {
        return this.mPolygonShapeSpec;
    }

    public void setPolygonShapeSpec(PolygonShapeSpec spec) {
        this.mPolygonShapeSpec = spec;
    }

    public float getRotationAngle() {
        return this.mPolygonShapeSpec.getRotation();
    }

    public void setRotationAngle(float mAngle) {
        this.mPolygonShapeSpec.setRotation(mAngle);
        this.rebuildPolygon();
        this.invalidate();
    }

    public int getVertices() {
        return this.mPolygonShapeSpec.getNumVertex();
    }

    public void setVertices(int numVertices) {
        this.mPolygonShapeSpec.setNumVertex(numVertices);
        this.rebuildPolygon();
        this.invalidate();
    }

    public boolean isBordered() {
        return this.mPolygonShapeSpec.hasBorder();
    }

    public void setBorder(boolean bordered) {
        this.mPolygonShapeSpec.setHasBorder(bordered);
        this.updateBorderSpecs();
    }

    public void setBorderWidth(float borderWidth) {
        this.mPolygonShapeSpec.setBorderWidth(borderWidth * this.getResources().getDisplayMetrics().density);
        this.updateBorderSpecs();
    }

    private void updateBorderSpecs() {
        if (this.mPolygonShapeSpec.hasBorder()) {
            this.mBorderPaint.setStrokeWidth(this.mPolygonShapeSpec.getBorderWidth());
            this.mBorderPaint.setColor(this.mPolygonShapeSpec.getBorderColor());
        } else {
            this.mBorderPaint.setStrokeWidth(0.0f);
            this.mBorderPaint.setColor(0);
        }
        this.updatePolygonSize();
        this.invalidate();
    }

    public void setBorderColor(int borderColor) {
        this.mPolygonShapeSpec.setBorderColor(borderColor);
        this.mBorderPaint.setColor(borderColor);
        this.invalidate();
    }

    public void setBorderColorResource(@ColorRes int resourceBorderColor) {
        this.setBorderColor(this.getResources().getColor(resourceBorderColor));
    }

    public void addBorder(float borderWidth, int borderColor) {
        this.mPolygonShapeSpec.setHasBorder(true);
        this.mPolygonShapeSpec.setBorderWidth(borderWidth * this.getResources().getDisplayMetrics().density);
        this.mPolygonShapeSpec.setBorderColor(borderColor);
        this.updateBorderSpecs();
    }

    public void addBorderResource(float borderWidth, @ColorRes int resourceBorderColor) {
        this.addBorder(borderWidth, this.getResources().getColor(resourceBorderColor));
    }

    public void setCornerRadius(float cornerRadius) {
        this.mPolygonShapeSpec.setCornerRadius(cornerRadius);
        this.mBorderPaint.setPathEffect((PathEffect)new CornerPathEffect(cornerRadius));
        this.mPaint.setPathEffect((PathEffect)new CornerPathEffect(cornerRadius));
        this.invalidate();
    }

    public void addShadow() {
        this.startShadow();
    }

    public void addShadow(float radius, float offsetX, float offsetY, int color) {
        this.mPolygonShapeSpec.setShadowRadius(radius);
        this.mPolygonShapeSpec.setShadowXOffset(offsetX);
        this.mPolygonShapeSpec.setShadowYOffset(offsetY);
        this.mPolygonShapeSpec.setShadowColor(color);
        this.startShadow();
    }

    public void addShadowResource(float radius, float offsetX, float offsetY, @ColorRes int color) {
        this.addShadow(radius, offsetX, offsetY, this.getResources().getColor(color));
    }

    private void startShadow() {
        this.mPolygonShapeSpec.setHasShadow(true);
        this.mBorderPaint.setShadowLayer(this.mPolygonShapeSpec.getShadowRadius(), this.mPolygonShapeSpec.getShadowXOffset(), this.mPolygonShapeSpec.getShadowYOffset(), this.mPolygonShapeSpec.getShadowColor());
        this.updatePolygonSize();
        this.invalidate();
    }

    public void clearShadow() {
        if (!this.mPolygonShapeSpec.hasShadow()) {
            return;
        }
        this.mPolygonShapeSpec.setHasShadow(false);
        this.mBorderPaint.clearShadowLayer();
        this.updatePolygonSize();
        this.invalidate();
    }

    private static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap;
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int width = drawable.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable.getIntrinsicHeight();
        height = height > 0 ? height : 1;
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"PolygonImageView", (String)"OutOfMemory during bitmap creation");
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }
}

