/*
 * Decompiled with CFR 0.152.
 */
package net.grobas.shapes;

import java.util.List;
import net.grobas.shapes.BasePolygonShape;
import net.grobas.view.util.GeometryUtil;

public class StarPolygonShape
extends BasePolygonShape {
    private float radiusScale;
    private boolean isConcave;

    public StarPolygonShape(float valor, boolean isConcave) {
        this.radiusScale = valor;
        this.isConcave = isConcave;
    }

    @Override
    protected void addEffect(float currentX, float currentY, float nextX, float nextY) {
        float cX = this.getPolygonShapeSpec().getCenterX();
        float cY = this.getPolygonShapeSpec().getCenterY();
        float radius = this.getPolygonShapeSpec().getDiameter() / 2.0f * this.radiusScale;
        float pX = (currentX + nextX) / 2.0f;
        float pY = (currentY + nextY) / 2.0f;
        List<GeometryUtil.Point> p = GeometryUtil.getCircleLineIntersectionPoint(new GeometryUtil.Point(pX, pY), new GeometryUtil.Point(cX, cY), new GeometryUtil.Point(cX, cY), radius);
        if (this.isConcave) {
            this.getPath().quadTo((float)p.get((int)0).x, (float)p.get((int)0).y, nextX, nextY);
        } else {
            this.getPath().lineTo((float)p.get((int)0).x, (float)p.get((int)0).y);
            this.getPath().lineTo(nextX, nextY);
        }
    }

    public boolean isConcave() {
        return this.isConcave;
    }

    public void setIsConcave(boolean isConcave) {
        this.isConcave = isConcave;
    }

    public float getRadiusScale() {
        return this.radiusScale;
    }

    public void setRadiusScale(float radiusScale) {
        this.radiusScale = radiusScale;
    }
}

