/*
 * Decompiled with CFR 0.152.
 */
package net.gpedro.integrations.slack;

import com.google.gson.JsonObject;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import net.gpedro.integrations.slack.SlackApiException;
import net.gpedro.integrations.slack.SlackMessage;

public class SlackWebhook {
    private final String address;

    public SlackWebhook(String address) {
        if (address == null) {
            throw new IllegalArgumentException("Address cannot be null");
        }
        this.address = address;
    }

    public void call(SlackMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        this.send(message.prepare());
    }

    private void send(JsonObject message) {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(this.address).post(new FormEncodingBuilder().add("payload", message.toString()).build()).build();
        try {
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new SlackApiException("Slack webhook failed. HTTP status code: " + response.code());
            }
        }
        catch (IOException e) {
            throw new SlackApiException("Unexpected error", e);
        }
    }
}

