/*
 * Decompiled with CFR 0.152.
 */
package net.gpedro.integrations.slack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.gpedro.integrations.slack.SlackAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlackMessage {
    private List<SlackAttachment> attach = new ArrayList<SlackAttachment>();
    private String channel = null;
    private String icon = null;
    private JsonObject slackMessage = new JsonObject();
    private String text = null;
    private String username = null;

    public SlackMessage(String text) {
        this.text = text;
    }

    public SlackMessage(String username, String text) {
        this(text);
        this.username = username;
    }

    public SlackMessage(String channel, String username, String text) {
        this(username, text);
        this.channel = channel;
    }

    public SlackMessage addAttachments(SlackAttachment ... otherAttachments) {
        this.attach.addAll(Arrays.asList(otherAttachments));
        return this;
    }

    public JsonObject prepare() {
        if (this.channel != null) {
            this.slackMessage.addProperty("channel", this.channel);
        }
        if (this.username != null) {
            this.slackMessage.addProperty("username", this.username);
        }
        if (this.icon != null) {
            if (this.icon.contains("http")) {
                this.slackMessage.addProperty("icon_url", this.icon);
            } else {
                this.slackMessage.addProperty("icon_emoji", this.icon);
            }
        }
        if (this.text == null) {
            throw new IllegalArgumentException("Missing Text field @ SlackMessage");
        }
        this.slackMessage.addProperty("text", this.text);
        if (this.attach != null && this.attach.size() > 0) {
            this.slackMessage.add("attachments", (JsonElement)this.prepareAttach());
        }
        return this.slackMessage;
    }

    private JsonArray prepareAttach() {
        JsonArray attachs = new JsonArray();
        for (SlackAttachment attach : this.attach) {
            attachs.add((JsonElement)attach.toJson());
        }
        return attachs;
    }

    public SlackMessage removeAttachment(int index) {
        this.attach.remove(index);
        return this;
    }

    public SlackMessage setAttachments(ArrayList<SlackAttachment> attach) {
        this.attach = new ArrayList<SlackAttachment>(attach);
        return this;
    }

    public SlackMessage setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public SlackMessage setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public SlackMessage setText(String message) {
        this.text = message;
        return this;
    }

    public SlackMessage setUsername(String username) {
        this.username = username;
        return this;
    }
}

